package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 发货实体
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";

    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IWeighDetailService weighDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public DeliveryVO queryDetails(Long id) {

        OrderEntity entity = orderService.selectById(id);
        DeliveryVO deliveryVO = BeanMapper.map(entity, DeliveryVO.class);
        //新增逻辑处理
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        deliveryVO.setTenantId(entity.getSupplierTenantId());
        return deliveryVO;
    }
    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        //查询订单基础数据
        OrderEntity orderEntity = orderService.getById(deliveryVO.getOrderId());
        deliveryVO.setProjectId(orderEntity.getProjectId());
        deliveryVO.setProjectName(orderEntity.getProjectName());
        deliveryVO.setOrgId(orderEntity.getOrgId());
        deliveryVO.setOrgName(orderEntity.getOrgName());
        deliveryVO.setContractId(orderEntity.getContractId());
        deliveryVO.setContractName(orderEntity.getContractName());
        deliveryVO.setSupplierId(orderEntity.getSupplierId());
        deliveryVO.setSupplierName(orderEntity.getSupplierName());
        deliveryVO.setProjectSourceId(orderEntity.getProjectSourceId());
        deliveryVO.setOrderBillCode(orderEntity.getBillCode());
        deliveryVO.setParentOrgId(orderEntity.getParentOrgId());
        deliveryVO.setParentOrgSourceId(orderEntity.getParentOrgSourceId());
        deliveryVO.setOrgSourceId(orderEntity.getOrgSourceId());
        deliveryVO.setSupplierSourceId(orderEntity.getSupplierSourceId());
        deliveryVO.setSmartStatus(orderEntity.getSmartStatus());
        deliveryVO.setPlatformCode(orderEntity.getPlatformCode());
        deliveryVO.setPlatformType(orderEntity.getPlatformType());
        DeliveryEntity entity = BeanMapper.map(deliveryVO, DeliveryEntity.class);

        //汇总物资明细名称
        List<DeliveryDetailEntity> deliveryDetail = entity.getDeliveryDetail();

        String materialName = "";
        if(deliveryDetail != null && deliveryDetail.size() > 0){
            //查询订单明细
            List<Long> orderDetailIds = deliveryDetail.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<OrderDetailEntity> queryWrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
            queryWrapperOrderDetail.in(OrderDetailEntity::getId, orderDetailIds);
            List<OrderDetailEntity> orderDetailEntityList = orderDetailService.list(queryWrapperOrderDetail);
            if(CollectionUtils.isNotEmpty(orderDetailEntityList)){

                Map<Long, OrderDetailEntity> orderDetailEntityMap = orderDetailEntityList.stream().collect(Collectors.toMap(OrderDetailEntity::getId, Function.identity()));
                deliveryDetail.forEach(deliveryDetailEntity -> {
                    OrderDetailEntity orderDetailEntity = orderDetailEntityMap.get(deliveryDetailEntity.getOrderDetailId());
                    if (null != orderDetailEntity){
                        deliveryDetailEntity.setOrderId(orderDetailEntity.getOrderId());
                        deliveryDetailEntity.setMaterialId(orderDetailEntity.getMaterialId());
                        deliveryDetailEntity.setMaterialName(orderDetailEntity.getMaterialName());
                        deliveryDetailEntity.setMaterialTypeId(orderDetailEntity.getMaterialTypeId());
                        deliveryDetailEntity.setMaterialTypeName(orderDetailEntity.getMaterialTypeName());
                        deliveryDetailEntity.setMaterialCode(orderDetailEntity.getMaterialCode());
                        deliveryDetailEntity.setUnit(orderDetailEntity.getUnit());
                        deliveryDetailEntity.setSpec(orderDetailEntity.getSpec());
                        deliveryDetailEntity.setReceiveNumsSum(orderDetailEntity.getReceiveNumsSum());
                        deliveryDetailEntity.setOrderNumsSum(orderDetailEntity.getOrderNumsSum());
                        deliveryDetailEntity.setSmartStatus(orderDetailEntity.getSmartStatus());
                        orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                        orderDetailEntityMap.put(deliveryDetailEntity.getOrderDetailId(),orderDetailEntity);
                    }
                });
                //回写订单数据
                List<OrderDetailEntity> orderDetailEntities= orderDetailEntityMap.entrySet().stream().map(et ->et.getValue()).collect(Collectors.toList());
                //更新订单发货数量
                boolean flagOrder = orderDetailService.updateBatchById(orderDetailEntities);
                if (!flagOrder){
                    throw new BusinessException("网络异常，发货数量更新失败，请稍后再试");
                }
                //回写订单状态
                LambdaQueryWrapper<OrderDetailEntity> wrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
                wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, deliveryVO.getOrderId());
                wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, false);
                List<OrderDetailEntity> orderDetailList = orderDetailService.list(wrapperOrderDetail);
                if (orderDetailList != null && orderDetailList.size() > 0){
                    Boolean b = true;
                    for (OrderDetailEntity orderDetailEntity : orderDetailList){
                        BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                        BigDecimal deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum();
                        if (receiveNumsSum.compareTo(deliverNumsSum) == 1){
                            b = false;
                        }
                    }
                    if (b){
                        //修改订单发货装状态
                        LambdaUpdateWrapper<OrderEntity> updateOrderWrapper = new LambdaUpdateWrapper<>();
                        updateOrderWrapper.eq(OrderEntity::getId, deliveryVO.getOrderId());
                        updateOrderWrapper.set(OrderEntity::getDeliverState, 1);
                        boolean updateFlagOrder = orderService.update(updateOrderWrapper);
                        if (!updateFlagOrder){
                            throw new BusinessException("网络异常，订单发货状态更新失败，请稍后再试");
                        }
                    }

                }
            }
            for(DeliveryDetailEntity deliveryDetailEntity : deliveryDetail){
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        deliveryService.saveOrUpdate(entity, false);

        // TO DO 发货消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        OrderEntity orderEntityInfo = orderService.getById(deliveryVO.getOrderId());
        sender.add(String.valueOf(orderEntityInfo.getCommitId()));
        String formurl = baseHost+"ejc-wzxt-frontend/#/purchaseOrder/card?id="+orderEntityInfo.getId();
        String subject = "您的订单【"+orderEntityInfo.getProjectName()+"+"+orderEntityInfo.getBillCode()+"】已发货，请及时验收!";
        String content = "您的订单【"+orderEntityInfo.getProjectName()+"+"+orderEntityInfo.getBillCode()+"】已发货，请到企业微信验收!";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntityInfo.getTenantId()));
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<DeliveryVO> deliver(Long id) {
        //修改发货和单据状态
        LambdaUpdateWrapper<DeliveryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(DeliveryEntity::getId, id);
        updateWrapper.set(DeliveryEntity::getBillState, 1);
        updateWrapper.set(DeliveryEntity::getDeliverState, 1);
        boolean flag = deliveryService.update(updateWrapper);
        if (!flag){
            throw new BusinessException("网络异常，发货状态更新失败，请稍后再试");
        }

        //回写订单的发货单
        LambdaQueryWrapper<DeliveryDetailEntity> queryWrapperDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, id);
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0){
            List<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            //查询订单详情
            LambdaQueryWrapper<OrderDetailEntity> queryWrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
            queryWrapperOrderDetail.in(OrderDetailEntity::getId, orderDetailIdList);
            List<OrderDetailEntity> orderDetailEntityList = orderDetailService.list(queryWrapperOrderDetail);
            //回写发货单详情-发货量
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList){
                    if (deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())){
                        orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                    }
                }
            }
            //更新订单发货数量
            boolean flagOrder = orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder){
                throw new BusinessException("网络异常，发货数量更新失败，请稍后再试");
            }
            //回写订单状态
            DeliveryEntity entity = deliveryService.selectById(id);
            LambdaQueryWrapper<OrderDetailEntity> wrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
            wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, entity.getOrderId());
            wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, false);
            List<OrderDetailEntity> orderDetailList = orderDetailService.list(wrapperOrderDetail);
            if (orderDetailList != null && orderDetailList.size() > 0){
                Boolean b = true;
                for (OrderDetailEntity orderDetailEntity : orderDetailList){
                    BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                    BigDecimal deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum();
                    if (receiveNumsSum.compareTo(deliverNumsSum) == 1){
                        b = false;
                    }
                }
                if (b){
                    //修改发货和单据状态
                    LambdaUpdateWrapper<OrderEntity> updateOrderWrapper = new LambdaUpdateWrapper<>();
                    updateOrderWrapper.eq(OrderEntity::getId, entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, 1);
                    boolean updateFlagOrder = orderService.update(updateOrderWrapper);
                    if (!updateFlagOrder){
                        throw new BusinessException("网络异常，订单发货状态更新失败，请稍后再试");
                    }
                }

            }
        }
        // TO DO 发货消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        DeliveryEntity entity = deliveryService.selectById(id);
        OrderEntity orderEntity = orderService.getById(entity.getOrderId());
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String formurl = baseHost+"ejc-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "您的订单【"+orderEntity.getProjectName()+"+"+orderEntity.getBillCode()+"】已发货，请及时验收!";
        String content = "您的订单【"+orderEntity.getProjectName()+"+"+orderEntity.getBillCode()+"】已发货，请到企业微信验收!";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()));
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("发货成功！",vo);
    }

    @Override
    public DeliveryVO weighCheck(DeliveryCheckVO deliveryCheckVO) throws Exception {
        DeliveryEntity deliveryEntity = super.getById(deliveryCheckVO.getDeliveryId());
        DeliveryVO deliveryVO = BeanMapper.map(deliveryEntity, DeliveryVO.class);
        //根据发货单主键查询计划的创建人
        LambdaQueryWrapper<DeliveryDetailEntity> lambda = Wrappers.<DeliveryDetailEntity>lambdaQuery();
        lambda.eq(DeliveryDetailEntity::getDeliveryId,deliveryCheckVO.getDeliveryId());
        List<DeliveryDetailEntity> details  = deliveryDetailService.list(lambda);
        List<Long> orderDetailsId = details.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderDetailsId)){
            String queryPlanEmployName = orderDetailService.queryPlanEmployName(orderDetailsId);
            deliveryVO.setChecker(queryPlanEmployName);
        }
        //获取榜单信息
        List<WeighBillVO> weighBillVOList = getWeighListByPks(deliveryCheckVO.getPkWeighBillList());
        deliveryVO.setPkWeighBillList(deliveryCheckVO.getPkWeighBillList());
        deliveryVO.setDeliveryCarNumber("共" + weighBillVOList.size() + "车次");
        deliveryVO.setDeliveryDetailVOList(dealInfoData(deliveryVO, weighBillVOList));
//        deliveryVO.setSceneurl(dealImg(weighDeliveryRequest.getPkWeighBillList()));
        return deliveryVO;
    }

    @Override
    public DeliveryVO oneKeyCheck(DeliveryCheckVO deliveryCheckVO)  {
        DeliveryEntity deliveryEntity = super.getById(deliveryCheckVO.getDeliveryId());
        DeliveryVO deliveryVO = BeanMapper.map(deliveryEntity, DeliveryVO.class);
        //根据发货单主键查询计划的创建人
        LambdaQueryWrapper<DeliveryDetailEntity> lambda = Wrappers.<DeliveryDetailEntity>lambdaQuery();
        lambda.eq(DeliveryDetailEntity::getDeliveryId,deliveryCheckVO.getDeliveryId());
        List<DeliveryDetailEntity> details  = deliveryDetailService.list(lambda);
        List<Long> orderDetailsId = details.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderDetailsId)){
            String queryPlanEmployName = orderDetailService.queryPlanEmployName(orderDetailsId);
            deliveryVO.setChecker(queryPlanEmployName);
        }
        //获取榜单信息
        List<WeighBillVO> weighBillVOList = null;
        try {
            weighBillVOList = getWeighListByDelivery(deliveryEntity.getHistoryId());
        } catch (Exception e) {
            e.printStackTrace();
        }
        List<String> pkWeighBillList = weighBillVOList.stream().map(WeighBillVO::getPkWeighBill).collect(Collectors.toList());
        deliveryVO.setPkWeighBillList(pkWeighBillList);
        deliveryVO.setDeliveryCarNumber("共" + weighBillVOList.size() + "车次");
        try {
            deliveryVO.setDeliveryDetailVOList(dealInfoData(deliveryVO, weighBillVOList));
        } catch (Exception e) {
            e.printStackTrace();
        }
//        deliveryVO.setSceneurl(dealImg(weighDeliveryRequest.getPkWeighBillList()));
        return deliveryVO;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
//        if (messageType.contains("weChat")) {
//            JSONObject weixineeParams = new JSONObject();
//            weixineeParams.put("agentid", cgddAgentid);
//            weixineeParams.put("secret", cgddSecret);
//            weixineeParams.put("content", subject);
//            parameter.setWeixineeParams(weixineeParams);
//        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
    public List<WeighBillVO>  getWeighListByPks(List<String> pkWeighBill) throws Exception {
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if(tokenres.isSuccess()){
            logger.info("获取供方token--"+headers);
            WeighIdsQuery weighIdsQuery = new WeighIdsQuery();
            weighIdsQuery.setPkWeighs(pkWeighBill);
            String url = "http://47.94.227.96:9001/el/sw/weigh/list";
            String back = null;
                back = HttpTookit.postByJson(url, JSONObject.toJSON(weighIdsQuery).toString(), headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if("200".equals(jsonBack.getString("code"))){
                    //调用同步方法成功
                    return JSONArray.parseArray(((JSONArray) jsonBack.get("body")).toJSONString(), WeighBillVO.class);
                }else{
                    //调用同步方法失败，输出错误信息
                    throw new BusinessException(jsonBack.getString("msg"));
                }
        }else {
            throw new BusinessException("获取token失败,请刷新后重试!");
        }

    }
    public List<WeighBillVO>  getWeighListByDelivery(String pkDelivery) throws Exception {
        Map<String, String> headers = new HashMap<>();
        Map<String, Object> param = new HashMap<>();
        param.put("checkStatus",0);
        param.put("pkDelivery",pkDelivery);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if(tokenres.isSuccess()){
            logger.info("获取供方token--"+headers);
            String url = "http://47.94.227.96:9001/el/sw/weigh/delivery/list?checkStatus=0&pkDelivery=" + pkDelivery;
            String back = null;
                back = HttpTookit.get(url,param,headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if("200".equals(jsonBack.getString("code"))){
                    //调用同步方法成功
                    return JSONArray.parseArray(((JSONArray) jsonBack.get("body")).toJSONString(), WeighBillVO.class);
                }else{
                    //调用同步方法失败，输出错误信息
                    throw new BusinessException(jsonBack.getString("msg"));
                }
        }else {
            throw new BusinessException("获取token失败,请刷新后重试!");
        }

    }

    private List<DeliveryDetailVO> dealInfoData(DeliveryVO delivery, List<WeighBillVO> weighBillVOList) throws Exception {
        Map<String, DeliveryDetailEntity> infoMap = new HashMap<>();
        List<String> gcList = new ArrayList<>();
        BigDecimal sumWeight = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(weighBillVOList)){
            for(WeighBillVO weighBillVO : weighBillVOList){
                DeliveryDetailEntity info;
                if(!infoMap.containsKey(weighBillVO.getPkDeliveryB())){
                    LambdaQueryWrapper<DeliveryDetailEntity> lambda = Wrappers.<DeliveryDetailEntity>lambdaQuery();
                    lambda.eq(DeliveryDetailEntity::getHistoryId,weighBillVO.getPkDeliveryB());
                    info = deliveryDetailService.getOne(lambda);
                }else{
                    info = infoMap.get(weighBillVO.getPkDeliveryB());
                }
                convertUnit(weighBillVO);
                gcList.add(getGcDateString(weighBillVO.getTareTime()) + "-" + weighBillVO.getPlateNumber() + "-" + weighBillVO.getNetWeight().setScale(0, BigDecimal.ROUND_HALF_UP) + "千克");
                sumWeight = sumWeight.add(weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight());
                dealInfoNet(info, weighBillVO);
                infoMap.put(weighBillVO.getPkDeliveryB(), info);
            }
        }
        delivery.setCheckprocess(org.apache.commons.lang3.StringUtils.join(gcList, ";") + ";共" + weighBillVOList.size() + "车次;合计" + sumWeight.setScale(0, BigDecimal.ROUND_HALF_UP) + "千克");
        List<DeliveryDetailEntity> infoList = new ArrayList<>(infoMap.values());
        List<Long> pkMaterialList = infoList.stream().map(DeliveryDetailEntity::getMaterialId).collect(Collectors.toList());
        //根据项目部主键和物料主键查询物料智能称重设置
        LambdaQueryWrapper<WeighDetailEntity> lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
        lambda.eq(WeighDetailEntity::getOrgId,delivery.getOrgId());
        lambda.in(WeighDetailEntity::getMaterialId,pkMaterialList);
        List<WeighDetailEntity> details  = weighDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            Map<Long, BigDecimal> orgmatMap = details.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
            infoList.forEach(deliveryDetailEntity -> {
                deliveryDetailEntity.setTransformRate(orgmatMap.get(deliveryDetailEntity.getMaterialId()));
            });
        }
        return BeanMapper.mapList(infoList, DeliveryDetailVO.class);
    }
    /**
     * 处理单位，统一转为kg
     * @param weighBillVO
     */
    private void convertUnit(WeighBillVO weighBillVO){
        String weightUnit = weighBillVO.getWeightUnit();
        if("千克".equals(weightUnit) || "公斤".equals(weightUnit)
                || "KG".equals(weightUnit) || "Kg".equals(weightUnit) || "kg".equals(weightUnit)){
            weighBillVO.setWeightUnit("kg");
        }else if("吨".equals(weightUnit) || "T".equals(weightUnit) || "t".equals(weightUnit)){
            weighBillVO.setWeightUnit("kg");
            weighBillVO.setNetWeight(weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight().multiply(new BigDecimal(1000)));
        }else{
            weighBillVO.setWeightUnit("kg");
        }
    }
    private String getGcDateString(String dateStr){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(dateStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return (calendar.get(Calendar.MONTH) + 1) + "月" + calendar.get(Calendar.DAY_OF_MONTH) + "日";
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return "";
    }
    /**
     * 处理净重
     * @param info
     * @param weighBillVO
     */
    private void dealInfoNet(DeliveryDetailEntity info, WeighBillVO weighBillVO) {
        BigDecimal infoNum = info.getNetWeight() == null ? BigDecimal.ZERO : info.getNetWeight();
        BigDecimal weighNum = weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight();
        info.setNetWeight(infoNum.add(weighNum));
    }
}
