package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.WeighMapper;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.service.IWeighService;

/**
 * 智能称重实体
 * 
 * @author generator
 * 
 */
@Service("weighService")
public class WeighServiceImpl extends BaseServiceImpl<WeighMapper, WeighEntity> implements IWeighService{

    @Override
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighEntity> queryWrapperWeigh = Wrappers.<WeighEntity>lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, projectDepartmentId);
        WeighEntity weigh = super.getOne(queryWrapperWeigh);
        if (weigh != null) {
            WeighVO vo = BeanMapper.map(weigh, WeighVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }
}
