/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orderDetail"})
public class OrderDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderDetailService service;
    @Autowired
    private IPlanService planService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderDetailVO> saveOrUpdate(@RequestBody OrderDetailVO saveorUpdateVO) {
        OrderDetailEntity entity = (OrderDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrderDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        OrderDetailVO vo = (OrderDetailVO)BeanMapper.map((Object)((Object)entity), OrderDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderDetailVO> queryDetail(Long id) {
        OrderDetailEntity entity = (OrderDetailEntity)((Object)this.service.selectById(id));
        OrderDetailVO vo = (OrderDetailVO)BeanMapper.map((Object)((Object)entity), OrderDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryOrderDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PlanVO>> queryList(Long orderDetailId) {
        List reslist = new ArrayList();
        OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)this.service.getById(orderDetailId));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetailEntity.getOrderId());
        lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetailEntity.getTid());
        lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
        List details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            ArrayList pks = new ArrayList();
            pks.addAll(details.stream().map(OrderDetailEntity::getPlanId).collect(Collectors.toList()));
            Map<Long, BigDecimal> map = details.stream().collect(Collectors.toMap(OrderDetailEntity::getPlanId, OrderDetailEntity::getPlanNumsSum));
            reslist = (List)this.planService.listByIds(pks);
            reslist.forEach(e -> e.setDef1("" + map.get(e.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList(reslist, PlanVO.class));
    }

    @RequestMapping(value={"orderDetailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderDetailVO>> orderDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialCode");
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("orderId")) {
            Long orderId = Long.valueOf(conditionMap.get("orderId").toString());
            queryParam.getParams().put("order_id", new Parameter("eq", (Object)orderId));
        }
        queryParam.getParams().put("leaf_flag", new Parameter("eq", (Object)false));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.apply("IFNULL(receive_nums_sum,0) > IFNULL(deliver_nums_sum,0)", new Object[0]);
        IPage<OrderDetailEntity> pageData = this.service.selectPage(page, wrapper);
        Page voPage = new Page();
        List listres = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            listres = BeanMapper.mapList((Iterable)pageData.getRecords(), OrderDetailVO.class);
            listres.forEach(e -> {
                BigDecimal deliverNumsSum = e.getDeliverNumsSum() == null ? BigDecimal.ZERO : e.getDeliverNumsSum();
                BigDecimal receiveNumsSum = e.getReceiveNumsSum() == null ? BigDecimal.ZERO : e.getReceiveNumsSum();
                e.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));
            });
        }
        voPage.setCurrent(pageData.getCurrent());
        voPage.setPages(pageData.getPages());
        voPage.setTotal(pageData.getTotal());
        voPage.setSize((long)queryParam.getPageSize());
        voPage.setRecords(listres);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)voPage);
    }
}

