/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weigh"})
public class WeighController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeighService weighService;
    @Autowired
    private IWeighDetailService weighDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeighVO> saveOrUpdate(@RequestBody WeighVO saveorUpdateVO) {
        WeighEntity entity = (WeighEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WeighEntity.class));
        this.weighService.saveOrUpdate((Object)entity, false);
        WeighVO vo = (WeighVO)BeanMapper.map((Object)((Object)entity), WeighVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeighVO> updateStatus(@RequestBody WeighVO updateStatusVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)updateStatusVO.getId());
        updateWrapper.set(WeighEntity::getWeighFlag, (Object)updateStatusVO.getWeighFlag());
        boolean flag = this.weighService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u4fee\u6539\u542f\u7528/\u505c\u7528\u72b6\u6001\u5931\u8d25\uff01");
        }
        WeighEntity byId = (WeighEntity)((Object)this.weighService.getById(updateStatusVO.getId()));
        WeighVO vo = (WeighVO)BeanMapper.map((Object)((Object)byId), WeighVO.class);
        return CommonResponse.success((String)"\u542f\u7528\u6216\u505c\u7528\u667a\u80fd\u79f0\u91cd\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeighVO> queryDetail(Long id) {
        WeighEntity entity = (WeighEntity)((Object)this.weighService.selectById(id));
        WeighVO vo = (WeighVO)BeanMapper.map((Object)((Object)entity), WeighVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getWeighByProjectDepartmentId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        return this.weighService.getWeighByProjectDepartmentId(projectDepartmentId);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeighVO> vos) {
        this.weighService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeighVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.weighService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeighVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getMaterialByOrgId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WeighDetailVO>> getMaterialByOrgId(@RequestBody WeighInfoVO weighInfoVO) {
        WeighDetailVO weighDetailVO;
        List materialIds = weighInfoVO.getMaterialIds();
        ArrayList<Long> materialIdProjectOpen = new ArrayList<Long>();
        ArrayList<Long> materialIdOrgOpen = new ArrayList<Long>();
        ArrayList<WeighDetailVO> weighDetailVOList = new ArrayList<WeighDetailVO>();
        LambdaQueryWrapper queryWrapperWeigh = Wrappers.lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
        queryWrapperWeigh.eq(WeighEntity::getWeighFlag, (Object)"1");
        WeighEntity weigh = (WeighEntity)((Object)this.weighService.getOne((Wrapper)queryWrapperWeigh));
        if (weigh != null) {
            LambdaQueryWrapper queryWrapperWeighDetail = Wrappers.lambdaQuery();
            queryWrapperWeighDetail.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
            queryWrapperWeighDetail.eq(WeighDetailEntity::getWeighFlag, (Object)"1");
            List weighDetailEntityList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0) {
                for (Long materialId : materialIds) {
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList) {
                        if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                        weighDetailVO = new WeighDetailVO();
                        weighDetailVO.setWeighFlag("1");
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                        weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                        weighDetailVOList.add(weighDetailVO);
                        materialIdProjectOpen.add(materialId);
                    }
                }
            }
            materialIds.removeAll(materialIdProjectOpen);
        }
        LambdaQueryWrapper queryWrapperWeighDetailOrg = Wrappers.lambdaQuery();
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getOrgId());
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getWeighFlag, (Object)"1");
        List weighDetailEntityOrgList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetailOrg);
        if (weighDetailEntityOrgList != null && weighDetailEntityOrgList.size() > 0) {
            for (Long materialId : materialIds) {
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityOrgList) {
                    if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                    weighDetailVO = new WeighDetailVO();
                    weighDetailVO.setWeighFlag("1");
                    weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                    weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                    weighDetailVOList.add(weighDetailVO);
                    materialIdOrgOpen.add(materialId);
                }
            }
        }
        materialIds.removeAll(materialIdOrgOpen);
        if (materialIds != null && materialIds.size() > 0) {
            for (Long materialId : materialIds) {
                WeighDetailVO weighDetailVO2 = new WeighDetailVO();
                weighDetailVO2.setWeighFlag("0");
                weighDetailVO2.setMaterialId(materialId);
                weighDetailVOList.add(weighDetailVO2);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", weighDetailVOList);
    }
}

