/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.service.impl.CheckServiceImpl;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.DeliveryCheckVO;
import com.ejianc.business.wzxt.vo.DeliveryDetailVO;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.business.wzxt.vo.WeighBillVO;
import com.ejianc.business.wzxt.vo.WeighIdsQuery;
import com.ejianc.business.wzxt.vo.WeighImgQueryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${smartWeigh.addr}")
    private String addr;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IWeighDetailService weighDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private CheckServiceImpl checkService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${wjy.path}")
    private String wjyPath;

    @Override
    public DeliveryVO queryDetails(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.orderService.selectById(id));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        deliveryVO.setTenantId(entity.getSupplierTenantId());
        return deliveryVO;
    }

    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        this.logger.error("service\u8fdb\u6765\u4e86" + deliveryVO.toString());
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper queryWrapperOrder = Wrappers.lambdaQuery();
        queryWrapperOrder.eq(OrderEntity::getHistoryId, (Object)deliveryVO.getOrderStringId());
        OrderEntity orderEntityOne = (OrderEntity)((Object)this.orderService.getOne((Wrapper)queryWrapperOrder));
        OrderEntity orderEntity = new OrderEntity();
        Boolean historyFlag = false;
        if (null != orderEntityOne) {
            orderEntity = orderEntityOne;
            historyFlag = true;
        } else {
            this.logger.info("\u53d1\u8d27\u5355\u4fe1\u606f:" + deliveryVO.toString());
            orderEntity = (OrderEntity)((Object)this.orderService.getById(Integer.valueOf(Integer.parseInt(deliveryVO.getOrderStringId()))));
        }
        this.logger.error("\u8ba2\u5355\u5b9e\u4f53\u4fe1\u606f:" + orderEntity.toString());
        Long orderId = orderEntity.getId();
        deliveryVO.setOrderId(orderEntity.getId());
        deliveryVO.setProjectId(orderEntity.getProjectId());
        deliveryVO.setProjectName(orderEntity.getProjectName());
        deliveryVO.setOrgId(orderEntity.getOrgId());
        deliveryVO.setOrgName(orderEntity.getOrgName());
        deliveryVO.setContractId(orderEntity.getContractId());
        deliveryVO.setContractName(orderEntity.getContractName());
        deliveryVO.setSupplierId(orderEntity.getSupplierId());
        deliveryVO.setSupplierName(orderEntity.getSupplierName());
        deliveryVO.setProjectSourceId(orderEntity.getProjectSourceId());
        deliveryVO.setOrderBillCode(orderEntity.getBillCode());
        deliveryVO.setParentOrgId(orderEntity.getParentOrgId());
        deliveryVO.setParentOrgSourceId(orderEntity.getParentOrgSourceId());
        deliveryVO.setOrgSourceId(orderEntity.getOrgSourceId());
        deliveryVO.setSupplierSourceId(orderEntity.getSupplierSourceId());
        deliveryVO.setPlatformCode(orderEntity.getPlatformCode());
        deliveryVO.setPlatformType(orderEntity.getPlatformType());
        deliveryVO.setConstruction(orderEntity.getConstruction());
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)deliveryVO, DeliveryEntity.class));
        List<DeliveryDetailEntity> deliveryDetail = entity.getDeliveryDetail();
        String materialName = "";
        if (deliveryDetail != null && deliveryDetail.size() > 0) {
            List orderDetailIds;
            List orderDetailEntityList = new ArrayList();
            if (historyFlag.booleanValue()) {
                orderDetailIds = deliveryDetail.stream().map(DeliveryDetailEntity::getOrderDetailStringId).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
                queryWrapperOrderDetail.in(OrderDetailEntity::getHistoryId, orderDetailIds);
                orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
                Map orderDetailEntityMap = orderDetailEntityList.stream().collect(Collectors.toMap(OrderDetailEntity::getHistoryId, Function.identity()));
                deliveryDetail.forEach(deliveryDetailEntity -> {
                    OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)((Object)orderDetailEntityMap.get(deliveryDetailEntity.getOrderDetailStringId())));
                    if (null != orderDetailEntity) {
                        deliveryDetailEntity.setOrderDetailId(orderDetailEntity.getId());
                    }
                });
            } else {
                orderDetailIds = deliveryDetail.stream().map(DeliveryDetailEntity::getOrderDetailStringId).collect(Collectors.toList());
                List longList = BeanMapper.mapList(orderDetailIds, Long.class);
                LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
                queryWrapperOrderDetail.in(BaseEntity::getId, (Collection)longList);
                orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
                deliveryDetail.forEach(deliveryDetailEntity -> deliveryDetailEntity.setOrderDetailId(Long.parseLong(deliveryDetailEntity.getOrderDetailStringId())));
            }
            if (CollectionUtils.isNotEmpty(orderDetailEntityList)) {
                Map orderDetailEntityMap = orderDetailEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
                deliveryDetail.forEach(deliveryDetailEntity -> {
                    OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)((Object)orderDetailEntityMap.get(deliveryDetailEntity.getOrderDetailId())));
                    if (null != orderDetailEntity) {
                        deliveryDetailEntity.setOrderId(orderId);
                        deliveryDetailEntity.setMaterialId(orderDetailEntity.getMaterialId());
                        deliveryDetailEntity.setMaterialSourceId(orderDetailEntity.getMaterialSourceId());
                        deliveryDetailEntity.setMaterialName(orderDetailEntity.getMaterialName());
                        deliveryDetailEntity.setMaterialTypeId(orderDetailEntity.getMaterialTypeId());
                        deliveryDetailEntity.setMaterialTypeName(orderDetailEntity.getMaterialTypeName());
                        deliveryDetailEntity.setMaterialCode(orderDetailEntity.getMaterialCode());
                        deliveryDetailEntity.setUnit(orderDetailEntity.getUnit());
                        deliveryDetailEntity.setSpec(orderDetailEntity.getSpec());
                        deliveryDetailEntity.setReceiveNumsSum(orderDetailEntity.getReceiveNumsSum());
                        deliveryDetailEntity.setOrderNumsSum(orderDetailEntity.getOrderNumsSum());
                        orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                        orderDetailEntityMap.put(deliveryDetailEntity.getOrderDetailId(), orderDetailEntity);
                    }
                });
                List orderDetailEntities = orderDetailEntityMap.entrySet().stream().map(et -> (OrderDetailEntity)((Object)((Object)et.getValue()))).collect(Collectors.toList());
                boolean flagOrder = this.orderDetailService.updateBatchById(orderDetailEntities);
                if (!flagOrder) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                LambdaQueryWrapper wrapperOrderDetail = Wrappers.lambdaQuery();
                wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, (Object)deliveryVO.getOrderId());
                wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, (Object)false);
                List orderDetailList = this.orderDetailService.list((Wrapper)wrapperOrderDetail);
                if (orderDetailList != null && orderDetailList.size() > 0) {
                    Boolean b = true;
                    for (OrderDetailEntity orderDetailEntity : orderDetailList) {
                        BigDecimal deliverNumsSum;
                        BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                        if (receiveNumsSum.compareTo(deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum()) != 1) continue;
                        b = false;
                    }
                    if (b.booleanValue()) {
                        LambdaUpdateWrapper updateOrderWrapper = new LambdaUpdateWrapper();
                        updateOrderWrapper.eq(BaseEntity::getId, (Object)deliveryVO.getOrderId());
                        updateOrderWrapper.set(OrderEntity::getDeliverState, (Object)1);
                        boolean updateFlagOrder = this.orderService.update((Wrapper)updateOrderWrapper);
                        if (!updateFlagOrder) {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                    }
                }
            }
            for (DeliveryDetailEntity deliveryDetailEntity2 : deliveryDetail) {
                materialName = materialName + deliveryDetailEntity2.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        entity.setDeliveryDetail(deliveryDetail);
        this.deliveryService.saveOrUpdate((Object)entity, false);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        OrderEntity orderEntityInfo = (OrderEntity)((Object)this.orderService.getById(deliveryVO.getOrderId()));
        sender.add(String.valueOf(orderEntityInfo.getCommitId()));
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntityInfo.getProjectName() + "+" + orderEntityInfo.getBillCode() + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u9a8c\u6536!";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntityInfo.getProjectName() + "+" + orderEntityInfo.getBillCode() + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u524d\u5f80\u4e94\u5c40\u4e91\u9a8c\u6536!";
        this.sendMsg(entity, messageType, sender, "notice", subject, content, String.valueOf(orderEntityInfo.getTenantId()));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<DeliveryVO> deliver(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(DeliveryEntity::getBillState, (Object)1);
        updateWrapper.set(DeliveryEntity::getDeliverState, (Object)1);
        boolean flag = this.deliveryService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)id);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0) {
            ArrayList<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
            queryWrapperOrderDetail.in(BaseEntity::getId, orderDetailIdList);
            List orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList) {
                    if (!deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())) continue;
                    orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                }
            }
            boolean flagOrder = this.orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
            LambdaQueryWrapper wrapperOrderDetail = Wrappers.lambdaQuery();
            wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, (Object)entity.getOrderId());
            wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, (Object)false);
            List orderDetailList = this.orderDetailService.list((Wrapper)wrapperOrderDetail);
            if (orderDetailList != null && orderDetailList.size() > 0) {
                Boolean b = true;
                for (OrderDetailEntity orderDetailEntity : orderDetailList) {
                    BigDecimal deliverNumsSum;
                    BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                    if (receiveNumsSum.compareTo(deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum()) != 1) continue;
                    b = false;
                }
                if (b.booleanValue()) {
                    LambdaUpdateWrapper updateOrderWrapper = new LambdaUpdateWrapper();
                    updateOrderWrapper.eq(BaseEntity::getId, (Object)entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, (Object)1);
                    boolean updateFlagOrder = this.orderService.update((Wrapper)updateOrderWrapper);
                    if (!updateFlagOrder) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
            }
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        ArrayList<String> sender = new ArrayList<String>();
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String formurl = this.baseHost + "ejc-wzxt-frontend/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "+" + orderEntity.getBillCode() + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u9a8c\u6536!";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "+" + orderEntity.getBillCode() + "\u3011\u5df2\u53d1\u8d27\uff0c\u8bf7\u5230\u4f01\u4e1a\u5fae\u4fe1\u9a8c\u6536!";
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u53d1\u8d27\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public DeliveryVO weighCheck(DeliveryCheckVO deliveryCheckVO) throws Exception {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.getById((Serializable)deliveryCheckVO.getDeliveryId()));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(DeliveryDetailEntity::getDeliveryId, (Object)deliveryCheckVO.getDeliveryId());
        List details = this.deliveryDetailService.list((Wrapper)lambda);
        List<Long> orderDetailsId = details.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderDetailsId)) {
            String queryPlanEmployName = this.orderDetailService.queryPlanEmployName(orderDetailsId);
            deliveryVO.setChecker(queryPlanEmployName);
        }
        List<WeighBillVO> weighBillVOList = this.getWeighListByPks(deliveryCheckVO.getPkWeighBillList());
        deliveryVO.setPkWeighBillList(deliveryCheckVO.getPkWeighBillList());
        deliveryVO.setDeliveryCarNumber("\u5171" + weighBillVOList.size() + "\u8f66\u6b21");
        deliveryVO.setDeliveryDetailVOList(this.dealInfoData(deliveryVO, weighBillVOList));
        deliveryVO.setAttachmentVOList(this.dealImg(deliveryCheckVO.getPkWeighBillList()));
        return deliveryVO;
    }

    @Override
    public DeliveryVO oneKeyCheck(DeliveryCheckVO deliveryCheckVO) throws Exception {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.getById((Serializable)deliveryCheckVO.getDeliveryId()));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(DeliveryDetailEntity::getDeliveryId, (Object)deliveryCheckVO.getDeliveryId());
        List details = this.deliveryDetailService.list((Wrapper)lambda);
        List<Long> orderDetailsId = details.stream().map(DeliveryDetailEntity::getOrderDetailId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderDetailsId)) {
            String queryPlanEmployName = this.orderDetailService.queryPlanEmployName(orderDetailsId);
            deliveryVO.setChecker(queryPlanEmployName);
        }
        List<WeighBillVO> weighBillVOList = null;
        weighBillVOList = this.getWeighListByDelivery(deliveryEntity.getHistoryId());
        List<String> pkWeighBillList = weighBillVOList.stream().map(WeighBillVO::getPkWeighBill).collect(Collectors.toList());
        deliveryVO.setPkWeighBillList(pkWeighBillList);
        deliveryVO.setDeliveryCarNumber("\u5171" + weighBillVOList.size() + "\u8f66\u6b21");
        deliveryVO.setDeliveryDetailVOList(this.dealInfoData(deliveryVO, weighBillVOList));
        deliveryVO.setAttachmentVOList(this.dealImg(pkWeighBillList));
        return deliveryVO;
    }

    @Override
    public CommonResponse<DeliveryVO> closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.getById((Serializable)id));
        LambdaUpdateWrapper updateOrderWrapper = new LambdaUpdateWrapper();
        updateOrderWrapper.eq(BaseEntity::getId, (Object)id);
        updateOrderWrapper.set(DeliveryEntity::getCloseStatus, (Object)"1");
        boolean updateFlagOrder = super.update((Wrapper)updateOrderWrapper);
        this.checkService.writeBackOpenDelivery(String.valueOf(deliveryEntity.getHistoryId()), true);
        DeliveryEntity deliveryEntityNew = (DeliveryEntity)((Object)super.getById((Serializable)id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntityNew), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public void sendMsg(DeliveryEntity entity, List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4f9b\u65b9\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)"");
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    public List<WeighBillVO> getWeighListByPks(List<String> pkWeighBill) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            WeighIdsQuery weighIdsQuery = new WeighIdsQuery();
            weighIdsQuery.setPkWeighs(pkWeighBill);
            String url = this.addr + "/el/sw/weigh/list";
            String back = null;
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)weighIdsQuery).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                return JSONArray.parseArray((String)((JSONArray)jsonBack.get((Object)"body")).toJSONString(), WeighBillVO.class);
            }
            throw new BusinessException(jsonBack.getString("msg"));
        }
        throw new BusinessException("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
    }

    public List<String> getWeighImgs(List<String> pkWeighBill) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            WeighImgQueryVO weighImgQuery = new WeighImgQueryVO();
            weighImgQuery.setPkWeighBills(pkWeighBill);
            weighImgQuery.setNum(Integer.valueOf(6));
            String url = this.addr + "/el/sw/weigh/img";
            String back = null;
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)weighImgQuery).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                return JSONArray.parseArray((String)((JSONArray)jsonBack.get((Object)"body")).toJSONString(), String.class);
            }
            throw new BusinessException(jsonBack.getString("msg"));
        }
        throw new BusinessException("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
    }

    public List<AttachmentVO> dealImg(List<String> pkWeighBill) throws Exception {
        this.logger.info("pkWeighBill" + pkWeighBill.toString());
        List<String> weighImgs = this.getWeighImgs(pkWeighBill);
        this.logger.info("weighImgs" + weighImgs.toString());
        StringBuffer path = new StringBuffer();
        List<Object> listImg = new ArrayList<AttachmentVO>();
        if (CollectionUtils.isNotEmpty(weighImgs)) {
            AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
            attachmentVO.setBillType("BT201028000000002");
            attachmentVO.setSourceType("imgUpload2");
            attachmentVO.setFileList(weighImgs);
            CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
            this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
            if (listCommonResponse.isSuccess()) {
                listImg = (List)listCommonResponse.getData();
            }
            this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u540e:" + listCommonResponse.getData());
        }
        return listImg;
    }

    public List<WeighBillVO> getWeighListByDelivery(String pkDelivery) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("checkStatus", 0);
        param.put("pkDelivery", pkDelivery);
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            String url = this.addr + "/el/sw/weigh/delivery/list";
            String back = null;
            back = HttpTookit.get(url, param, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                return JSONArray.parseArray((String)((JSONArray)jsonBack.get((Object)"body")).toJSONString(), WeighBillVO.class);
            }
            throw new BusinessException(jsonBack.getString("msg"));
        }
        throw new BusinessException("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
    }

    private List<DeliveryDetailVO> dealInfoData(DeliveryVO delivery, List<WeighBillVO> weighBillVOList) throws Exception {
        HashMap<String, DeliveryDetailEntity> infoMap = new HashMap<String, DeliveryDetailEntity>();
        ArrayList<String> gcList = new ArrayList<String>();
        BigDecimal sumWeight = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(weighBillVOList)) {
            for (WeighBillVO weighBillVO : weighBillVOList) {
                DeliveryDetailEntity info;
                if (!infoMap.containsKey(weighBillVO.getPkDeliveryB())) {
                    LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                    lambda.eq(DeliveryDetailEntity::getHistoryId, (Object)weighBillVO.getPkDeliveryB());
                    info = (DeliveryDetailEntity)((Object)this.deliveryDetailService.getOne((Wrapper)lambda));
                } else {
                    info = (DeliveryDetailEntity)((Object)infoMap.get(weighBillVO.getPkDeliveryB()));
                }
                this.convertUnit(weighBillVO);
                gcList.add(this.getGcDateString(weighBillVO.getTareTime()) + "-" + weighBillVO.getPlateNumber() + "-" + weighBillVO.getNetWeight().setScale(0, 4) + "\u5343\u514b");
                sumWeight = sumWeight.add(weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight());
                this.dealInfoNet(info, weighBillVO);
                infoMap.put(weighBillVO.getPkDeliveryB(), info);
            }
        }
        delivery.setCheckprocess(StringUtils.join(gcList, (String)";") + ";\u5171" + weighBillVOList.size() + "\u8f66\u6b21;\u5408\u8ba1" + sumWeight.setScale(0, 4) + "\u5343\u514b");
        ArrayList infoList = new ArrayList(infoMap.values());
        List pkMaterialList = infoList.stream().map(DeliveryDetailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(WeighDetailEntity::getOrgId, (Object)delivery.getOrgId());
        lambda.in(WeighDetailEntity::getMaterialId, pkMaterialList);
        List details = this.weighDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            Map<Long, BigDecimal> orgmatMap = details.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
            infoList.forEach(deliveryDetailEntity -> deliveryDetailEntity.setTransformRate((BigDecimal)orgmatMap.get(deliveryDetailEntity.getMaterialId())));
        }
        return BeanMapper.mapList(infoList, DeliveryDetailVO.class);
    }

    private void convertUnit(WeighBillVO weighBillVO) {
        String weightUnit = weighBillVO.getWeightUnit();
        if ("\u5343\u514b".equals(weightUnit) || "\u516c\u65a4".equals(weightUnit) || "KG".equals(weightUnit) || "Kg".equals(weightUnit) || "kg".equals(weightUnit)) {
            weighBillVO.setWeightUnit("kg");
        } else if ("\u5428".equals(weightUnit) || "T".equals(weightUnit) || "t".equals(weightUnit)) {
            weighBillVO.setWeightUnit("kg");
            weighBillVO.setNetWeight(weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight().multiply(new BigDecimal(1000)));
        } else {
            weighBillVO.setWeightUnit("kg");
        }
    }

    private String getGcDateString(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(dateStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(2) + 1 + "\u6708" + calendar.get(5) + "\u65e5";
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    private void dealInfoNet(DeliveryDetailEntity info, WeighBillVO weighBillVO) {
        BigDecimal infoNum = info.getNetWeight() == null ? BigDecimal.ZERO : info.getNetWeight();
        BigDecimal weighNum = weighBillVO.getNetWeight() == null ? BigDecimal.ZERO : weighBillVO.getNetWeight();
        info.setNetWeight(infoNum.add(weighNum));
    }
}

