package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.PlanCommentEntity;
import com.ejianc.business.wzxt.service.IPlanCommentService;
import com.ejianc.business.wzxt.vo.PlanCommentVO;

/**
 * 使用计划审批历史实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("planComment")
public class PlanCommentController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IPlanCommentService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanCommentVO> saveOrUpdate(@RequestBody PlanCommentVO saveorUpdateVO) {
    	PlanCommentEntity entity = BeanMapper.map(saveorUpdateVO, PlanCommentEntity.class);
    	service.saveOrUpdate(entity, false);
    	PlanCommentVO vo = BeanMapper.map(entity, PlanCommentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanCommentVO> queryDetail(Long id) {
    	PlanCommentEntity entity = service.selectById(id);
    	PlanCommentVO vo = BeanMapper.map(entity, PlanCommentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 根据业务主键查询审批历史
     */
    @RequestMapping(value = "/getListByPkBiz", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PlanCommentVO>> getListByPkBiz(Long pkBiz) {
        LambdaQueryWrapper<PlanCommentEntity> queryWrapper = Wrappers.<PlanCommentEntity>lambdaQuery();
        queryWrapper.eq(PlanCommentEntity::getPkBiz, pkBiz);
        queryWrapper.orderByDesc(PlanCommentEntity::getTs);
        List<PlanCommentEntity> list = service.list(queryWrapper);
        List<PlanCommentVO> planCommentVOList = null;
        if(CollectionUtils.isNotEmpty(list)){
            planCommentVOList = BeanMapper.mapList(list, PlanCommentVO.class);
        }
        return CommonResponse.success("查询成功！",planCommentVOList);
    }


    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanCommentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PlanCommentEntity> page = service.queryPage(param,false);
        IPage<PlanCommentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanCommentVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
