package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.WeighVO;

/**
 * 智能称重实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("weigh")
public class WeighController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWeighService weighService;
    @Autowired
    private IWeighDetailService weighDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeighVO> saveOrUpdate(@RequestBody WeighVO saveorUpdateVO) {
    	WeighEntity entity = BeanMapper.map(saveorUpdateVO, WeighEntity.class);
        weighService.saveOrUpdate(entity, false);
    	WeighVO vo = BeanMapper.map(entity, WeighVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 启用/停用
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeighVO> updateStatus(@RequestBody WeighVO updateStatusVO) {
        //修改状态
        LambdaUpdateWrapper<WeighEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WeighEntity::getId, updateStatusVO.getId());
        updateWrapper.set(WeighEntity::getWeighFlag, updateStatusVO.getWeighFlag());
        boolean flag = weighService.update(updateWrapper);
        if (!flag){
            throw new BusinessException("修改启用/停用状态失败！");
        }
        WeighEntity byId = weighService.getById(updateStatusVO.getId());
        WeighVO vo = BeanMapper.map(byId, WeighVO.class);
    	return CommonResponse.success("启用或停用智能称重成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeighVO> queryDetail(Long id) {
    	WeighEntity entity = weighService.selectById(id);
    	WeighVO vo = BeanMapper.map(entity, WeighVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 根据项目部主键查询详情
     * @param
     */
    @RequestMapping(value = "/getWeighByProjectDepartmentId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        return weighService.getWeighByProjectDepartmentId(projectDepartmentId);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeighVO> vos) {
        weighService.removeByIds(vos.stream().map(WeighVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeighVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<WeighEntity> page = weighService.queryPage(param,false);
        IPage<WeighVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description saveOrUpdate 获取物资称重设置接口
     */
    @RequestMapping(value = "/getMaterialByOrgId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<WeighDetailVO>> getMaterialByOrgId(@RequestBody WeighInfoVO weighInfoVO) {
        //物资主键
        List<Long> materialIds = weighInfoVO.getMaterialIds();
        List<Long> materialIdProjectOpen = new ArrayList<Long>();
        List<Long> materialIdOrgOpen = new ArrayList<Long>();
        List<WeighDetailVO> weighDetailVOList = new ArrayList<WeighDetailVO>();

        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighEntity> queryWrapperWeigh = Wrappers.<WeighEntity>lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, weighInfoVO.getProjectDepartmentId());
        queryWrapperWeigh.eq(WeighEntity::getWeighFlag, "1");
        WeighEntity weigh = weighService.getOne(queryWrapperWeigh);
        //是否开启智能称重(1:是，0：否)
        if (weigh != null){
            //查询项目目设置的智能称重物资
            LambdaQueryWrapper<WeighDetailEntity> queryWrapperWeighDetail = Wrappers.<WeighDetailEntity>lambdaQuery();
            queryWrapperWeighDetail.eq(WeighDetailEntity::getOrgId, weighInfoVO.getProjectDepartmentId());
            queryWrapperWeighDetail.eq(WeighDetailEntity::getWeighFlag, "1");
            List<WeighDetailEntity> weighDetailEntityList = weighDetailService.list(queryWrapperWeighDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0){
                //匹配物资
                for (Long materialId : materialIds){
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList){
                        if (weighDetailEntity.getMaterialId().equals(materialId)){
                            WeighDetailVO weighDetailVO = new WeighDetailVO();
                            weighDetailVO.setWeighFlag("1");
                            weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                            weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                            weighDetailVOList.add(weighDetailVO);
                            materialIdProjectOpen.add(materialId);
                        }
                    }
                }
            }
            //删除已查到项目开启智能称重的物料主键
            materialIds.removeAll(materialIdProjectOpen);
        }
        //查询组织级的物料智能称重设置
        LambdaQueryWrapper<WeighDetailEntity> queryWrapperWeighDetailOrg = Wrappers.<WeighDetailEntity>lambdaQuery();
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getOrgId, weighInfoVO.getOrgId());
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getWeighFlag, "1");
        List<WeighDetailEntity> weighDetailEntityOrgList = weighDetailService.list(queryWrapperWeighDetailOrg);
        if (weighDetailEntityOrgList != null && weighDetailEntityOrgList .size() > 0){
            //匹配物资
            for (Long materialId : materialIds){
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityOrgList){
                    if (weighDetailEntity.getMaterialId().equals(materialId)){
                        WeighDetailVO weighDetailVO = new WeighDetailVO();
                        weighDetailVO.setWeighFlag("1");
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                        weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                        weighDetailVOList.add(weighDetailVO);
                        materialIdOrgOpen.add(materialId);
                    }
                }
            }
        }
        //删除已查到项目开启智能称重的物料主键
        materialIds.removeAll(materialIdOrgOpen);
        if (materialIds != null && materialIds.size() > 0){
            for (Long materialId : materialIds) {
                WeighDetailVO weighDetailVO = new WeighDetailVO();
                weighDetailVO.setWeighFlag("0");
                weighDetailVO.setMaterialId(materialId);
                weighDetailVOList.add(weighDetailVO);
            }
        }
        return CommonResponse.success("查询成功！",weighDetailVOList);
    }

}
