package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.mapper.ExitMapper;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.vo.ExitVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 退场单
 * 
 * @author generator
 * 
 */
@Service("exitService")
public class ExitServiceImpl extends BaseServiceImpl<ExitMapper, ExitEntity> implements IExitService{

    private static final String WZXT_CHECK = "CSCEC5B_CWZXT_CHECK";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBillCodeApi billCodeApi;


    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        ExitEntity entity = BeanMapper.map(saveorUpdateVO, ExitEntity.class);
        entity.setConfirmFlag(0);//待确认
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ExitVO.class);
    }
}
