package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.OrderDetailMapper;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 订单明细表
 * 
 * @author generator
 * 
 */
@Service("orderDetailService")
public class OrderDetailServiceImpl extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity> implements IOrderDetailService{

    @Override
    public IPage<OrderDetailEntity> selectPage(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.selectPage(pages,queryWrapper);
    }

    @Override
    public String queryPlanEmployName(List<Long> pks) {
        String result = "";
        LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda.ne(OrderDetailEntity::getLeafFlag,true);
        lambda.in(OrderDetailEntity::getId,pks);
        lambda.orderByAsc(OrderDetailEntity::getId);
        List<OrderDetailEntity> details  = super.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            List<Long> list = details.stream().map(OrderDetailEntity::getTid).collect(Collectors.toList());
            LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
            lambda2.eq(OrderDetailEntity::getLeafFlag,true);
            lambda2.in(OrderDetailEntity::getParentId,list);
            lambda2.orderByAsc(OrderDetailEntity::getId);
            List<OrderDetailEntity> listDetails  = super.list(lambda2);
            Set<String> employName = listDetails.stream().map(OrderDetailEntity::getPlanEmployeeName).collect(Collectors.toSet());
            result = StringUtils.join(employName, ",");
        }
        return result;
    }
}
