package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.mapper.ExitMapper;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 退场单
 * 
 * @author generator
 * 
 */
@Service("exitService")
public class ExitServiceImpl extends BaseServiceImpl<ExitMapper, ExitEntity> implements IExitService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    private static final String WZXT_CHECK = "CSCEC5B_CWZXT_CHECK";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPushMessageApi pushMessageApi;


    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        ExitEntity entity = BeanMapper.map(saveorUpdateVO, ExitEntity.class);
        entity.setConfirmFlag(0);//待确认
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ExitVO.class);
    }

    @Override
    public CommonResponse<ExitVO> updateConfirmFlag(ExitVO exitVO) {
        ExitEntity entity = super.getById(exitVO.getId());
        entity.setConfirmFlag(exitVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitVO.getConfirmerId());
        entity.setConfirmerName(exitVO.getConfirmerName());
        entity.setConfirmNote(exitVO.getConfirmNote());
        super.saveOrUpdate(entity, false);
        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(entity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-wzxt-frontend/#/exit/card?id="+entity.getId();
        String subject = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】。";
        String content = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】退回。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(entity.getTenantId()),entity);
        return null;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,ExitEntity entity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams  = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+entity.getId()+"&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    @Override
    public CommonResponse<String>  pushConfirmEntity(Map<String, String> headers, ExitEntity exitEntity){
//        String url = wjOrderUrl;
//        Purchase purchase = new Purchase();
//        purchase.setPkPurchase(String.valueOf(orderEntity.getId()));// 订货单主键
//        purchase.setPkOrg(orderEntity.getParentOrgSourceId());;// 组织主键   传来源组织主键
//        purchase.setPkProject(orderEntity.getProjectSourceId());// 项目主键    传来源项目主键
//        purchase.setProjectName(orderEntity.getProjectName());
//        purchase.setPurchaseCode(orderEntity.getBillCode());// 订货单编码
//        purchase.setPkSupplier(orderEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
//        purchase.setSupplierName(orderEntity.getSupplierName());
//        purchase.setPkContractPurchase(orderEntity.getContractId());// 采购合同主键
//        purchase.setContractPurchaseName(orderEntity.getContractName());
//        purchase.setContractPurchaseCode(orderEntity.getContractCode());
//        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
//        purchase.setPurchaseCreateDate(formatter.format(orderEntity.getOrderCreateDate()));// 订货单创建时间 yyyy-MM-dd
//        purchase.setPurchaseExpiryDate(formatter.format(orderEntity.getOrderExpiryDate()));// 订货单要求送货时间 yyyy-MM-dd
//        purchase.setPurchaseLinkMan(orderEntity.getLinkName());// 订货单联系人
//        purchase.setPurchaseLinkTelephone(orderEntity.getLinkTelephone());// 订货单联系电话
//        purchase.setBillStatus(1);// 订货单状态  传1  代表“待确认”
//        purchase.setPurchaseNote(orderEntity.getOrderNote());// 送货要求
//        purchase.setPurchaseAddress(orderEntity.getOrderAddress());// 送货地址
//        purchase.setPlanBody(orderEntity.getConstruction());//使用部位
//        purchase.setSmartStatus(orderEntity.getSmartStatus()==null?0:Integer.parseInt(orderEntity.getSmartStatus()));//智能称重标识 0 激活 1 关闭
//        purchase.setPlatformType(orderEntity.getPlatformType());//磅点类型 0、请选择   1、实达、 2、沣悦
//        purchase.setPlatformCode(orderEntity.getPlatformCode());//磅点编号
//        purchase.setSysmark("xpt");//系统标识，“xpt”-新平台
//        purchase.setPkCreator("xpt");
//        purchase.setCreatorName("五局新平台");
//        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
//
//        if(CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())){
//            List<PurchaseInfo> list = new ArrayList<>();
//            orderEntity.getPurchaseOrderDetail().forEach(e -> {
//                if(!e.getLeafFlag()){
//                    //非末级才需要同步
//                    PurchaseInfo vo = new PurchaseInfo();
//                    vo.setPkPurchaseInfo(String.valueOf(e.getId()));// 订购单子表主键
//                    vo.setPkPurchase(String.valueOf(orderEntity.getId()));// 订单表主键
//                    vo.setPkMaterial(e.getMaterialSourceId());// 材料主键 传来源主键
//                    vo.setMaterialCode(e.getMaterialCode());// 材料编码"
//                    vo.setMaterialName(e.getMaterialName());// 材料名称
//                    vo.setMaterialSpec(e.getSpec());// 规格
//                    vo.setMaterialType(e.getSpec());// 型号
//                    vo.setMaterialMeasname(e.getUnit());// 单位
//                    vo.setMaterialManufacturer(e.getMaterialManufacturer());// 生产厂家
//                    vo.setMaterialNote(e.getMemo());// 材料备注
//
//                    vo.setPlanAmountSum(e.getPlanNumsSum()==null?0:e.getPlanNumsSum().doubleValue());// 计划数量
//                    vo.setPlanUncheckAmountSum(e.getSurplusNumsSum()==null?0:e.getSurplusNumsSum().doubleValue());// 计划剩余数量
//                    vo.setStockAmountSum(e.getStockAmountSum()==null?0:e.getStockAmountSum().doubleValue());// 库存数量
//                    vo.setPurchaseAmountSum(e.getOrderNumsSum()==null?0:e.getOrderNumsSum().doubleValue());// 订单数量
//                    vo.setPurchaseCheckAmountSum(e.getReceiveNumsSum()==null?0:e.getReceiveNumsSum().doubleValue());// 接收数量
//                    vo.setSmartStatus(e.getSmartStatus()==null?0:Integer.parseInt(e.getSmartStatus()));
//                    list.add(vo);
//                }
//            });
//            purchase.setPurchaseInfoList(list);
//        }

//        String back = null;
//        try {
//            logger.info("---url:" + url);
//            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
//            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
//            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
//            JSONObject jsonBack = JSONObject.parseObject(back);
//            logger.info("---回参:" + jsonBack);
//            if("200".equals(jsonBack.getString("code"))){
//                //调用同步方法成功
//                return CommonResponse.success();
//            }else{
//                //调用同步方法失败，输出错误信息
//                return CommonResponse.error(jsonBack.getString("msg"));
//            }
//        } catch (Exception e) {
//            return CommonResponse.error("推送供方订单异常!");
//        }
        return null;
    }
}
