/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.vo.ControlPlanRefVO;
import com.ejianc.business.wzxt.vo.ControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"controlPlan"})
public class ControlPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IControlPlanService service;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanVO> saveOrUpdate(@RequestBody ControlPlanVO saveorUpdateVO) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ControlPlanEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ControlPlanVO vo = (ControlPlanVO)BeanMapper.map((Object)((Object)entity), ControlPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanVO> queryDetail(Long id) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)this.service.selectById(id));
        ControlPlanVO vo = (ControlPlanVO)BeanMapper.map((Object)((Object)entity), ControlPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/controlPlanRef"})
    @ResponseBody
    public CommonResponse<JSONObject> controlPlanRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            projectId = Long.valueOf(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ControlPlanRefVO> list = this.service.getControlPlan((Page<ControlPlanRefVO>)page, wrapper, projectId, InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

