/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="exit")
public class ExitBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IExitService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService orderService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (!tokenres.isSuccess()) return tokenres;
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        CommonResponse<String> pushres = this.service.pushConfirmEntity(headers, exitEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        if (!pushres.isSuccess()) return pushres;
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        }
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

