package com.ejianc.business.wzxt.controller.api;

import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 退场申请单
 *
 * @Author: songlx
 * @Version: 1.0
 */
@RestController
@RequestMapping("/api/exitApply/")
public class ExitApplyApi {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitApplyService service;


    /**
     * 修改确认结果信息
     *
     * @Param exitApplyVOS: 确认结果集合
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     * @Author songlx
     * @Date 2021-03-18
     **/
    @RequestMapping(value = "confirmResult", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> confirmResult(@RequestBody List<ExitApplyVO> exitApplyVOS) {

        if (CollectionUtils.isNotEmpty(exitApplyVOS)) {
            List<ExitApplyEntity> editlist = new ArrayList<>();
            exitApplyVOS.forEach(vo -> {
                ExitApplyEntity entity = service.getById(vo.getId());
                if (entity == null) {
                    logger.error("修改失败！【" + vo.getId() + "】单据不存在！");
                    return;
                }
                editlist.add(entity);
            });
            if (CollectionUtils.isNotEmpty(editlist)) {
                return CommonResponse.success(service.updateBatchById(editlist));
            }
        }
        return CommonResponse.success(true);


    }


}
