package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.HashMap;
import java.util.Map;

@Service("exit") 
public class ExitBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IExitService service;

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IOrderService orderService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ExitEntity exitEntity = service.selectById(billId);
		exitEntity.setCommitId(InvocationInfoProxy.getUserid());
		service.saveOrUpdate(exitEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ExitEntity exitEntity = service.selectById(billId);

		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = orderService.getAccessToken(headers);
		if(tokenres.isSuccess()){
			logger.info("获取供方token--"+headers);
			CommonResponse<String> pushres = service.pushConfirmEntity(headers,exitEntity);
			logger.info("获取推送供方结果--"+pushres);
			if(pushres.isSuccess()){
				//推送成功后处理逻辑
				if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
					exitEntity.setCommitId(InvocationInfoProxy.getUserid());
				}
				service.saveOrUpdate(exitEntity,false);
			}else{
				return pushres;
			}
		}else{
			return tokenres;
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
