package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 退场申请单
 *
 * @author generator
 */
@Controller
@RequestMapping("exitApply")
public class ExitApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitApplyService service;

    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String billCodeRule = "CSCEC5B_WZXT_EXIT_APPLY";


    /**
     * 关闭/取消申请
     * @Param saveorUpdateVO:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-19
     **/
    @RequestMapping(value = "/upateApplyState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> upateApplyState(@RequestBody ExitApplyVO saveorUpdateVO) {
        ExitApplyEntity entity = BeanMapper.map(saveorUpdateVO, ExitApplyEntity.class);
        entity.setApplyState(entity.getApplyState() == 1 ? 0 : 1);
        service.saveOrUpdate(entity);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> saveOrUpdate(@RequestBody ExitApplyVO saveorUpdateVO) {
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (null == saveorUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
            saveorUpdateVO.setConfirmFlag(0);
            saveorUpdateVO.setApplyState(0);
        }
        ExitApplyEntity entity = BeanMapper.map(saveorUpdateVO, ExitApplyEntity.class);
        service.saveOrUpdate(entity, false);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryDetail(Long id) {
        ExitApplyEntity entity = service.selectById(id);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitApplyVO> vos) {
        service.removeByIds(vos.stream().map(ExitApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例
         * 模糊搜索：单据编号、项目名称、合同名称、出资单位、编制人
         * 高级筛选：退场日期（时间区间）；单据状态（标准筛选）；*/
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ExitApplyEntity> page = service.queryPage(param, false);
        IPage<ExitApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
