/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.mapper.ExitApplyMapper;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitApplyDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="exitApplyService")
public class ExitApplyServiceImpl
extends BaseServiceImpl<ExitApplyMapper, ExitApplyEntity>
implements IExitApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openApi.wjOrderUrl}")
    private String wjOrderUrl;

    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitApplyEntity exitApplyEntity) {
        String url = this.wjOrderUrl;
        ExitApplyGFVO exitApplyGFVO = new ExitApplyGFVO();
        exitApplyGFVO.setId(exitApplyEntity.getId());
        exitApplyGFVO.setOrgId(exitApplyEntity.getParentOrgSourceId());
        exitApplyGFVO.setOrgName(exitApplyEntity.getOrgName());
        exitApplyGFVO.setProjectId(exitApplyEntity.getProjectSourceId());
        exitApplyGFVO.setProjectName(exitApplyEntity.getProjectName());
        exitApplyGFVO.setBillCode(exitApplyEntity.getBillCode());
        exitApplyGFVO.setSupplierId(exitApplyEntity.getSupplierSourceId());
        exitApplyGFVO.setSupplierName(exitApplyEntity.getSupplierName());
        exitApplyGFVO.setContractId(exitApplyEntity.getContractId());
        exitApplyGFVO.setContractName(exitApplyEntity.getContractName());
        exitApplyGFVO.setContractCode(exitApplyEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        exitApplyGFVO.setExitDate(formatter.format(exitApplyEntity.getExitDate()));
        exitApplyGFVO.setExitDesc(exitApplyEntity.getExitDesc());
        if (CollectionUtils.isNotEmpty(exitApplyEntity.getExitApplyDetail())) {
            ArrayList list = new ArrayList();
            exitApplyEntity.getExitApplyDetail().forEach(e -> {
                ExitApplyDetailGFVO exitApplyDetailGFVO = new ExitApplyDetailGFVO();
                exitApplyDetailGFVO.setId(e.getId());
                exitApplyDetailGFVO.setpId(exitApplyEntity.getId());
                exitApplyDetailGFVO.setMaterialId(e.getMaterialSourceId());
                exitApplyDetailGFVO.setMaterialCode(e.getMaterialCode());
                exitApplyDetailGFVO.setMaterialName(e.getMaterialName());
                exitApplyDetailGFVO.setSpec(e.getSpec());
                exitApplyDetailGFVO.setUnit(e.getUnit());
                exitApplyDetailGFVO.setOffRentDate(formatter.format(e.getOffRentDate()));
                exitApplyDetailGFVO.setDef1(e.getDef1());
                exitApplyDetailGFVO.setDef2(e.getDef2());
                exitApplyDetailGFVO.setDef3(e.getDef3());
                exitApplyDetailGFVO.setDef4(e.getDef4());
                exitApplyDetailGFVO.setDef5(e.getDef5());
                exitApplyDetailGFVO.setOnRentNum(e.getOnRentNum() == null ? BigDecimal.ZERO : e.getOnRentNum());
                exitApplyDetailGFVO.setApplyExitNum(e.getApplyExitNum() == null ? BigDecimal.ZERO : e.getApplyExitNum());
                exitApplyDetailGFVO.setExitedNum(e.getExitedNum() == null ? BigDecimal.ZERO : e.getExitedNum());
                list.add(exitApplyDetailGFVO);
            });
            exitApplyGFVO.setExitApplyDetail(list);
        }
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)exitApplyGFVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)exitApplyGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e2) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u9000\u573a\u7533\u8bf7\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage pageData = this.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ExitApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setConfirmFlagName(ExitApplyVO.getConfirmFlagTxt((Integer)vo.getConfirmFlag()));
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("exitApplyExport.xlsx", beans, response);
        }
    }
}

