package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.mapper.ExitApplyMapper;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitApplyDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import com.ejianc.business.wzxt.vo.ExitApplyGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 退场申请单
 *
 * @author generator
 */

@Service("exitApplyService")
public class ExitApplyServiceImpl extends BaseServiceImpl<ExitApplyMapper, ExitApplyEntity> implements IExitApplyService {

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Value("${openApi.wjOrderUrl}")
    private String wjOrderUrl;

    /**
     * 推送供方
     *
     * @Param headers: headers
     * @Param exitApplyEntity:  实体
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @Author songlx
     * @Date 2021-03-22
     **/
    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitApplyEntity exitApplyEntity) {
        String url = wjOrderUrl;
        ExitApplyGFVO exitApplyGFVO = new ExitApplyGFVO();
        exitApplyGFVO.setId(exitApplyEntity.getId());// 主键
        exitApplyGFVO.setOrgId(exitApplyEntity.getParentOrgSourceId());
        ;// 组织主键   传来源组织主键
        exitApplyGFVO.setOrgName(exitApplyEntity.getOrgName());
        exitApplyGFVO.setProjectId(exitApplyEntity.getProjectSourceId());// 项目主键    传来源项目主键
        exitApplyGFVO.setProjectName(exitApplyEntity.getProjectName());
        exitApplyGFVO.setBillCode(exitApplyEntity.getBillCode());// 编码
        exitApplyGFVO.setSupplierId(exitApplyEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        exitApplyGFVO.setSupplierName(exitApplyEntity.getSupplierName());
        exitApplyGFVO.setContractId(exitApplyEntity.getContractId());// 合同主键
        exitApplyGFVO.setContractName(exitApplyEntity.getContractName());
        exitApplyGFVO.setContractCode(exitApplyEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        exitApplyGFVO.setExitDate(formatter.format(exitApplyEntity.getExitDate()));
        exitApplyGFVO.setExitDesc(exitApplyEntity.getExitDesc());

        if (CollectionUtils.isNotEmpty(exitApplyEntity.getExitApplyDetail())) {
            List<ExitApplyDetailGFVO> list = new ArrayList<>();
            exitApplyEntity.getExitApplyDetail().forEach(e -> {
                //非末级才需要同步
                ExitApplyDetailGFVO exitApplyDetailGFVO = new ExitApplyDetailGFVO();
                exitApplyDetailGFVO.setId(e.getId());// 子表主键
                exitApplyDetailGFVO.setpId(exitApplyEntity.getId());// 主表主键
                exitApplyDetailGFVO.setMaterialId(e.getMaterialSourceId());// 材料主键 传来源主键
                exitApplyDetailGFVO.setMaterialCode(e.getMaterialCode());// 材料编码"
                exitApplyDetailGFVO.setMaterialName(e.getMaterialName());// 材料名称
                exitApplyDetailGFVO.setSpec(e.getSpec());// 规格型号
                exitApplyDetailGFVO.setUnit(e.getUnit());// 单位
                exitApplyDetailGFVO.setOffRentDate(formatter.format(e.getOffRentDate()));
                exitApplyDetailGFVO.setDef1(e.getDef1());
                exitApplyDetailGFVO.setDef2(e.getDef2());
                exitApplyDetailGFVO.setDef3(e.getDef3());
                exitApplyDetailGFVO.setDef4(e.getDef4());
                exitApplyDetailGFVO.setDef5(e.getDef5());
                exitApplyDetailGFVO.setOnRentNum(e.getOnRentNum() == null ? BigDecimal.ZERO : e.getOnRentNum());
                exitApplyDetailGFVO.setApplyExitNum(e.getApplyExitNum() == null ? BigDecimal.ZERO : e.getApplyExitNum());
                exitApplyDetailGFVO.setExitedNum(e.getExitedNum() == null ? BigDecimal.ZERO : e.getExitedNum());
                list.add(exitApplyDetailGFVO);
            });
            exitApplyGFVO.setExitApplyDetail(list);
        }
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(exitApplyGFVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON(exitApplyGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方退场申请单异常!");
        }
    }

    /**
     * 导出
     *
     * @param param
     * @param response
     * @Param param: 参数
     * @Param response:
     * @Return void
     * @Author songlx
     * @Date 2021-03-12
     */
    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
/** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<ExitApplyEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ExitApplyVO> list = BeanMapper.mapList(pageData.getRecords(), ExitApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setConfirmFlagName(ExitApplyVO.getConfirmFlagTxt(vo.getConfirmFlag()));
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("exitApplyExport.xlsx", beans, response);
        }
    }

    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     *
     * @param contractId
     * @param materialIds
     * @param tenantId
     * @Param exitApplyVO: 合同id 表体材料库信息
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-22
     */

    @Override
    public List<ExitApplyDetailVO> queryForAddDeatil(String contractId, List<Long> materialIds, Long tenantId) {
        return baseMapper.queryForAddDeatil(contractId, materialIds, tenantId);
    }
}
