package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("order") 
public class OrderBpmServiceImpl implements ICommonBusinessService {

//	@Value("${common.env.base-host}")
//	private String baseHost;

//	@Value("${weChat.templateid}")
//	private String templateid;

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IOrderService orderService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OrderEntity orderEntity = orderService.selectById(billId);
		orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		orderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = orderService.selectById(billId);
		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = orderService.getAccessToken(headers);
		if(tokenres.isSuccess()){
			logger.info("获取供方token--"+headers);
			CommonResponse<String> pushres = orderService.pushOrder(headers,orderEntity);
			logger.info("获取推送供方结果--"+pushres);
			if(pushres.isSuccess()){
				//推送成功后处理逻辑
				if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
					orderEntity.setCommitId(InvocationInfoProxy.getUserid());
				}
				orderEntity.setReceiveState(0);
				orderService.saveOrUpdate(orderEntity,false);
			}else{
				return pushres;
			}
		}else{
			return tokenres;
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//		return CommonResponse.error("采购订单暂不支持回退功能!");
		OrderEntity orderEntity = orderService.selectById(billId);
		if(orderEntity.getReceiveState()==0){
			return CommonResponse.success();
		}else{
			return CommonResponse.error("该订单已被下游操作，不允许回退!");
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = orderService.selectById(billId);
		// TO DO 调用供方接口，删除订单信息
		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = orderService.getAccessToken(headers);
		if(tokenres.isSuccess()) {
			logger.info("获取供方token--" + headers);
			CommonResponse<String> pushres = orderService.pushDelOrder(headers, orderEntity);
			logger.info("获取推送供方结果--" + pushres);
		}

		orderEntity.setReceiveState(0);
		orderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

}
