/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService orderService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (!tokenres.isSuccess()) return tokenres;
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        CommonResponse<String> pushres = this.orderService.pushOrder(headers, orderEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        if (!pushres.isSuccess()) return pushres;
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        }
        orderEntity.setReceiveState(0);
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        if (orderEntity.getReceiveState() == 0) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.orderService.pushDelOrder(headers, orderEntity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        }
        orderEntity.setReceiveState(0);
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }
}

