package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjOrderUrl}")
    private String wjOrderUrl;

    @Value("${openApi.wjDelOrderUrl}")
    private String wjDelOrderUrl;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String WZXT_PURCHASE_BILL_CODE = "WJ_WZXT_PURCHASE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;


    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(orderVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                orderVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        StringBuffer materialName = new StringBuffer();

        List<PlanDetailEntity> listedit = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(null!=vo.getLeafFlag()&&!vo.getLeafFlag()){
                    materialName.append(vo.getMaterialName()+",");
                }
                if(null==vo.getLeafFlag()||vo.getLeafFlag()){
                    //说明是子集
                    vo.setLeafFlag(true);
                    if(null!=vo.getId()){
                        if("del".equals(vo.getRowState())){
                            //说明是子集删除
                            PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                            BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                            BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                            BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//库存量
                            entity.setOccupyNums(occupyNums.subtract(orderNums).subtract(stockAmountSum));
                            entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                            listedit.add(entity);
                        }else{
                            OrderDetailEntity detailEntity = orderDetailService.getById(vo.getId());
                            BigDecimal orderNumsDb = detailEntity.getOrderNumsSum()==null?BigDecimal.ZERO:detailEntity.getOrderNumsSum();// 数据库的订单数量
                            BigDecimal stockAmountSumDb = detailEntity.getStockAmountSum()==null?BigDecimal.ZERO:detailEntity.getStockAmountSum();// 数据库的库存量
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();//前端传的数量
                            BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//前端传的库存量
                            if(orderNums.compareTo(orderNumsDb)!=0||stockAmountSum.compareTo(stockAmountSumDb)!=0){
                                BigDecimal subtractNum = orderNumsDb.subtract(orderNums);//例子  前端传80，数据库为100  则差值为20
                                BigDecimal stockAmountSumNum = stockAmountSumDb.subtract(stockAmountSum);
                                //说明订单数量有修改
                                PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                                BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                                BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                                BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                                entity.setOccupyNums(occupyNums.subtract(subtractNum).subtract(stockAmountSumNum));
                                entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                                if(entity.getSurplusNums().compareTo(BigDecimal.ZERO)<0){
                                    throw new BusinessException("【订单数量+库存量】不能超过计划剩余量，该材料明细实际剩余量为【"+surplusNums+"】!");
                                }
                                listedit.add(entity);

                            }
                        }
                    }else{
                        //说明是子集新增
                        PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                        BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                        BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                        BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();// 剩余
                        BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                        BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//库存量
                        if(surplusNums.compareTo(orderNums.add(stockAmountSum))<0){
                            throw new BusinessException("【订单数量+库存量】不能超过计划剩余量，该材料明细实际剩余量为【"+surplusNums+"】!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums).add(stockAmountSum));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        listedit.add(entity);
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(listedit)){
                planDetailService.updateBatchById(listedit);
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            orderVO.setMaterialName(materialNames);
        }else{
            throw new BusinessException("请添加材料明细!");
        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        entity.setHistoryFlag(0);
//        entity.setReceiveState(0);
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(OrderVO orderVO) {

        //考虑历史数据升级的问题
        LambdaQueryWrapper<OrderEntity> lambda = Wrappers.<OrderEntity>lambdaQuery();
        lambda.eq(OrderEntity::getHistoryId, orderVO.getMainId());
        OrderEntity orderEntity = super.getOne(lambda);
        if(null!=orderEntity && null !=orderEntity.getId() ){
            orderVO.setId(orderEntity.getId());
            LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
            lambda2.eq(OrderDetailEntity::getOrderId, orderEntity.getId());
            List<OrderDetailEntity> details = orderDetailService.list(lambda2);
            if(CollectionUtils.isNotEmpty(details)){
                orderEntity.setPurchaseOrderDetail(details);
                Map<String, Long> map = details.stream().collect(Collectors.toMap(OrderDetailEntity::getHistoryId,OrderDetailEntity::getId));
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    if(map.containsKey(vo.getChildId())){
                        vo.setId(map.get(vo.getChildId()));
                    }
                });
            }
        }else{
            orderEntity = super.selectById(Long.parseLong(orderVO.getMainId()));
            orderVO.setId(orderEntity.getId());
            if(CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())){
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                        vo.setId(Long.parseLong(vo.getChildId()));
                });
            }
        }

        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>0&&4!=orderVO.getReceiveState()){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),1);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if(false == vo.getLeafFlag()){
                        vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                        vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    }
                });
            }
        }else if(2==orderVO.getReceiveState()){
            //部分接收
            orderEntity.setReceiveState(2);//部分接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),2);
                Map<Long, BigDecimal> map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(OrderDetailVO::getId,OrderDetailVO::getReceiveNumsSum));
                logger.debug("map------"+map);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------"+vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
          //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),3);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    // to do
                    if(false == vo.getLeafFlag()) {
                        vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                        vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    }
                });
            }
        }
        if(4==orderVO.getReceiveState()){
            orderEntity.setBillState(0);//自由态
            orderEntity.setDeliverState(4);//已退回
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】退回。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】退回。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分退回数量
                BackOrderDetail(orderVO.getPurchaseOrderDetail());
                Map<Long, BigDecimal> map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(OrderDetailVO::getId,OrderDetailVO::getBackNumsSum));
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if(false == vo.getLeafFlag()){
                        BigDecimal backOrderNumsSum = vo.getBackNumsSum()==null?BigDecimal.ZERO:vo.getBackNumsSum();//退还量
                        BigDecimal backOrderNums = map.get(vo.getId())==null?BigDecimal.ZERO:map.get(vo.getId());//本次退还
                        vo.setBackNumsSum(backOrderNumsSum.add(backOrderNums));
                    }
                });
            }
        }
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        logger.debug("-----主键"+orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }

    @Override
    public CommonResponse<OrderVO> updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>=0){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }
        orderEntity.setReceiveState(2);//部分接收
        orderEntity.setDeliverState(0);//待发货
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            //拆分接收数量
            OrderDetailBack(orderVO.getPurchaseOrderDetail(),2);
            orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }

        // TO DO 定时到期下架消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
        String content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }
    //1-全部接收，2-部分接收，3-全部拒绝 4-退回
    public void OrderDetailBack(List<OrderDetailVO> detailList,int type){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<PlanDetailEntity> planDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());//取当前行的tid

                //查询订单数量>接收数量的明细  根据主键正序排
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                lambda.orderByAsc(OrderDetailEntity::getId);
                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//汇总的接收数量
                    //forEach  不能这样用    xx = xx.subtract(xx);
                    for(int i=0;i<details.size();i++){

                        BigDecimal orderNumsSum = details.get(i).getOrderNumsSum()==null?BigDecimal.ZERO:details.get(i).getOrderNumsSum();//订单量
                        if(receiveNumsSum.compareTo(BigDecimal.ZERO)>0){
                            if(receiveNumsSum.compareTo(orderNumsSum)>=0){
                                //接收数量  大于该行  剩余可接收数量，则直接将该行  接收数量=订单数量即可
                                details.get(i).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            }else{
                                //接收数量  小于该行  剩余可接收数量，则直接将该行  接收数量=原来订单数量+行汇总后的剩余接收数量
                                details.get(i).setReceiveNumsSum(receiveNumsSum);
                                //此时需要回写计划订单明细对应的占用金额
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));//后续批量更新
                        }else {
                            PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                            planDetailList.add(planDetailEntity);
                        }
                    }
                    //批量更新订单明细
                    if(CollectionUtils.isNotEmpty(entityList)){
                        orderDetailService.updateBatchById(entityList);
                    }
                    //批量更新计划明细
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }


    public void BackOrderDetail(List<OrderDetailVO> detailList){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<PlanDetailEntity> planDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());//取当前行的tid

                //查询订单数量>接收数量的明细  根据主键正序排
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                lambda.orderByAsc(OrderDetailEntity::getId);
                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    BigDecimal backNumsSum = vo.getBackNumsSum()==null?BigDecimal.ZERO:vo.getBackNumsSum();//汇总的退回
                    //forEach  不能这样用    xx = xx.subtract(xx);
                    for(int i=0;i<details.size();i++){
                        BigDecimal receiveNumsSum = details.get(i).getReceiveNumsSum()==null?BigDecimal.ZERO:details.get(i).getReceiveNumsSum();//接收量
                        BigDecimal backOrderNumsSum = details.get(i).getBackNumsSum()==null?BigDecimal.ZERO:details.get(i).getBackNumsSum();//退还量
                        BigDecimal orderNumsSum = receiveNumsSum.subtract(backOrderNumsSum);
                        if(backNumsSum.compareTo(BigDecimal.ZERO)>0){
                            if(orderNumsSum.compareTo(backNumsSum)>=0){
                                //例如   退回数量100    接收(300)-退还(100) = 200
                                details.get(i).setBackNumsSum(backOrderNumsSum.add(backNumsSum));
                                backNumsSum = BigDecimal.ZERO;

                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(backNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                planDetailList.add(planDetailEntity);
                            }else{
                                //例如   退回数量100    接收(30)-退还(10) = 20
                                details.get(i).setBackNumsSum(backOrderNumsSum.add(orderNumsSum));
                                //此时需要回写计划订单明细对应的占用金额
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                backNumsSum = backNumsSum.subtract(orderNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));//后续批量更新
                        }
                    }
                    //批量更新订单明细
                    if(CollectionUtils.isNotEmpty(entityList)){
                        orderDetailService.updateBatchById(entityList);
                    }
                    //批量更新计划明细
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }


    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = super.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);

        List<OrderDetailVO> listres = new ArrayList<>();
        List<OrderDetailVO> list = orderVO.getPurchaseOrderDetail();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(vo.getParentId().equals(999L)){
                    listres.add(vo);
                }
                // to do
//                BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//接收数量
//                BigDecimal deliverNumsSum = vo.getDeliverNumsSum()==null?BigDecimal.ZERO:vo.getDeliverNumsSum();//发货数量
//                vo.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));//未发货数量
            });

            listres.forEach(vo -> {
                List<OrderDetailVO> listd = new ArrayList<>();
                list.forEach(e -> {
                    if(vo.getTid().equals(e.getParentId())){
                        listd.add(e);
                    }
                });
                vo.setChildren(listd);
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        return orderVO;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,OrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams  = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        }else{
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if("200".equals(json.get("code").toString())){
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                }else{
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushOrder(Map<String, String> headers,OrderEntity orderEntity){
        String url = wjOrderUrl;
        Purchase purchase = new Purchase();
        purchase.setPkPurchase(String.valueOf(orderEntity.getId()));// 订货单主键
        purchase.setPkOrg(orderEntity.getParentOrgSourceId());;// 组织主键   传来源组织主键
        purchase.setPkProject(orderEntity.getProjectSourceId());// 项目主键    传来源项目主键
        purchase.setProjectName(orderEntity.getProjectName());
        purchase.setPurchaseCode(orderEntity.getBillCode());// 订货单编码
        purchase.setPkSupplier(orderEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        purchase.setSupplierName(orderEntity.getSupplierName());
        purchase.setPkContractPurchase(orderEntity.getContractId());// 采购合同主键
        purchase.setContractPurchaseName(orderEntity.getContractName());
        purchase.setContractPurchaseCode(orderEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setPurchaseCreateDate(formatter.format(orderEntity.getOrderCreateDate()));// 订货单创建时间 yyyy-MM-dd
        purchase.setPurchaseExpiryDate(formatter.format(orderEntity.getOrderExpiryDate()));// 订货单要求送货时间 yyyy-MM-dd
        purchase.setPurchaseLinkMan(orderEntity.getLinkName());// 订货单联系人
        purchase.setPurchaseLinkTelephone(orderEntity.getLinkTelephone());// 订货单联系电话
        purchase.setBillStatus(1);// 订货单状态  传1  代表“待确认”
        purchase.setPurchaseType(orderEntity.getOrderType());
        purchase.setPurchaseNote(orderEntity.getOrderNote());// 送货要求
        purchase.setPurchaseAddress(orderEntity.getOrderAddress());// 送货地址
        purchase.setPlanBody(orderEntity.getConstruction());//使用部位
        purchase.setSmartStatus(orderEntity.getSmartStatus()==null?0:Integer.parseInt(orderEntity.getSmartStatus()));//智能称重标识 0 激活 1 关闭
        purchase.setPlatformType(orderEntity.getPlatformType());//磅点类型 0、请选择   1、实达、 2、沣悦
        purchase.setPlatformCode(orderEntity.getPlatformCode());//磅点编号
        purchase.setSysmark("xpt");//系统标识，“xpt”-新平台
        purchase.setPkCreator("xpt");
        purchase.setCreatorName("五局新平台");
        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));

        if(CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())){
            List<PurchaseInfo> list = new ArrayList<>();
            orderEntity.getPurchaseOrderDetail().forEach(e -> {
                if(!e.getLeafFlag()){
                    //非末级才需要同步
                    PurchaseInfo vo = new PurchaseInfo();
                    vo.setPkPurchaseInfo(String.valueOf(e.getId()));// 订购单子表主键
                    vo.setPkPurchase(String.valueOf(orderEntity.getId()));// 订单表主键
                    vo.setPkMaterial(e.getMaterialSourceId());// 材料主键 传来源主键
                    vo.setMaterialCode(e.getMaterialCode());// 材料编码"
                    vo.setMaterialName(e.getMaterialName());// 材料名称
                    vo.setMaterialSpec(e.getSpec());// 规格
                    vo.setMaterialType(e.getSpec());// 型号
                    vo.setMaterialMeasname(e.getUnit());// 单位
                    vo.setMaterialManufacturer(e.getMaterialManufacturer());// 生产厂家
                    vo.setMaterialNote(e.getMemo());// 材料备注

                    vo.setPlanAmountSum(e.getPlanNumsSum()==null?0:e.getPlanNumsSum().doubleValue());// 计划数量
                    vo.setPlanUncheckAmountSum(e.getSurplusNumsSum()==null?0:e.getSurplusNumsSum().doubleValue());// 计划剩余数量
                    vo.setStockAmountSum(e.getStockAmountSum()==null?0:e.getStockAmountSum().doubleValue());// 库存数量
                    vo.setPurchaseAmountSum(e.getOrderNumsSum()==null?0:e.getOrderNumsSum().doubleValue());// 订单数量
                    vo.setPurchaseCheckAmountSum(e.getReceiveNumsSum()==null?0:e.getReceiveNumsSum().doubleValue());// 接收数量
                    vo.setSmartStatus(e.getSmartStatus()==null?0:Integer.parseInt(e.getSmartStatus()));
                    list.add(vo);
                }
            });
            purchase.setPurchaseInfoList(list);
        }

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }


    /**
     * 弃审删除供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushDelOrder(Map<String, String> headers,OrderEntity orderEntity){
        String url = wjDelOrderUrl;
        String pkPurchase = String.valueOf(orderEntity.getId());
        Map<String,String> map = new HashMap<>();
        map.put("pkPurchase",pkPurchase);
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + pkPurchase);
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.get(url, map, headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }
}
