/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.service.CommonSupportService;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"exitApply"})
public class ExitApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExitApplyService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private CommonSupportService commonSupportService;
    private static final String billCodeRule = "CSCEC5B_WZXT_EXIT_APPLY";

    @RequestMapping(value={"updateConfirmFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitApplyVO> updateConfirmFlag(@RequestBody ExitApplyVO exitApplyVO) {
        ExitApplyEntity entity;
        if (null != exitApplyVO.getId() && (entity = (ExitApplyEntity)((Object)this.service.getById(exitApplyVO.getId()))) == null) {
            return CommonResponse.error((String)("\u4fee\u6539\u5931\u8d25\uff01\u3010" + exitApplyVO.getId() + "\u3011\u5355\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        return this.service.updateConfirmFlag(exitApplyVO);
    }

    @RequestMapping(value={"/queryOrgSource"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderProjectVO> queryOrgSource(Long orgId) {
        CommonResponse parentOrgVo;
        OrderProjectVO res = new OrderProjectVO();
        CommonResponse orgVo = this.orgApi.getOneById(orgId);
        if (!orgVo.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            res.setOrgId(orgId);
            res.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
            res.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
        }
        if (!(parentOrgVo = this.orgApi.getOneById(((OrgVO)orgVo.getData()).getParentId())).isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != parentOrgVo.getData()) {
            res.setParentOrgSourceId(((OrgVO)parentOrgVo.getData()).getSourceId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/upateApplyState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitApplyVO> upateApplyState(@RequestBody ExitApplyVO saveorUpdateVO) {
        ExitApplyEntity entity;
        entity.setApplyState((entity = (ExitApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ExitApplyEntity.class))).getApplyState() == 1 ? 0 : 1);
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitApplyVO> saveOrUpdate(@RequestBody ExitApplyVO saveorUpdateVO) {
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (null == saveorUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode((String)codeBatchByRuleCode.getData());
            saveorUpdateVO.setConfirmFlag(Integer.valueOf(0));
            saveorUpdateVO.setApplyState(Integer.valueOf(0));
        }
        ExitApplyEntity entity = (ExitApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ExitApplyEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ExitApplyVO vo = (ExitApplyVO)BeanMapper.map((Object)((Object)entity), ExitApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryDetail(Long id) {
        ExitApplyEntity entity = (ExitApplyEntity)((Object)this.service.selectById(id));
        ExitApplyVO vo = (ExitApplyVO)BeanMapper.map((Object)((Object)entity), ExitApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExitApplyVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExitApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.service.excelExport(param, response);
    }

    @RequestMapping(value={"/queryForAddDeatil"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExitApplyDetailVO>> queryForAddDeatil(@RequestBody ExitApplyVO exitApplyVO) {
        String contractId = exitApplyVO.getContractId();
        List exitApplyDetail = exitApplyVO.getExitApplyDetail();
        if (StringUtils.isNotEmpty((CharSequence)contractId) && !CollectionUtils.isEmpty((Collection)exitApplyDetail)) {
            List<Long> materialIds = exitApplyDetail.stream().map(ExitApplyDetailVO::getMaterialId).collect(Collectors.toList());
            List<ExitApplyDetailVO> exitApplyDetailVOList = this.service.queryForAddDeatil(contractId, materialIds, InvocationInfoProxy.getTenantid());
            Map<Long, ExitApplyDetailVO> detailVOMap = null;
            if (!CollectionUtils.isEmpty(exitApplyDetailVOList)) {
                detailVOMap = exitApplyDetailVOList.stream().collect(Collectors.toMap(ExitApplyDetailVO::getMaterialId, exitApplyDetailVO -> exitApplyDetailVO));
            }
            for (ExitApplyDetailVO item : exitApplyDetail) {
                Long materialId = item.getMaterialId();
                if (null != detailVOMap && detailVOMap.get(materialId) != null) {
                    ExitApplyDetailVO vo = detailVOMap.get(materialId);
                    item.setExitedNum(vo.getExitedNum());
                    item.setOnRentNum(vo.getOnRentNum());
                    continue;
                }
                item.setExitedNum(item.getExitedNum() == null ? BigDecimal.ZERO : item.getExitedNum());
                item.setOnRentNum(item.getOnRentNum() == null ? BigDecimal.ZERO : item.getOnRentNum());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)exitApplyDetail);
    }
}

