/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.mapper.ExitApplyMapper;
import com.ejianc.business.wzxt.service.CommonSupportService;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitApplyDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import com.ejianc.business.wzxt.vo.ExitApplyGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="exitApplyService")
public class ExitApplyServiceImpl
extends BaseServiceImpl<ExitApplyMapper, ExitApplyEntity>
implements IExitApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${openApi.wjExitApplyUrl}")
    private String wjExitApplyUrl;
    @Autowired
    private CommonSupportService commonSupportService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitApplyEntity exitApplyEntity) {
        String url = this.wjExitApplyUrl;
        ExitApplyGFVO exitApplyGFVO = new ExitApplyGFVO();
        exitApplyGFVO.setId(exitApplyEntity.getId());
        exitApplyGFVO.setOrgId(exitApplyEntity.getParentOrgSourceId());
        exitApplyGFVO.setOrgName(exitApplyEntity.getOrgName());
        exitApplyGFVO.setProjectId(exitApplyEntity.getProjectSourceId());
        exitApplyGFVO.setProjectName(exitApplyEntity.getProjectName());
        exitApplyGFVO.setBillCode(exitApplyEntity.getBillCode());
        exitApplyGFVO.setSupplierId(exitApplyEntity.getSupplierSourceId());
        exitApplyGFVO.setSupplierName(exitApplyEntity.getSupplierName());
        exitApplyGFVO.setContractId(exitApplyEntity.getContractId());
        exitApplyGFVO.setContractName(exitApplyEntity.getContractName());
        exitApplyGFVO.setContractCode(exitApplyEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        exitApplyGFVO.setExitDate(formatter.format(exitApplyEntity.getExitDate()));
        exitApplyGFVO.setExitDesc(exitApplyEntity.getExitDesc());
        exitApplyGFVO.setConfirmFlag(exitApplyEntity.getConfirmFlag() == null ? "0" : String.valueOf(exitApplyEntity.getConfirmFlag()));
        exitApplyGFVO.setPkCreator("xpt");
        exitApplyGFVO.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        exitApplyGFVO.setCreatorDate(DateFormater.getInstance().format("yyyy-MM-dd HH:mm:ss"));
        CommonResponse sceneurRes = this.attachmentApi.queryListBySourceId(exitApplyEntity.getId(), "BT210317000000002", "showImg", null);
        ArrayList sceneurlList = new ArrayList();
        sceneurlList.addAll(((List)sceneurRes.getData()).stream().map(AttachmentVO::getTruePath).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(sceneurlList)) {
            exitApplyGFVO.setSceneurl(String.join((CharSequence)",", sceneurlList));
        }
        if (CollectionUtils.isNotEmpty(exitApplyEntity.getExitApplyDetail())) {
            ArrayList list = new ArrayList();
            exitApplyEntity.getExitApplyDetail().forEach(e -> {
                ExitApplyDetailGFVO exitApplyDetailGFVO = new ExitApplyDetailGFVO();
                exitApplyDetailGFVO.setId(e.getId());
                exitApplyDetailGFVO.setpId(exitApplyEntity.getId());
                exitApplyDetailGFVO.setMaterialId(e.getMaterialSourceId());
                exitApplyDetailGFVO.setMaterialCode(e.getMaterialCode());
                exitApplyDetailGFVO.setMaterialName(e.getMaterialName());
                exitApplyDetailGFVO.setSpec(e.getSpec());
                exitApplyDetailGFVO.setUnit(e.getUnit());
                exitApplyDetailGFVO.setOffRentDate(formatter.format(e.getOffRentDate()));
                exitApplyDetailGFVO.setOnRentNum(e.getOnRentNum() == null ? BigDecimal.ZERO : e.getOnRentNum());
                exitApplyDetailGFVO.setApplyExitNum(e.getApplyExitNum() == null ? BigDecimal.ZERO : e.getApplyExitNum());
                exitApplyDetailGFVO.setExitedNum(e.getExitedNum() == null ? BigDecimal.ZERO : e.getExitedNum());
                list.add(exitApplyDetailGFVO);
            });
            exitApplyGFVO.setExitApplyDetails(list);
        }
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)exitApplyGFVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)exitApplyGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e2) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u9000\u573a\u7533\u8bf7\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage pageData = this.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ExitApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setConfirmFlagName(ExitApplyVO.getConfirmFlagTxt((Integer)vo.getConfirmFlag()));
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("exitApplyExport.xlsx", beans, response);
        }
    }

    @Override
    public List<ExitApplyDetailVO> queryForAddDeatil(String contractId, List<Long> materialIds, Long tenantId) {
        return ((ExitApplyMapper)this.baseMapper).queryForAddDeatil(contractId, materialIds, tenantId);
    }

    @Override
    public CommonResponse<ExitApplyVO> updateConfirmFlag(ExitApplyVO exitApplyVO) {
        ExitApplyEntity entity = (ExitApplyEntity)((Object)super.getById((Serializable)exitApplyVO.getId()));
        entity.setConfirmFlag(exitApplyVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitApplyVO.getConfirmerId());
        entity.setConfirmerName(exitApplyVO.getConfirmerName());
        entity.setConfirmDesc(exitApplyVO.getConfirmDesc());
        super.saveOrUpdate((Object)entity, false);
        ArrayList<String> receiver = new ArrayList<String>();
        receiver.add(String.valueOf(entity.getCommitId()));
        String formurl = this.baseHost + "cscec5b-wzxt-frontend/#/exitApply/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u9000\u573a\u7533\u8bf7\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u3002";
        String content = "\u60a8\u7684\u9000\u573a\u7533\u8bf7\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + (exitApplyVO.getConfirmFlag() == 1 ? "\u786e\u8ba4" : "\u62d2\u7edd") + "\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setChannel(new String[]{"sys", "wjy"});
        parameter.setReceivers(receiver.toArray(new String[receiver.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(String.valueOf(entity.getTenantId()));
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        String linkUrl = this.wjyPath + "cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id=" + entity.getId() + "&userid={userid}";
        this.logger.info(">>>>>>\u5f00\u59cb\u53d1\u9001\u6d88\u606f:  , \u63a5\u6536\u4ebaid : {}, baseHost : {}", (Object)entity.getCommitId(), (Object)this.baseHost);
        this.commonSupportService.sendMsg(parameter, linkUrl);
        this.logger.info(">>>>>>\u53d1\u9001\u6d88\u606f\u7ed3\u675f:  , \u63a5\u6536\u4ebaid : {}, baseHost : {}", (Object)entity.getCommitId(), (Object)this.baseHost);
        return CommonResponse.success();
    }
}

