package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.mapper.ExitApplyMapper;
import com.ejianc.business.wzxt.service.CommonSupportService;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitApplyDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import com.ejianc.business.wzxt.vo.ExitApplyGFVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 退场申请单
 *
 * @author generator
 */

@Service("exitApplyService")
public class ExitApplyServiceImpl extends BaseServiceImpl<ExitApplyMapper, ExitApplyEntity> implements IExitApplyService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${openApi.wjExitApplyUrl}")
    private String wjExitApplyUrl;

    @Autowired
    private CommonSupportService commonSupportService;

    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * 推送供方
     *
     * @Param headers: headers
     * @Param exitApplyEntity:  实体
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @Author songlx
     * @Date 2021-03-22
     **/
    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitApplyEntity exitApplyEntity) {
        String url = wjExitApplyUrl;
        ExitApplyGFVO exitApplyGFVO = new ExitApplyGFVO();
        exitApplyGFVO.setId(String.valueOf(exitApplyEntity.getId()));// 主键
        exitApplyGFVO.setOrgId(exitApplyEntity.getParentOrgSourceId());
        // 组织主键   传来源组织主键
        exitApplyGFVO.setOrgName(exitApplyEntity.getOrgName());
        exitApplyGFVO.setProjectId(exitApplyEntity.getProjectSourceId());// 项目主键    传来源项目主键
        exitApplyGFVO.setProjectName(exitApplyEntity.getProjectName());
        exitApplyGFVO.setBillCode(exitApplyEntity.getBillCode());// 编码
        exitApplyGFVO.setSupplierId(exitApplyEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        exitApplyGFVO.setSupplierName(exitApplyEntity.getSupplierName());
        exitApplyGFVO.setContractId(exitApplyEntity.getContractId());// 合同主键
        exitApplyGFVO.setContractName(exitApplyEntity.getContractName());
        exitApplyGFVO.setContractCode(exitApplyEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        exitApplyGFVO.setExitDate(formatter.format(exitApplyEntity.getExitDate()));
        exitApplyGFVO.setExitDesc(exitApplyEntity.getExitDesc());
        exitApplyGFVO.setLinkName(exitApplyEntity.getLinkName());
        exitApplyGFVO.setLinkTelephone(exitApplyEntity.getLinkTelephone());
        exitApplyGFVO.setConfirmFlag(exitApplyEntity.getConfirmFlag() == null ? "0" : String.valueOf(exitApplyEntity.getConfirmFlag()));
        exitApplyGFVO.setPkCreator("xpt");
        exitApplyGFVO.setCreatorName("五局新平台");
        exitApplyGFVO.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
        CommonResponse<List<AttachmentVO>> sceneurRes = attachmentApi.queryListBySourceId(exitApplyEntity.getId(), "BT210317000000002", "showImg", null);
        List<String> sceneurlList = new ArrayList<>();
        sceneurlList.addAll(sceneurRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(sceneurlList)) {
            exitApplyGFVO.setSceneurl(String.join(",", sceneurlList));
        }

        if (CollectionUtils.isNotEmpty(exitApplyEntity.getExitApplyDetail())) {
            List<ExitApplyDetailGFVO> list = new ArrayList<>();
            exitApplyEntity.getExitApplyDetail().forEach(e -> {
                //非末级才需要同步
                ExitApplyDetailGFVO exitApplyDetailGFVO = new ExitApplyDetailGFVO();
                exitApplyDetailGFVO.setId(String.valueOf(e.getId()));// 子表主键
                exitApplyDetailGFVO.setpId(String.valueOf(exitApplyEntity.getId()));// 主表主键
                exitApplyDetailGFVO.setMaterialTypeId(String.valueOf(e.getMaterialTypeId()));
                exitApplyDetailGFVO.setMaterialTypeName(e.getMaterialTypeName());
                exitApplyDetailGFVO.setMaterialId(e.getMaterialSourceId());// 材料主键 传来源主键
                exitApplyDetailGFVO.setMaterialCode(e.getMaterialCode());// 材料编码"
                exitApplyDetailGFVO.setMaterialName(e.getMaterialName());// 材料名称
                exitApplyDetailGFVO.setSpec(e.getSpec());// 规格型号
                exitApplyDetailGFVO.setUnit(e.getUnit());// 单位
                exitApplyDetailGFVO.setOffRentDate(formatter.format(e.getOffRentDate()));
                exitApplyDetailGFVO.setOnRentNum(e.getOnRentNum() == null ? BigDecimal.ZERO : e.getOnRentNum());
                exitApplyDetailGFVO.setApplyExitNum(e.getApplyExitNum() == null ? BigDecimal.ZERO : e.getApplyExitNum());
                exitApplyDetailGFVO.setExitedNum(e.getExitedNum() == null ? BigDecimal.ZERO : e.getExitedNum());
                exitApplyDetailGFVO.setMemo(e.getMemo());
                list.add(exitApplyDetailGFVO);
            });
            exitApplyGFVO.setExitApplyDetails(list);
        }
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(exitApplyGFVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON(exitApplyGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方退场申请单异常!");
        }
    }

    /**
     * 导出
     *
     * @param param
     * @param response
     * @Param param: 参数
     * @Param response:
     * @Return void
     * @Author songlx
     * @Date 2021-03-12
     */
    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
/** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<ExitApplyEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ExitApplyVO> list = BeanMapper.mapList(pageData.getRecords(), ExitApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setConfirmFlagName(ExitApplyVO.getConfirmFlagTxt(vo.getConfirmFlag()));
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("exitApplyExport.xlsx", beans, response);
        }
    }

    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     *
     * @param contractId
     * @param materialIds
     * @param tenantId
     * @Param exitApplyVO: 合同id 表体材料库信息
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-22
     */

    @Override
    public List<ExitApplyDetailVO> queryForAddDeatil(String contractId, List<Long> materialIds, Long tenantId) {
        return baseMapper.queryForAddDeatil(contractId, materialIds, tenantId);
    }

    /**
     * 修改确认状态
     *
     * @param exitApplyVO
     * @Param exitApplyVO: exitApplyVO
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-23
     */
    @Override
    public CommonResponse<ExitApplyVO> updateConfirmFlag(ExitApplyVO exitApplyVO) {
        ExitApplyEntity entity = super.getById(exitApplyVO.getId());
        entity.setConfirmFlag(exitApplyVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitApplyVO.getConfirmerId());
        entity.setConfirmerName(exitApplyVO.getConfirmerName());
        entity.setConfirmDesc(exitApplyVO.getConfirmDesc());
        super.saveOrUpdate(entity, false);
        //组织消息参数
        List<String> receiver = new ArrayList<>();
        receiver.add(String.valueOf(entity.getCommitId()));
        String formurl = baseHost + "cscec5b-wzxt-frontend/#/exitApply/card?id=" + entity.getId();
        String subject = "您的退场申请单【" + entity.getProjectName() + "--" + entity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + entity.getSupplierName() + "】。";
        String content = "您的退场申请单【" + entity.getProjectName() + "--" + entity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + entity.getSupplierName() + "】" + (exitApplyVO.getConfirmFlag() == 1 ? "确认" : "拒绝") + "。<a href=" + '"' + formurl + '"' + ">前往点击</a>";

        //装载消息信息
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_WJY});
        parameter.setReceivers(receiver.toArray(new String[receiver.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(String.valueOf(entity.getTenantId()));
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        //TODO url 需要替换
        String linkUrl = wjyPath + "cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id=" + entity.getId() + "&userid={userid}";
        logger.info(">>>>>>开始发送消息:  , 接收人id : {}, baseHost : {}", entity.getCommitId(), baseHost);
        commonSupportService.sendMsg(parameter, linkUrl);
        logger.info(">>>>>>发送消息结束:  , 接收人id : {}, baseHost : {}", entity.getCommitId(), baseHost);
        return CommonResponse.success();
    }
}
