package com.ejianc.business.wzxt.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ControlPlanDetailEntity;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.service.IControlPlanDetailService;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.vo.ControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.ControlPlanVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/zjwjsync/")
public class ZjwjSyncApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IProjectApi projectApi;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private IMaterialApi materialApi;

	@Autowired
	private IControlPlanService controlPlanService;

	@Autowired
	private IControlPlanDetailService controlPlanDetailService;

	/**
	 * 同步总控计划主表
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanList")
	public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
		List<ControlPlanEntity> entityList = new ArrayList<>();
		for(SyncControlPlanVO syncVO : controlPlanVOS) {
			ControlPlanVO vo = syncVO.getValue();
			ControlPlanEntity entity = BeanMapper.map(vo, ControlPlanEntity.class);
			entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
			LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(ControlPlanEntity::getSourceId, vo.getSourceId());
			ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
			if(null == dbEntity){
				//新增
				entity.setId(IdWorker.getId());

			}else {
				entity.setId(dbEntity.getId());
			}

			if(entity.getParentOrgSourceId() != null){
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getParentOrgSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setParentOrgId(orgVO.getId());
				}
			}

			if(entity.getProjectSourceId() != null){
				CommonResponse<ProjectRegisterVO> registerVOCommonResponse = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
				if(registerVOCommonResponse.isSuccess()){
					ProjectRegisterVO projectRegisterVO = registerVOCommonResponse.getData();
					entity.setProjectId(projectRegisterVO.getId());
					entity.setProjectName(projectRegisterVO.getName());
					entity.setOrgId(projectRegisterVO.getOrgId());
					CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(projectRegisterVO.getOrgId());
					if(orgVOCommonResponse.isSuccess()){
						OrgVO orgVO = orgVOCommonResponse.getData();
						entity.setOrgSourceId(orgVO.getSourceId());
					}
					entity.setOrgName(projectRegisterVO.getOrgName());
				}
			}

			if(syncVO.getSourceEmployeeId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceEmployeeId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setEmployeeId(userVO.getId());
					entity.setEmployeeName(userVO.getUserName());
				}
			}

			if(syncVO.getSourceCreatorId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceCreatorId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setCreateUserCode(userVO.getUserCode());
				}
			}
			entityList.add(entity);
		}
		//必须单条保存.......
		controlPlanService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表头开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表头成功！");
	}


	/**
	 * @describe 同步总控计划表体
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanDetailList")
	public CommonResponse<String> syncControlPlanDetailList(@RequestBody  List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
		List<ControlPlanDetailEntity> entityList = new ArrayList<>();
		for(SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
			ControlPlanDetailVO vo = syncVO.getValue();
			ControlPlanDetailEntity entity = BeanMapper.map(vo, ControlPlanDetailEntity.class);
			LambdaQueryWrapper<ControlPlanDetailEntity> queryDetailWrapper = new LambdaQueryWrapper<>();
			queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, vo.getSourceId());
			ControlPlanDetailEntity dbDetaliEntity = controlPlanDetailService.getOne(queryDetailWrapper, false);
			if(null == dbDetaliEntity){
				//新增
				entity.setId(IdWorker.getId());
			}else {
				entity.setId(dbDetaliEntity.getId());
			}


			if(syncVO.getSourceControlId() != null){
				LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(ControlPlanEntity::getSourceId, syncVO.getSourceControlId());
				ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
				entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
			}

			if(vo.getMaterialSourceId() != null){
				CommonResponse<MaterialVO> materialVOCommonResponse = materialApi.queryMaterialBySourceId(vo.getMaterialSourceId());
				if(materialVOCommonResponse.isSuccess()){
					MaterialVO materialVO = materialVOCommonResponse.getData();
					entity.setMaterialId(materialVO.getId());
					entity.setMaterialCode(materialVO.getCode());
					entity.setMaterialName(materialVO.getName());
					entity.setUnit(materialVO.getUnitName());
					entity.setSpec(materialVO.getSpec());
					entity.setDef1(materialVO.getDef1());//规格
					entity.setDef2(materialVO.getDef2());//型号
					entity.setDef3(materialVO.getDef3());//来源物料主键
					entity.setMaterialTypeId(materialVO.getCategoryId());


					CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = materialApi.queryCategoryById(materialVO.getCategoryId());
					if(materialCategoryVOCommonResponse.isSuccess()){
						MaterialCategoryVO materialCategoryVO = materialCategoryVOCommonResponse.getData();
						entity.setMaterialTypeName(materialCategoryVO.getName());
						entity.setMaterialSourceTypeId(materialVO.getCategorySourceId());
					}
				}
			}

			entityList.add(entity);
		}
		controlPlanDetailService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表体开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表体成功！");
	}
}
