package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.vo.ExitReportVO;
import com.ejianc.business.wzxt.vo.ExitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 退场单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("exit")
public class ExitController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IExitService service;

    @Autowired
    private IExitApplyService exitApplyService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdate(@RequestBody ExitVO saveorUpdateVO) {
        // 保存态
        saveorUpdateVO.setSaveState(1);
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description saveOrUpdateTemp 暂存或者修改
     */
    @RequestMapping(value = "/saveOrUpdateTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdateTemp(@RequestBody ExitVO saveorUpdateVO) {
        // 暂存态
        saveorUpdateVO.setSaveState(0);
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryDetail(Long id) {
    	ExitEntity entity = service.selectById(id);
    	ExitVO vo = BeanMapper.map(entity, ExitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 根据项目+登录人获取 最近一次联系人，联系电话，地址等信息
     * @param
     */
    @RequestMapping(value = "/queryLinkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryLinkDetail(Long projectId) {
        List<ExitEntity> details = null;
        LambdaQueryWrapper<ExitEntity> lambda = Wrappers.<ExitEntity>lambdaQuery();
        lambda.eq(ExitEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ExitEntity::getProjectId,projectId);
        lambda.eq(ExitEntity::getEmployeeId,InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(ExitEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0),ExitVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description queryDetail 查询复制申请单详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryCopyDetail(Long id) {
        ExitApplyEntity applyEntity = exitApplyService.selectById(id);
        ExitVO vo = BeanMapper.map(applyEntity, ExitVO.class);
        vo.setApplyId(applyEntity.getId());
        vo.setId(null);
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setLinkId(null);
        vo.setLinkName(null);
        vo.setLinkTelephone(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setConfirmFlag(0);
        vo.setConfirmDate(null);
        vo.setConfirmerId(null);
        vo.setConfirmerName(null);
        vo.setConfirmNote(null);
        vo.setExitDate(null);
        vo.setBillState(0);
        vo.setBillCode(null);
        vo.setDef1(null);
        vo.setDef2(null);
        vo.setDef3(null);
        vo.setDef4(null);
        vo.setDef5(null);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitVO> vos) {
        service.removeByIds(vos.stream().map(ExitVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter(QueryParam.NE, 0));
        boolean mobile = param.getParams().containsKey("mobile");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }else{
            param.getParams().remove("mobile");
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询暂存列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTempList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryTempList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 0));
        //移动端没有当前组织，按照当前登录人权限取组织
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter(QueryParam.NE, 0));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));
        List<ExitVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if(null!=vo.getConfirmFlag()&&0==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("待确认");
                }else if(null!=vo.getConfirmFlag()&&1==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("已确认");
                }else if(null!=vo.getConfirmFlag()&&2==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("已拒绝");
                }
                if(null!=vo.getIsaddrecord()&&"0".equals(vo.getIsaddrecord())){
                    vo.setIsaddrecord("否");
                }else {
                    vo.setIsaddrecord("是");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("exitExport.xlsx", beans, response);
    }


    /**
     * @Description  更新确认状态
     */
    @RequestMapping(value = "/updateConfirmFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> updateConfirmFlag(@RequestBody ExitVO exitVO) {
        return service.updateConfirmFlag(exitVO);
    }


    /**
     * @Description 周转材进出场台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryExitReports", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitReportVO>> queryExitReports(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate","asc");
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryExitReport(page,wrapper);
        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/ExitReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void ExitReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate","asc");
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryExitReport(page,wrapper);
        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                if(0==vo.getType()){
                    vo.setTypeName("进场");
                }else{
                    vo.setTypeName("退场");
                }
            });
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("exitReportExport.xlsx", beans, response);
    }

    /**
     * @Description 周转材租赁台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryZlReports", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitReportVO>> queryZlReports(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryZlReports(page,wrapper,Long.valueOf(projectId));
        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/zlReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void zlReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryZlReports(page,wrapper,Long.valueOf(projectId));
        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("zlReportExport.xlsx", beans, response);
    }
}
