package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单实体
 * 
 * @author sunyj
 * 
 */
@Controller
@RequestMapping("purchaseOrder")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    @Autowired
    private IOrderService service;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IOrgApi orgApi;

//    @Autowired
//    private ICommonBusinessService order;

    @Autowired
    private IWeighService weighService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
//        order.afterApprovalProcessor(378608416132956164L,1,"");
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description queryDetail 根据项目+登录人获取 最近一次联系人，联系电话，地址等信息
     * @param
     */
    @RequestMapping(value = "/queryLinkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryLinkDetail(Long projectId) {
        List<OrderEntity> details = null;
        LambdaQueryWrapper<OrderEntity> lambda = Wrappers.<OrderEntity>lambdaQuery();
        lambda.eq(OrderEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(OrderEntity::getProjectId,projectId);
        lambda.eq(OrderEntity::getEmployeeId,InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(OrderEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0),OrderVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description queryDetail 根据项目+登录人获取 最近一次联系人，联系电话，地址等信息
     * @param
     */
    @RequestMapping(value = "/queryOrgSource", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderProjectVO> queryLinkDetail2(Long orgId) {
        OrderProjectVO res = new OrderProjectVO();
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(orgId);
        if(!orgVo.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        if(null!=orgVo.getData()){
            res.setOrgId(orgId);
            res.setOrgSourceId(orgVo.getData().getSourceId());
            res.setParentOrgId(orgVo.getData().getParentId());
            CommonResponse<WeighVO> weihgvo = weighService.getWeighByProjectDepartmentId(orgId);
            if(weihgvo.isSuccess()&& null!=weihgvo.getData()){
                res.setSmartStatus(weihgvo.getData().getWeighFlag());
                res.setPlatformCode(weihgvo.getData().getScsStationCode());
                res.setPlatformType(weihgvo.getData().getScsTypeId());
            }else{
                res.setSmartStatus("0");
                res.setPlatformCode(null);
                res.setPlatformType(null);
            }
        }
        //查询上级
        CommonResponse<OrgVO> parentOrgVo = orgApi.getOneById(orgVo.getData().getParentId());
        if(!parentOrgVo.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        if(null!=parentOrgVo.getData()){
            res.setParentOrgSourceId(parentOrgVo.getData().getSourceId());
        }

        return CommonResponse.success("查询详情数据成功！", res);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            List<PlanDetailEntity> listedit = new ArrayList<>();
            vos.forEach(vo ->{
                List<OrderDetailEntity> details = null;
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getOrderId,vo.getId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                details = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    details.forEach(e ->{
                        //说明是子集删除
                        PlanDetailEntity entity = planDetailService.getById(e.getPlanDetailId());
                        BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                        BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                        BigDecimal orderNums = e.getOrderNumsSum()==null?BigDecimal.ZERO:e.getOrderNumsSum();
                        BigDecimal stockAmountSum = e.getStockAmountSum()==null?BigDecimal.ZERO:e.getStockAmountSum();//库存量
                        entity.setOccupyNums(occupyNums.subtract(orderNums).subtract(stockAmountSum));
                        entity.setSurplusNums(surplusNums.add(orderNums));
                        listedit.add(entity);
                    });
                }

            });
            if(CollectionUtils.isNotEmpty(listedit)){
                planDetailService.updateBatchById(listedit);
            }
        }

        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("isMyCreate");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("isMyCreate");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }
            });
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  更新接收状态
     */
    @RequestMapping(value = "/updateReceived", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody OrderVO saveorUpdateVO) {
        return service.updateReceived(saveorUpdateVO);
    }

//    /**
//     * @Description  部分接收
//     */
//    @RequestMapping(value = "/updateReceivedPart", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<OrderVO> updateReceivedPart(@RequestBody OrderVO saveorUpdateVO) {
//        return service.updateReceivedPart(saveorUpdateVO);
//    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("isMyCreate");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("isMyCreate");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        List<OrderVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("orderExport.xlsx", beans, response);
    }

}
