/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ScsTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"smartweigh"})
public class SmartWeighController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${smartWeigh.addr}")
    private String smartWeighHost;

    @RequestMapping(value={"/refData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ScsTypeVO>> refData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Page result = null;
        List all = null;
        ArrayList<ScsTypeVO> list = new ArrayList<ScsTypeVO>();
        try {
            String url = this.smartWeighHost + "/el/sw/scstype/list";
            String backData = HttpTookit.get(url, null, headers);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            JSONArray datas = (JSONArray)jsonResponse.get((Object)"body");
            if (datas != null && datas.size() > 0) {
                all = JSONObject.parseArray((String)datas.toJSONString(), ScsTypeVO.class);
                for (ScsTypeVO scsTypeVO : all) {
                    scsTypeVO.setId(Long.valueOf(IdWorker.getId()));
                    if (!StringUtils.isBlank((CharSequence)searchText) && !scsTypeVO.getScsType().contains(searchText)) continue;
                    list.add(scsTypeVO);
                }
                result = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), (long)all.size());
                result.setRecords(list);
            }
        }
        catch (GeneralSecurityException e) {
            this.logger.error(e.getMessage());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", result);
    }
}

