/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weighDetail"})
public class WeighDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeighDetailService weighDetailService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeighDetailVO> saveOrUpdate(@RequestBody WeighDetailVO saveorUpdateVO) {
        WeighDetailEntity entity = (WeighDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WeighDetailEntity.class));
        this.weighDetailService.saveOrUpdate((Object)entity, false);
        WeighDetailVO vo = (WeighDetailVO)BeanMapper.map((Object)((Object)entity), WeighDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/MaterialBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WeighDetailVO>> MaterialBatch(@RequestBody List<WeighDetailVO> saveorUpdateBatchVO) {
        CommonResponse orgVo;
        Long orgId = InvocationInfoProxy.getOrgId();
        LambdaQueryWrapper queryWrapperDetailOld = Wrappers.lambdaQuery();
        queryWrapperDetailOld.eq(WeighDetailEntity::getOrgId, (Object)orgId);
        List weighDetailEntityListOld = this.weighDetailService.list((Wrapper)queryWrapperDetailOld);
        ArrayList<WeighDetailVO> removeList = new ArrayList<WeighDetailVO>();
        if (ListUtil.isNotEmpty((List)weighDetailEntityListOld)) {
            for (WeighDetailVO weighDetailVO : saveorUpdateBatchVO) {
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityListOld) {
                    if (!weighDetailVO.getMaterialId().equals(weighDetailEntity.getMaterialId())) continue;
                    removeList.add(weighDetailVO);
                }
            }
        }
        if (ListUtil.isNotEmpty(removeList)) {
            saveorUpdateBatchVO.removeAll(removeList);
        }
        if (!(orgVo = this.orgApi.getOneById(orgId)).isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25\uff01");
        }
        OrgVO orgVoData = (OrgVO)orgVo.getData();
        if (orgVoData.getOrgType() == 5) {
            Long parentId = orgVoData.getParentId();
            LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
            queryWrapperDetail.eq(WeighDetailEntity::getOrgId, (Object)parentId);
            List weighDetailEntityList = this.weighDetailService.list((Wrapper)queryWrapperDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0) {
                for (WeighDetailVO weighDetailVO : saveorUpdateBatchVO) {
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList) {
                        if (!weighDetailVO.getMaterialId().equals(weighDetailEntity.getMaterialId())) continue;
                        weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                    }
                }
            }
        }
        for (WeighDetailVO weighDetailVO : saveorUpdateBatchVO) {
            weighDetailVO.setOrgId(orgId);
        }
        List listEntity = BeanMapper.mapList(saveorUpdateBatchVO, WeighDetailEntity.class);
        this.weighDetailService.saveOrUpdateBatch(listEntity);
        List vo = BeanMapper.mapList((Iterable)listEntity, WeighDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeighDetailVO> queryDetail(Long id) {
        WeighDetailEntity entity = (WeighDetailEntity)((Object)this.weighDetailService.selectById(id));
        WeighDetailVO vo = (WeighDetailVO)BeanMapper.map((Object)((Object)entity), WeighDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeighDetailVO> vos) {
        this.weighDetailService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeighDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        IPage page = this.weighDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeighDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getdetailByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeighDetailVO> getdetailByOrgId(Long projectDepartmentId, Long materialId) {
        return this.weighDetailService.getdetailByOrgId(projectDepartmentId, materialId);
    }
}

