/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ControlPlanDetailEntity;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.service.IControlPlanDetailService;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.vo.ControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.ControlPlanVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zjwjsync/"})
public class ZjwjSyncApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IControlPlanDetailService controlPlanDetailService;

    @PostMapping(value={"syncControlPlanList"})
    public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
        ArrayList<ControlPlanEntity> entityList = new ArrayList<ControlPlanEntity>();
        for (SyncControlPlanVO syncVO : controlPlanVOS) {
            UserVO userVO;
            CommonResponse userVOCommonResponse;
            CommonResponse orgVOCommonResponse;
            ControlPlanVO vo = syncVO.getValue();
            ControlPlanEntity entity = (ControlPlanEntity)((Object)BeanMapper.map((Object)vo, ControlPlanEntity.class));
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
            if (null == dbEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbEntity.getId());
            }
            if (entity.getParentOrgSourceId() != null && (orgVOCommonResponse = this.orgApi.findBySourceId(entity.getParentOrgSourceId())).isSuccess()) {
                OrgVO orgVO = (OrgVO)orgVOCommonResponse.getData();
                entity.setParentOrgId(orgVO.getId());
            }
            if (entity.getProjectSourceId() != null) {
                CommonResponse orgVOCommonResponse2;
                CommonResponse registerVOCommonResponse = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId());
                if (registerVOCommonResponse.isSuccess()) {
                    ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)registerVOCommonResponse.getData();
                    entity.setProjectId(projectRegisterVO.getId());
                    entity.setProjectName(projectRegisterVO.getName());
                }
                if ((orgVOCommonResponse2 = this.orgApi.findBySourceId(entity.getProjectSourceId())).isSuccess()) {
                    OrgVO orgVO = (OrgVO)orgVOCommonResponse2.getData();
                    entity.setOrgId(orgVO.getId());
                    entity.setOrgSourceId(orgVO.getSourceId());
                    entity.setOrgName(orgVO.getName());
                }
            }
            if (syncVO.getSourceEmployeeId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceEmployeeId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setEmployeeId(userVO.getId());
                entity.setEmployeeName(userVO.getUserName());
            }
            if (syncVO.getSourceCreatorId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceCreatorId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setCreateUserCode(userVO.getUserCode());
            }
            entityList.add(entity);
        }
        this.controlPlanService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncControlPlanDetailList"})
    public CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
        ArrayList<ControlPlanDetailEntity> entityList = new ArrayList<ControlPlanDetailEntity>();
        for (SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
            CommonResponse materialVOCommonResponse;
            ControlPlanDetailVO vo = syncVO.getValue();
            ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)BeanMapper.map((Object)vo, ControlPlanDetailEntity.class));
            LambdaQueryWrapper queryDetailWrapper = new LambdaQueryWrapper();
            queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanDetailEntity dbDetaliEntity = (ControlPlanDetailEntity)((Object)this.controlPlanDetailService.getOne((Wrapper)queryDetailWrapper, false));
            if (null == dbDetaliEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbDetaliEntity.getId());
            }
            if (syncVO.getSourceControlId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)syncVO.getSourceControlId());
                ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
                entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
            }
            if (vo.getMaterialSourceId() != null && (materialVOCommonResponse = this.materialApi.queryMaterialBySourceId(vo.getMaterialSourceId())).isSuccess()) {
                MaterialVO materialVO = (MaterialVO)materialVOCommonResponse.getData();
                entity.setMaterialId(materialVO.getId());
                entity.setMaterialCode(materialVO.getCode());
                entity.setMaterialName(materialVO.getName());
                entity.setUnit(materialVO.getUnitName());
                entity.setSpec(materialVO.getSpec());
                entity.setDef1(materialVO.getDef1());
                entity.setDef2(materialVO.getDef2());
                entity.setDef3(materialVO.getDef3());
                entity.setMaterialTypeId(materialVO.getCategoryId());
                CommonResponse materialCategoryVOCommonResponse = this.materialApi.queryCategoryById(materialVO.getCategoryId());
                if (materialCategoryVOCommonResponse.isSuccess()) {
                    MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)materialCategoryVOCommonResponse.getData();
                    entity.setMaterialTypeName(materialCategoryVO.getName());
                    entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
                }
            }
            entityList.add(entity);
        }
        this.controlPlanDetailService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u6210\u529f\uff01");
    }
}

