package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ControlPlanDetailEntity;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.bean.MroProjectEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.service.IControlPlanDetailService;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.service.IMroProjectService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.business.wzxt.vo.sync.SyncMroProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/api/zjwjsync/")
public class ZjwjSyncApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${mro.addr}")
	private String addr;

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IProjectApi projectApi;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private IMaterialApi materialApi;

	@Autowired
	private IControlPlanService controlPlanService;

	@Autowired
	private IControlPlanDetailService controlPlanDetailService;

	@Autowired
	private IMroProjectService mroProjectService;

	@Autowired
	private IProjectConfigureService projectConfigureService;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	/**
	 * 同步总控计划主表
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanList")
	public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
		List<ControlPlanEntity> entityList = new ArrayList<>();
		for(SyncControlPlanVO syncVO : controlPlanVOS) {
			ControlPlanVO vo = syncVO.getValue();
			ControlPlanEntity entity = BeanMapper.map(vo, ControlPlanEntity.class);
			entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
			LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(ControlPlanEntity::getSourceId, vo.getSourceId());
			ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
			if(null == dbEntity){
				//新增
				entity.setId(IdWorker.getId());

			}else {
				entity.setId(dbEntity.getId());
			}

			if(entity.getParentOrgSourceId() != null){
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getParentOrgSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setParentOrgId(orgVO.getId());
				}
			}

			if(entity.getProjectSourceId() != null){
				CommonResponse<ProjectRegisterVO> registerVOCommonResponse = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
				if(registerVOCommonResponse.isSuccess()){
					ProjectRegisterVO projectRegisterVO = registerVOCommonResponse.getData();
					entity.setProjectId(projectRegisterVO.getId());
					entity.setProjectName(projectRegisterVO.getName());
				}
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getProjectSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setOrgId(orgVO.getId());
					entity.setOrgSourceId(orgVO.getSourceId());
					entity.setOrgName(orgVO.getName());
				}
			}

			if(syncVO.getSourceEmployeeId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceEmployeeId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setEmployeeId(userVO.getId());
					entity.setEmployeeName(userVO.getUserName());
				}
			}

			if(syncVO.getSourceCreatorId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceCreatorId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setCreateUserCode(userVO.getUserCode());
				}
			}
			entityList.add(entity);
		}
		//必须单条保存.......
		controlPlanService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表头开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表头成功！");
	}


	/**
	 * @describe 同步总控计划表体
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanDetailList")
	public CommonResponse<String> syncControlPlanDetailList(@RequestBody  List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
		List<ControlPlanDetailEntity> entityList = new ArrayList<>();
		for(SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
			ControlPlanDetailVO vo = syncVO.getValue();
			ControlPlanDetailEntity entity = BeanMapper.map(vo, ControlPlanDetailEntity.class);
			LambdaQueryWrapper<ControlPlanDetailEntity> queryDetailWrapper = new LambdaQueryWrapper<>();
			queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, vo.getSourceId());
			ControlPlanDetailEntity dbDetaliEntity = controlPlanDetailService.getOne(queryDetailWrapper, false);
			if(null == dbDetaliEntity){
				//新增
				entity.setId(IdWorker.getId());
			}else {
				entity.setId(dbDetaliEntity.getId());
			}


			if(syncVO.getSourceControlId() != null){
				LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(ControlPlanEntity::getSourceId, syncVO.getSourceControlId());
				ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
				entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
			}

			if(vo.getMaterialSourceId() != null){
				CommonResponse<MaterialVO> materialVOCommonResponse = materialApi.queryMaterialBySourceId(vo.getMaterialSourceId());
				if(materialVOCommonResponse.isSuccess()){
					MaterialVO materialVO = materialVOCommonResponse.getData();
					entity.setMaterialId(materialVO.getId());
					entity.setMaterialCode(materialVO.getCode());
					entity.setMaterialName(materialVO.getName());
					entity.setUnit(materialVO.getUnitName());
					entity.setSpec(materialVO.getSpec());
					entity.setDef1(materialVO.getDef1());//规格
					entity.setDef2(materialVO.getDef2());//型号
					entity.setDef3(materialVO.getDef3());//来源物料主键
					entity.setMaterialTypeId(materialVO.getCategoryId());


					CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = materialApi.queryCategoryById(materialVO.getCategoryId());
					if(materialCategoryVOCommonResponse.isSuccess()){
						MaterialCategoryVO materialCategoryVO = materialCategoryVOCommonResponse.getData();
						entity.setMaterialTypeName(materialCategoryVO.getName());
						entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
					}
				}
			}

			entityList.add(entity);
		}
		controlPlanDetailService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表体开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表体成功！");
	}

	/**
	 * 同步MRO项目
	 * @return
	 */
	@GetMapping(value = "syncMroProjectList")
	public CommonResponse<String> syncMroProjectList() {
		Map<String, String> headers = new HashMap<>();
		//TODO
		headers.put("x_open_appkey", "x_open_appkey");
		headers.put("x_open_nonce", "x_open_appkey");
		headers.put("x_open_timestamp", "x_open_appkey");
		headers.put("x_open_sg", "x_open_appkey");
		CommonResponse<String> stringCommonResponse = getAccessToken(headers);
		if(!stringCommonResponse.isSuccess()){
			logger.info(stringCommonResponse.getData());
		}

		List<Long> messagePkList = new ArrayList<>();
		JSONArray jsonArray = getMessageList(headers, 7001);
		if(null != jsonArray && jsonArray.size() > 0){
			for (int i = 0; i < jsonArray.size(); i++) {
				JSONObject jsonObject = jsonArray.getJSONObject(i);
				messagePkList.add(jsonObject.getLong("id"));
				Object result = jsonObject.get("result");
				if (null != result) {
					List<Long> mroProjPkList = (List<Long>) result;
					syncMroProjectBatch(headers, mroProjPkList);
				}
			}
		}

		deleteMessageList(headers, messagePkList);

		return CommonResponse.success("保存MRO项目成功！");
	}



	private void syncMroProjectBatch(Map<String, String> headers, List<Long> mroProjPkList){
		String initContextUrl = addr + "/iec/v1/project/details";
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("ids", mroProjPkList);
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers, 10000, 10000);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("resultCode") && true == json.getBoolean("success")){
				JSONArray jsonArray =  json.getJSONArray("data");
				if(null != jsonArray && jsonArray.size() > 0){
					List<MroProjectEntity> entityList = new ArrayList<>();
					List<String> sourceDeleteList = new ArrayList<>();
					for (int i = 0; i < jsonArray.size(); i++) {
						JSONObject js = jsonArray.getJSONObject(i);
						SyncMroProjectVO syncMroProjectVO = new SyncMroProjectVO();
						syncMroProjectVO.setSourceId(js.getString("id"));
						syncMroProjectVO.setSysStatus(js.getInteger("sysStatus"));
						syncMroProjectVO.setName(js.getString("name"));
						syncMroProjectVO.setOrganizationName(js.getString("organizationName"));
						if (-128 == syncMroProjectVO.getSysStatus()) {
							sourceDeleteList.add(syncMroProjectVO.getSourceId());
						}else if(1 == syncMroProjectVO.getSysStatus()){
							LambdaQueryWrapper<MroProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
							queryWrapper.eq(MroProjectEntity::getSourceId, syncMroProjectVO.getSourceId());
							MroProjectEntity dbMroProjectEntity = mroProjectService.getOne(queryWrapper, false);
							if (null == dbMroProjectEntity) {
								dbMroProjectEntity = new MroProjectEntity();
								dbMroProjectEntity.setSourceId(syncMroProjectVO.getSourceId());
								dbMroProjectEntity.setName(syncMroProjectVO.getName());
								dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
								dbMroProjectEntity.setId(IdWorker.getId());
							}else{
								dbMroProjectEntity.setName(syncMroProjectVO.getName());
								dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
							}
							entityList.add(dbMroProjectEntity);
						}
					}
					//必须单条保存.......
					mroProjectService.saveOrUpdateBatch(entityList);

					if (CollectionUtils.isNotEmpty(sourceDeleteList)) {
						LambdaQueryWrapper<MroProjectEntity> deleteWrapper = new LambdaQueryWrapper<>();
						deleteWrapper.in(MroProjectEntity::getSourceId, sourceDeleteList);
						mroProjectService.remove(deleteWrapper);

						LambdaQueryWrapper<ProjectConfigureEntity> deleteWrapper1 = new LambdaQueryWrapper<>();
						deleteWrapper1.in(ProjectConfigureEntity::getMroProjectSourceId, sourceDeleteList);
						projectConfigureService.remove(deleteWrapper1);
					}
					logger.info("保存MRO项目开始--------》》》"+ entityList.size());
				}
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+e.getMessage());
		}
	}

	/**
	 * 消息拉取
	 * @param headers
	 * @param type int64 消息类型
	 * @return
	 */
	private JSONArray getMessageList(Map<String, String> headers, Integer type){
		String initContextUrl = addr + "/iec/v1/message/list";
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("type", type);
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers, 10000, 10000);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("resultCode") && true == json.getBoolean("success")){
				return json.getJSONArray("data");
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+e.getMessage());
		}
		return  null;
	}

	/**
	 * 消息删除
	 * @param headers
	 * @param messagePkList   int64 待删除消息id集合
	 */
	private void deleteMessageList(Map<String, String> headers, List<Long> messagePkList){
		String initContextUrl = addr + "/iec/v1/message/delete";
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("ids", messagePkList);
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers, 10000, 10000);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("code") && true == json.getBoolean("success")){
				logger.info("消息删除成功");
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+e.getMessage());
		}
	}

	/**
	 * 获取access_token服务
	 *
	 * @param headers
	 * @throws GeneralSecurityException
	 * @throws IOException
	 */
	public CommonResponse<String> getAccessToken(Map<String, String> headers) {
		logger.info("------------  开始获取token  ------------");
		if(redisTemplate.opsForValue().get("mro-Open-Token") != null){
			logger.info("------------  redisTemplate里有token  ------------"+ redisTemplate.opsForValue().get("mro-Open-Token"));
			headers.put("x_open_token", redisTemplate.opsForValue().get("mro-Open-Token").toString());
		}else{
			String initContextUrl = addr + "/iec/v1/auth/accessToken";
			JSONObject jsonObject = new JSONObject();
			//TODO
			jsonObject.put("grantType", "accessToken");
			jsonObject.put("clientId", "accessToken");
			jsonObject.put("clientSecret", "accessToken");
			jsonObject.put("username", "accessToken");
			jsonObject.put("password", "accessToken");
			try {
				String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers, 10000, 10000);
				JSONObject json = JSONObject.parseObject(responseStr);
				if(200 == json.getInteger("resultCode") && true == json.getBoolean("success")){
					JSONObject data = json.getJSONObject("result");
					String access_token = data.getString("accessToken");
					headers.put("x_open_token", access_token);
					redisTemplate.opsForValue().set("mro-Open-Token", access_token,data.getInteger("expiresIn"), TimeUnit.SECONDS);
					logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
				}else{
					return CommonResponse.error("系统推送供方时，获取供方access_token异常");
				}
			} catch (Exception e) {
				logger.info("IOException 异常"+e.getMessage());
				return CommonResponse.error("系统推送供方时，获取供方access_token异常");
			}
		}
		return CommonResponse.success();
	}
}
