/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ControlPlanDetailEntity;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.bean.MroProjectEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.service.IControlPlanDetailService;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.service.IMroProjectService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.vo.ControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.ControlPlanVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zjwjsync/"})
public class ZjwjSyncApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IControlPlanDetailService controlPlanDetailService;
    @Autowired
    private IMroProjectService mroProjectService;
    @Autowired
    private IProjectConfigureService projectConfigureService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @PostMapping(value={"syncControlPlanList"})
    public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
        ArrayList<ControlPlanEntity> entityList = new ArrayList<ControlPlanEntity>();
        for (SyncControlPlanVO syncVO : controlPlanVOS) {
            UserVO userVO;
            CommonResponse userVOCommonResponse;
            CommonResponse orgVOCommonResponse;
            ControlPlanVO vo = syncVO.getValue();
            ControlPlanEntity entity = (ControlPlanEntity)((Object)BeanMapper.map((Object)vo, ControlPlanEntity.class));
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
            if (null == dbEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbEntity.getId());
            }
            if (entity.getParentOrgSourceId() != null && (orgVOCommonResponse = this.orgApi.findBySourceId(entity.getParentOrgSourceId())).isSuccess()) {
                OrgVO orgVO = (OrgVO)orgVOCommonResponse.getData();
                entity.setParentOrgId(orgVO.getId());
            }
            if (entity.getProjectSourceId() != null) {
                CommonResponse orgVOCommonResponse2;
                CommonResponse registerVOCommonResponse = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId());
                if (registerVOCommonResponse.isSuccess()) {
                    ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)registerVOCommonResponse.getData();
                    entity.setProjectId(projectRegisterVO.getId());
                    entity.setProjectName(projectRegisterVO.getName());
                }
                if ((orgVOCommonResponse2 = this.orgApi.findBySourceId(entity.getProjectSourceId())).isSuccess()) {
                    OrgVO orgVO = (OrgVO)orgVOCommonResponse2.getData();
                    entity.setOrgId(orgVO.getId());
                    entity.setOrgSourceId(orgVO.getSourceId());
                    entity.setOrgName(orgVO.getName());
                }
            }
            if (syncVO.getSourceEmployeeId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceEmployeeId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setEmployeeId(userVO.getId());
                entity.setEmployeeName(userVO.getUserName());
            }
            if (syncVO.getSourceCreatorId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceCreatorId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setCreateUserCode(userVO.getUserCode());
            }
            entityList.add(entity);
        }
        this.controlPlanService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncControlPlanDetailList"})
    public CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
        ArrayList<ControlPlanDetailEntity> entityList = new ArrayList<ControlPlanDetailEntity>();
        for (SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
            CommonResponse materialVOCommonResponse;
            ControlPlanDetailVO vo = syncVO.getValue();
            ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)BeanMapper.map((Object)vo, ControlPlanDetailEntity.class));
            LambdaQueryWrapper queryDetailWrapper = new LambdaQueryWrapper();
            queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanDetailEntity dbDetaliEntity = (ControlPlanDetailEntity)((Object)this.controlPlanDetailService.getOne((Wrapper)queryDetailWrapper, false));
            if (null == dbDetaliEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbDetaliEntity.getId());
            }
            if (syncVO.getSourceControlId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)syncVO.getSourceControlId());
                ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
                entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
            }
            if (vo.getMaterialSourceId() != null && (materialVOCommonResponse = this.materialApi.queryMaterialBySourceId(vo.getMaterialSourceId())).isSuccess()) {
                MaterialVO materialVO = (MaterialVO)materialVOCommonResponse.getData();
                entity.setMaterialId(materialVO.getId());
                entity.setMaterialCode(materialVO.getCode());
                entity.setMaterialName(materialVO.getName());
                entity.setUnit(materialVO.getUnitName());
                entity.setSpec(materialVO.getSpec());
                entity.setDef1(materialVO.getDef1());
                entity.setDef2(materialVO.getDef2());
                entity.setDef3(materialVO.getDef3());
                entity.setMaterialTypeId(materialVO.getCategoryId());
                CommonResponse materialCategoryVOCommonResponse = this.materialApi.queryCategoryById(materialVO.getCategoryId());
                if (materialCategoryVOCommonResponse.isSuccess()) {
                    MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)materialCategoryVOCommonResponse.getData();
                    entity.setMaterialTypeName(materialCategoryVO.getName());
                    entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
                }
            }
            entityList.add(entity);
        }
        this.controlPlanDetailService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u6210\u529f\uff01");
    }

    @GetMapping(value={"syncMroProjectList"})
    public CommonResponse<String> syncMroProjectList() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x_open_appkey", "x_open_appkey");
        headers.put("x_open_nonce", "x_open_appkey");
        headers.put("x_open_timestamp", "x_open_appkey");
        headers.put("x_open_sg", "x_open_appkey");
        CommonResponse<String> stringCommonResponse = this.getAccessToken(headers);
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info((String)stringCommonResponse.getData());
        }
        ArrayList<Long> messagePkList = new ArrayList<Long>();
        JSONArray jsonArray = this.getMessageList(headers, 7001);
        if (null != jsonArray && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                messagePkList.add(jsonObject.getLong("id"));
                Object result = jsonObject.get((Object)"result");
                if (null == result) continue;
                List mroProjPkList = (List)result;
                this.syncMroProjectBatch(headers, mroProjPkList);
            }
        }
        this.deleteMessageList(headers, messagePkList);
        return CommonResponse.success((String)"\u4fdd\u5b58MRO\u9879\u76ee\u6210\u529f\uff01");
    }

    private void syncMroProjectBatch(Map<String, String> headers, List<Long> mroProjPkList) {
        String initContextUrl = this.addr + "/iec/v1/project/details";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ids", mroProjPkList);
        try {
            String responseStr = HttpTookit.postByJson((String)initContextUrl, (String)jsonObject.toJSONString(), headers, (Integer)10000, (Integer)10000);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("resultCode") && json.getBoolean("success").booleanValue()) {
                JSONArray jsonArray = json.getJSONArray("data");
                if (null != jsonArray && jsonArray.size() > 0) {
                    ArrayList<MroProjectEntity> entityList = new ArrayList<MroProjectEntity>();
                    ArrayList<String> sourceDeleteList = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject js = jsonArray.getJSONObject(i);
                        SyncMroProjectVO syncMroProjectVO = new SyncMroProjectVO();
                        syncMroProjectVO.setSourceId(js.getString("id"));
                        syncMroProjectVO.setSysStatus(js.getInteger("sysStatus"));
                        syncMroProjectVO.setName(js.getString("name"));
                        syncMroProjectVO.setOrganizationName(js.getString("organizationName"));
                        if (-128 == syncMroProjectVO.getSysStatus()) {
                            sourceDeleteList.add(syncMroProjectVO.getSourceId());
                            continue;
                        }
                        if (1 != syncMroProjectVO.getSysStatus()) continue;
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(MroProjectEntity::getSourceId, (Object)syncMroProjectVO.getSourceId());
                        MroProjectEntity dbMroProjectEntity = (MroProjectEntity)((Object)this.mroProjectService.getOne((Wrapper)queryWrapper, false));
                        if (null == dbMroProjectEntity) {
                            dbMroProjectEntity = new MroProjectEntity();
                            dbMroProjectEntity.setSourceId(syncMroProjectVO.getSourceId());
                            dbMroProjectEntity.setName(syncMroProjectVO.getName());
                            dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
                            dbMroProjectEntity.setId(IdWorker.getId());
                        } else {
                            dbMroProjectEntity.setName(syncMroProjectVO.getName());
                            dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
                        }
                        entityList.add(dbMroProjectEntity);
                    }
                    this.mroProjectService.saveOrUpdateBatch(entityList);
                    if (CollectionUtils.isNotEmpty(sourceDeleteList)) {
                        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
                        deleteWrapper.in(MroProjectEntity::getSourceId, sourceDeleteList);
                        this.mroProjectService.remove((Wrapper)deleteWrapper);
                        LambdaQueryWrapper deleteWrapper1 = new LambdaQueryWrapper();
                        deleteWrapper1.in(ProjectConfigureEntity::getMroProjectSourceId, sourceDeleteList);
                        this.projectConfigureService.remove((Wrapper)deleteWrapper1);
                    }
                    this.logger.info("\u4fdd\u5b58MRO\u9879\u76ee\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
                }
            } else {
                this.logger.info(json.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
    }

    private JSONArray getMessageList(Map<String, String> headers, Integer type) {
        String initContextUrl = this.addr + "/iec/v1/message/list";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        try {
            String responseStr = HttpTookit.postByJson((String)initContextUrl, (String)jsonObject.toJSONString(), headers, (Integer)10000, (Integer)10000);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("resultCode") && json.getBoolean("success").booleanValue()) {
                return json.getJSONArray("data");
            }
            this.logger.info(json.toJSONString());
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
        return null;
    }

    private void deleteMessageList(Map<String, String> headers, List<Long> messagePkList) {
        String initContextUrl = this.addr + "/iec/v1/message/delete";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ids", messagePkList);
        try {
            String responseStr = HttpTookit.postByJson((String)initContextUrl, (String)jsonObject.toJSONString(), headers, (Integer)10000, (Integer)10000);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                this.logger.info("\u6d88\u606f\u5220\u9664\u6210\u529f");
            } else {
                this.logger.info(json.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
    }

    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"mro-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"mro-Open-Token"));
            headers.put("x_open_token", this.redisTemplate.opsForValue().get((Object)"mro-Open-Token").toString());
        } else {
            String initContextUrl = this.addr + "/iec/v1/auth/accessToken";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("grantType", (Object)"accessToken");
            jsonObject.put("clientId", (Object)"accessToken");
            jsonObject.put("clientSecret", (Object)"accessToken");
            jsonObject.put("username", (Object)"accessToken");
            jsonObject.put("password", (Object)"accessToken");
            try {
                String responseStr = HttpTookit.postByJson((String)initContextUrl, (String)jsonObject.toJSONString(), headers, (Integer)10000, (Integer)10000);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("resultCode") || !json.getBoolean("success").booleanValue()) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("result");
                String access_token = data.getString("accessToken");
                headers.put("x_open_token", access_token);
                this.redisTemplate.opsForValue().set((Object)"mro-Open-Token", (Object)access_token, (long)data.getInteger("expiresIn").intValue(), TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (Exception e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }
}

