package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 使用计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plan")
public class PlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${mro.addr}")
    private String addr;

    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return planService.saveOrUpdate(planVO);

    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
    	PlanEntity entity = planService.selectById(id);
    	PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryDetail 根据项目主键和当前登录人获取当前登录人最近一次创建的计划信息
     * @param
     */
    @RequestMapping(value = "/queryLatelyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryLinkDetail(Long projectId) {
        List<PlanEntity> details = null;
        LambdaQueryWrapper<PlanEntity> lambda = Wrappers.<PlanEntity>lambdaQuery();
        lambda.eq(PlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(PlanEntity::getCreateUserCode,InvocationInfoProxy.getUsercode());
        lambda.eq(PlanEntity::getProjectId,projectId);
        lambda.orderByDesc(PlanEntity::getCreateTime);
        details = planService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0),PlanVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }
    /**
     * @Description queryDetail 开启/关闭计划
     * @param id
     */
    @RequestMapping(value = "/updatePlanStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> updatePlanStatus(Long id,String planFlag) {
        //审批通过且计划余量为0的单据不支持关闭(1:是，0：否)
        if (planFlag.equals("0")){
            //查询计划详情余量是否为零
            //回写订单的发货单
            LambdaQueryWrapper<PlanDetailEntity> queryWrapperDetail = Wrappers.<PlanDetailEntity>lambdaQuery();
            queryWrapperDetail.eq(PlanDetailEntity::getPlanId, id);
            List<PlanDetailEntity> deliveryDetailList = planDetailService.list(queryWrapperDetail);
            Boolean isZero = true;
            for (PlanDetailEntity planDetailEntity : deliveryDetailList){
                if (planDetailEntity.getSurplusNums().compareTo(BigDecimal.ZERO) == 1){
                    isZero = false;
                }
            }
            if (!isZero){
                //修改计划状态
                LambdaUpdateWrapper<PlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(PlanEntity::getId, id);
                updateWrapper.set(PlanEntity::getPlanFlag, planFlag);
                boolean flag = planService.update(updateWrapper);
                if (!flag){
                    throw new BusinessException("更新计划状态失败！");
                }
            }
            if (isZero){
                throw new BusinessException("计划余量为零,不支持关闭！");
            }
        }
        //修改计划状态
        LambdaUpdateWrapper<PlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PlanEntity::getId, id);
        updateWrapper.set(PlanEntity::getPlanFlag, planFlag);
        boolean flag = planService.update(updateWrapper);
        if (!flag){
            throw new BusinessException("更新计划状态失败！");
        }
    	PlanEntity entity = planService.selectById(id);
        updateMroPlanState(entity);
    	PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 回写MRO
     * @param planEntity
     */
    private void updateMroPlanState(PlanEntity planEntity){
        if(MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()){
            Map<String, String> headers = new HashMap<>();
            CommonResponse<String> stringCommonResponse = thirdSystemUtils.getMroAccessToken(headers);
            if(!stringCommonResponse.isSuccess()){
                logger.info(stringCommonResponse.getData());
                throw new BusinessException("获取MRO的token失败");
            }
            if(StringUtils.isBlank(planEntity.getHistoryId())){
                throw new BusinessException("该计划MRO主键为空");
            }
            String mroUrl = addr + "/iec/v1/purchase_plan/update/status";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", planEntity.getHistoryId());
            jsonObject.put("targetStatus", "0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON");
            try {
                String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
                JSONObject json = JSONObject.parseObject(responseStr);
                if(200 == json.getInteger("code") && true == json.getBoolean("success")){
                    logger.info("更新MRO计划状态成功");
                }else{
                    logger.info(json.toJSONString());
                }
            } catch (Exception e) {
                logger.info("异常"+ e.getMessage());
            }
        }
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        planService.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("construction");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }

        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
        IPage<PlanEntity> page = planService.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
        IPage<PlanEntity> pageData= planService.queryPage(param,false);
        List<PlanVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), PlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getPlanFlag().equals("0")){
                    vo.setPlanFlagName("已关闭");
                }else {
                    vo.setPlanFlagName("正常");
                }
                if (vo.getMaterialType().equals("0")){
                    vo.setMaterialTypeName("消耗材采购计划");
                }else {
                    vo.setMaterialTypeName("周转材租赁计划");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("planExport.xlsx", beans, response);
    }
    /**
     * 计划参照-列表二级树
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/planRef")
    @ResponseBody
    public CommonResponse<JSONObject> planRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                          @RequestParam(defaultValue = "10") Integer pageSize,
                                                          @RequestParam(value = "condition", required = false) String condition,
                                                          @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("planFlag", new Parameter("eq", true));
        Long projectId = null;
        Integer materialType = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if(null != conditionMap.get("materialType")) {
                materialType = Integer.valueOf(conditionMap.get("materialType").toString());
                queryParam.getParams().put("materialType", new Parameter(QueryParam.EQ, materialType));
            }
        }
        Page<PlanDetailVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        PlanVO planVO = new PlanVO();
        planVO.setTenantId(InvocationInfoProxy.getTenantid());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<PlanDetailVO> list = planDetailService.geMaterialDetail(page,wrapper);
        List<Long> materialListId = new ArrayList<>();
        for (PlanDetailVO planDetailVO : list){
            planDetailVO.setParentId(999L);
            planDetailVO.setTid(planDetailVO.getMaterialId());
            materialListId.add(planDetailVO.getMaterialId());
        }
        QueryParam queryDetailParam = new QueryParam();
        queryDetailParam.getParams().put("materialId", new Parameter(QueryParam.IN, materialListId));
        List<PlanDetailRefVO> planVOList = planService.getPlanByMaterialId(materialListId,wrapper);
        //遍历集合,添加children, 计划明细
        for(PlanDetailVO planDetailVO : list){
            ArrayList<PlanDetailRefVO> planDetail = new ArrayList<>();
            for(PlanDetailRefVO planVOChild : planVOList){
                if (planDetailVO.getMaterialId().equals(planVOChild.getMaterialId())){
                    planVOChild.setParentId(planDetailVO.getMaterialId());
                    planVOChild.setOrderNumsSum(planVOChild.getSurplusNumsSum());
                    planVOChild.setRowState("add");
                    planVOChild.setSmartStatus("3");
                    planVOChild.setOriginSmartStatus("3");
                    planVOChild.setSourceName(planVOChild.getPlanBillCode()+planVOChild.getPlanEmployeeName());
                    planDetail.add(planVOChild);
                }
            }
            planDetailVO.setPlanDetail(planDetail);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
}
