package com.ejianc.business.wzxt.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
public class ThirdSystemUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${mro.addr}")
    private String addr;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getMroAccessToken(Map<String, String> headers) {
        logger.info("------------  开始获取token  ------------");
        if(redisTemplate.opsForValue().get("mro-Open-Token") != null){
            logger.info("------------  redisTemplate里有token  ------------"+ redisTemplate.opsForValue().get("mro-Open-Token"));
            headers.put("x_open_token", redisTemplate.opsForValue().get("mro-Open-Token").toString());
        }else{
            String initContextUrl = addr + "/iec/v1/auth/accessToken";
            JSONObject jsonObject = new JSONObject();
            //TODO
            jsonObject.put("grantType", "accessToken");
            jsonObject.put("clientId", "accessToken");
            jsonObject.put("clientSecret", "accessToken");
            jsonObject.put("username", "accessToken");
            jsonObject.put("password", "accessToken");
            try {
                String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers, 10000, 10000);
                JSONObject json = JSONObject.parseObject(responseStr);
                if(200 == json.getInteger("resultCode") && true == json.getBoolean("success")){
                    JSONObject data = json.getJSONObject("result");
                    String access_token = data.getString("accessToken");
                    headers.put("x_open_token", access_token);
                    redisTemplate.opsForValue().set("mro-Open-Token", access_token,data.getInteger("expiresIn"), TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                }else{
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (Exception e) {
                logger.info("IOException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }

        //TODO
        headers.put("x_open_appkey", "x_open_appkey");
        headers.put("x_open_nonce", "x_open_appkey");
        headers.put("x_open_timestamp", "x_open_appkey");
        headers.put("x_open_sg", "x_open_appkey");

        return CommonResponse.success();
    }
}
