package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 验收实体
 *
 * @author generator
 *
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private static final String WZXT_CHECK = "CSCEC5B_CWZXT_CHECK";

    @Value("${smartWeigh.addr}")
    private String SUPPLIER_HTTP;//五局服务域名

    @Value("${common.env.base-host}")
    private String BASE_HOST;//运行环境域名

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IWeighReportService weighReportService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveorUpdateVO, CheckEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getParentOrgId() != null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(entity.getParentOrgId());
            if(!orgParentVo.isSuccess()) {
                throw new BusinessException("查询组织详情失败！");
            }
            entity.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        }
        // 新增
        if(entity.getId() == null){
            entity.setUseState(0);// 未引用
            entity.setCheckState(1);// 已验收
            //  创建人信息
            if(entity.getCreateUserId() == null){
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setCreateUserName(sessionManager.getUserContext().getUserName());
                entity.setCreateUserSourceId(this.getUserSourceId());// 用户来源ID
            }
        }
        // 子表处理
        List<CheckDetailVO> detailList = saveorUpdateVO.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            StringBuffer materialName = new StringBuffer();
            BigDecimal sumMny = null;// 无税价格合计
            BigDecimal sumTax = null;// 税金合计
            BigDecimal sumTaxMny = null;// 价税合计
            for(CheckDetailVO detail : detailList){
                materialName.append(detail.getMaterialName()+",");
                sumMny = safeAdd(sumMny, detail.getMny());
                sumTax = safeAdd(sumTax, detail.getTax());
                sumTaxMny = safeAdd(sumTaxMny, detail.getTaxmny());
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
            entity.setDef1(sumMny != null ? sumMny.setScale(2, BigDecimal.ROUND_HALF_EVEN).toPlainString() : null);
            entity.setDef2(sumTax != null ? sumTax.setScale(2, BigDecimal.ROUND_HALF_EVEN).toPlainString() : null);
            entity.setDef3(sumTaxMny != null ? sumTaxMny.setScale(2, BigDecimal.ROUND_HALF_EVEN).toPlainString() : null);
        }
        super.saveOrUpdate(entity, false);

        // 回写发货单验收状态及明细验收数量
        this.writeBackDelivery(saveorUpdateVO, true);
        // 回写订单验收状态及明细验收数量
        this.writeBackOrder(saveorUpdateVO, true);
        // 保存验收单主键与磅单主键关系（磅单确认状态-暂存）
        this.writeBackPoundTemp(entity.getId(), saveorUpdateVO.getPkWeighBills());
        // 更新智能称重台账 验收单主键与磅单主键关系（确认状态-暂存）
        this.writeBackWeighReportCheck(entity.getId(), entity.getBillCode(), saveorUpdateVO.getPkWeighBills());
        if(saveorUpdateVO.getSaveState() == 1){
            // 更新磅单确认状态-已确认
//            this.writeBackPound(entity.getId());
            // 更新智能称重台账确认状态-已确认
            this.writeBackWeighReport(entity.getId());
        }

        return BeanMapper.map(entity, CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return baseMapper.querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        vo.setProjectId(delivery.getProjectId());// 项目主键
        vo.setProjectSourceId(delivery.getProjectSourceId());// 项目来源id
        vo.setProjectName(delivery.getProjectName());// 项目名称
        vo.setOrgId(delivery.getOrgId());// 组织主键
        vo.setOrgName(delivery.getOrgName());// 组织名称
        vo.setContractId(delivery.getContractId());// 合同主键
        vo.setContractName(delivery.getContractName());// 合同名称
        vo.setSupplierId(delivery.getSupplierId());// 供方主键
        vo.setSupplierName(delivery.getSupplierName());// 供方名称
        vo.setSupplierTenantId(delivery.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(delivery.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(delivery.getMaterialName());// 物资名称
        vo.setOrderId(delivery.getOrderId());// 订单主键
        vo.setDeliveryId(deliveryId);// 发货单主键
        vo.setMaterialType(delivery.getMaterialType());//
        // 五局新增字段
        vo.setOrgSourceId(delivery.getOrgSourceId());// 组织来源ID
        vo.setParentOrgId(delivery.getParentOrgId());// 上级组织主键
        vo.setParentOrgSourceId(delivery.getParentOrgSourceId());// 上级组织主键来源ID
        vo.setSupplierSourceId(delivery.getSupplierSourceId());// 供应商来源ID
        vo.setConstruction(delivery.getConstruction());// 使用单位及部位
        vo.setSmartStatus(delivery.getSmartStatus());// 智能称重，0-否，1-是
        // 发货单明细生成验收单明细
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(
                new LambdaQueryWrapper<DeliveryDetailEntity>().eq(DeliveryDetailEntity::getDeliveryId, delivery.getId()));
        if(CollectionUtils.isNotEmpty(deliveryDetailList)){
            List<CheckDetailVO> detailList = new ArrayList<>();
            deliveryDetailList.forEach(dd ->{
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);// 发货单主键
                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getOrderDetailId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量
                // 五局新增字段
                detail.setMaterialSourceId(dd.getMaterialSourceId());// 物资来源ID

                //mro add
                if(MaterialTypeEnum.MRO.getCode() == delivery.getMaterialType()){
                    detail.setMroTaxrate(dd.getMroTaxrate());
                    detail.setMroDeliverNumsSum(dd.getMroDeliverNumsSum());
                    detail.setMroMny(dd.getMroMny());
                    detail.setMroNprice(dd.getMroNprice());
                    detail.setMroNtaxprice(dd.getMroNtaxprice());
                    detail.setMroSupplierSkuCode(dd.getMroSupplierSkuCode());
                    detail.setMroSupplierSkuId(dd.getMroSupplierSkuId());
                    detail.setMroTaxmny(dd.getMroTaxmny());
                    detail.setMroTax(dd.getMroTax());
                    detail.setMroUnit(dd.getMroUnit());
                    detail.setMroUnitRatio(dd.getMroUnitRatio());

                    detail.setMny(detail.getMroMny());
                    detail.setTaxmny(detail.getMroTaxmny());
                    detail.setCheckNumsSum(detail.getDeliverNumsSum());
                    detail.setNprice(detail.getMroMny().divide(detail.getDeliverNumsSum()));
                    detail.setNtaxprice(detail.getMroTaxmny().divide(detail.getDeliverNumsSum()));
                    detail.setTaxrate(detail.getMroTaxrate());
                    detail.setTax(detail.getMroTax());
                }

                //mro end

                detailList.add(detail);
            });
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List<CheckEntity> entityList = baseMapper.selectList(new QueryWrapper<CheckEntity>().in("id", ids));
        if(CollectionUtils.isNotEmpty(entityList)){
            entityList.forEach(entity ->{
                if(entity.getUseState() == 1){
                    throw new BusinessException("单据已被引用，不允许删除！");
                }
            });
        }
        List<CheckVO> vos = BeanMapper.mapList(entityList, CheckVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(vo ->{
                // 回写发货单验收状态及明细验收数量
                this.writeBackDelivery(vo, false);
                // 回写订单验收状态及明细验收数量
                this.writeBackOrder(vo, false);
                // 删除回写磅单验收状态
                this.writeBackPoundDel(vo.getId());
                // 删除回写智能称重台账
                this.writeBackWeighReportDel(vo.getId());
            });
        }
        return super.removeByIds(ids, true);
    }

    @Override
    public Boolean push2NC(Long id) {
        boolean drflag = this.sysdr(id);
        if(!drflag){
            throw new BusinessException("NC端已存在且未删除");
        }
        StringBuffer msg = new StringBuffer();
        // 应该为登录用户的sourceId
        String pkUser = this.getUserSourceId();// 用户来源ID;
        CheckEntity check = baseMapper.selectById(id);
        if(StringUtils.isEmpty(check.getContractId())){
            msg.append("[合同]");
        }
        if(StringUtils.isEmpty(check.getCwarehouseid())){
            msg.append("[仓库]");
        }
        if(StringUtils.isEmpty(check.getCkcorgid())){
            msg.append("[库存组织]");
        }
        if(StringUtils.isEmpty(check.getCdispatcherid())){
            msg.append("[收发类别]");
        }
        if(StringUtils.isEmpty(check.getCpurorganization())){
            msg.append("[采购组织]");
        }
        if(StringUtils.isEmpty(check.getCdptid())){
            msg.append("[采购部门]");
        }
        if(StringUtils.isNotEmpty(msg)){
            throw new BusinessException(msg + "不能为空");
        }
        List<CheckDetailEntity> checkBList = checkDetailService.list(Wrappers.<CheckDetailEntity>lambdaQuery().eq(CheckDetailEntity::getCheckId, id));
        // 构造NC实体VO
        PurchaseOrderVO checkVO = this.changToNcVO(check, checkBList, pkUser);
        logger.info("--->> 推送NC构造实体VO: " + JSON.toJSONString(checkVO));
        //调接口push数据
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        try {
//            URL url = new URL("http://172.30.201.66/uapws/service/OrderService?wsdl");
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
            String resulet = http.processData(checkVO);
            if(StringUtils.isNotEmpty(resulet)){
                logger.info("--->> 推送NC返回result: " + resulet);
                Map valueMap = JSON.parseObject(resulet);
                String code = (String) valueMap.get("code");
                if(!"WS000001".equals(code)){
                    msg.append((String) valueMap.get("msg"));
                }
            }
        } catch (Exception e) {
            throw new BusinessException( "推送NC出错");
        }
        if(StringUtils.isNotEmpty(msg)){
            throw new BusinessException("推送NC" + msg);
        }
        check.setUseState(1);
//        check.setDrstatus(0);
        // 记录推送人信息
        check.setPushUserId(InvocationInfoProxy.getUserid());
        check.setPushUserName(sessionManager.getUserContext().getUserName());
        check.setPushUserSourceId(this.getUserSourceId());// 用户来源ID
        baseMapper.updateById(check);
        return true;
    }

    @Override
    public Boolean sysdr(Long id) {
        boolean flag = true;
        Integer dr = 1;
        List<String> arrList = new ArrayList<>();
        arrList.add(String.valueOf(id));
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        StringBuffer msg = new StringBuffer();
        try {
//            URL url = new URL("http://172.30.201.66/uapws/service/OrderService?wsdl");
//            logger.info("getIPurchaseOrderServiceSOAP11PortHttp begin");
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
//            logger.info("getIPurchaseOrderServiceSOAP11PortHttp end");
            String json = http.getBillsStatus(arrList);
            if(StringUtils.isNotEmpty(json)){
                logger.info("--->> NC同步dr返回result: " + json);
                Map valueMap = JSON.parseObject(json);
                String code = (String) valueMap.get("code");
                if(!"WS000001".equals(code)){
                    msg.append((String) valueMap.get("msg"));
                }else{
                    JSONArray jsarr = (JSONArray) valueMap.get("data");
                    if(jsarr != null && jsarr.size() > 0){
                        Map map = (JSONObject) jsarr.get(0);
                        dr = map.get("dr") != null ? Integer.parseInt((String)map.get("dr")) : dr;
                        if(dr != 1){
                            flag = false;
                        }
                    }
                }
            }else{
                msg.append("结果为空");
            }
        } catch (Exception e) {
            throw new BusinessException("同步NC删除状态出错");
        }

        if(StringUtils.isNotEmpty(msg)){
            throw new BusinessException("同步NC" + msg);
        }

        CheckEntity entity = baseMapper.selectById(id);
//        entity.setDrstatus(dr);
        // 已推送 + 已删除 = 未推送
        if(entity.getUseState() == 1 && dr == 1){
            entity.setUseState(0);
            baseMapper.updateById(entity);
        }
        return flag;
    }

    @Override
    public Boolean updatenums(List<Long> ids) {
        List<CheckEntity> checks = new ArrayList<>();
        if (!ids.isEmpty()) {
            checks = baseMapper.selectBatchIds(ids);
            if (checks.size() > 0 && checks.size() == ids.size()) {// 检验前台传数据与后台查询数据条数是否一致
                for (CheckEntity check : checks) {
                    check.setPrintNum(check.getPrintNum() == null || check.getPrintNum() == 0  ? 1 : check.getPrintNum() + 1);
                }
            } else {
                throw new BusinessException( "数据可能被更改,请刷新界面后再操作");
            }
        }
        boolean res = super.saveOrUpdateBatch(checks);
        if (!res) {
            throw new BusinessException( "数据可能被更改,请刷新界面后再操作");
        }
        return res;
    }

    /**
     * 回写发货单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        // 回写验收状态
        if(checkVO.getDeliveryId() != null){
            DeliveryEntity delivery = deliveryService.getById(checkVO.getDeliveryId());
            // 新增
            if(null == checkVO.getId()){
                delivery.setDeliverState(2);
                // 回写供方发货单已验收
                this.writeBackCheckToSupplier(checkVO.getDeliveryId(), true);
            }
            // 删除
            if(!flag){
                LambdaQueryWrapper<CheckEntity> lambda = Wrappers.<CheckEntity>lambdaQuery();
                lambda.in(CheckEntity::getDeliveryId, checkVO.getDeliveryId());
                lambda.ne(CheckEntity::getId, checkVO.getId());
                List<CheckEntity> entityList = baseMapper.selectList(lambda);
                // 还有其他验收单时不回写未验收
                if(entityList.size() == 0 ){
                    delivery.setDeliverState(1);
                    // 回写供方发货单未验收
                    this.writeBackCheckToSupplier(checkVO.getDeliveryId(), false);
                }
                // 如果发货单已关闭需开启
                if("1".equals(delivery.getCloseStatus())) {
                    delivery.setCloseStatus("0");
                    // 回写供方发货单开启
                    this.writeBackOpenDelivery(checkVO.getDeliveryId(), false);
                }
            }
            deliveryService.updateById(delivery);
        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<DeliveryDetailEntity> ddEditList = new ArrayList<>();// 发货单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag || "del".equals(vo.getRowState())){
                        // 新增或删除
                        DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                        BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                        ddCheckNums = flag ? "del".equals(vo.getRowState()) ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(ddEditList)){
                deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    /**
     * 回写订单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        // 回写验收状态（暂不回写）
//        if(checkVO.getOrderId() != null){
//            if(null == checkVO.getId() || !flag){
//                OrderEntity order = orderService.getById(checkVO.getOrderId());
//                order.setDeliverState(flag ? 2 : 1);
//                orderService.updateById(order);
//            }
//        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<OrderDetailEntity> odEditList = new ArrayList<>();// 订单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getOrderDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag || "del".equals(vo.getRowState())){
                        // 新增或删除
                        OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                        BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                        odCheckNums = flag ? "del".equals(vo.getRowState())? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums) : odCheckNums.subtract(checkNums);//例子  200 + 80
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(odEditList)){
                orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    /**
     * 构造NC实体VO
     * @param check
     * @param checkBList
     * @param pkUser
     * @return
     */
    private PurchaseOrderVO changToNcVO(CheckEntity check, List<CheckDetailEntity> checkBList, String pkUser) {
        PurchaseOrderVO checkVO = new PurchaseOrderVO();
        PurchaseOrderHeadVO checkHVO = this.changeToNcHVO(check, pkUser);// 构造主表VO
        List<PurchaseOrderBodyVO> checkBVOList = this.changeToNcBVO(check, checkBList);// 构造子表VO
        checkVO.setPurchaseOrderHeadVO(checkHVO);
        checkVO.setPurchaseOrderBodyVO(checkBVOList.toArray(new PurchaseOrderBodyVO[0]));
        return checkVO;
    }

    /**
     * 构造主表VO
     * @param check
     * @param pkUser
     * @return
     */
    private PurchaseOrderHeadVO changeToNcHVO(CheckEntity check, String pkUser){
        PurchaseOrderHeadVO checkVO = new PurchaseOrderHeadVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        checkVO.setPk_corp(check.getParentOrgSourceId());
        checkVO.setNversion(1);
        checkVO.setDbilldate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
        checkVO.setCbiztype("0001N510000000036VJ3");
        checkVO.setPk_project(check.getProjectSourceId());
        checkVO.setCwarehouseid(check.getCwarehouseid());
        checkVO.setCpurorganization(check.getCkcorgid());
        checkVO.setCvendormangid(check.getSupplierSourceId());
        checkVO.setCdispatcherid(check.getCdispatcherid());
        checkVO.setCpurorganization2(check.getCpurorganization());
        checkVO.setCdptid(check.getCdptid());//采购部门
        checkVO.setVmemo(check.getBillCode());
        checkVO.setVbeizhu(check.getConstruction());
        checkVO.setNtaxrate(BigDecimal.valueOf(0));//税率
        checkVO.setPk_defdoc5(sdf.format(new Date()));//入库日期
        checkVO.setFrom_source("qlhpt_00000001");//数据来源
        checkVO.setWebsite(this.getWebSite(check.getId()));//网络站点
//        checkVO.setWebsite("http://wei.cscec5b.com.cn:9000/pca/index.html#/pca/acptBook/detail2?pkCheck=" + check.getId());//网络站点
        checkVO.setTmaketime(sdf.format(new Date()));
        checkVO.setCoperator(pkUser);
        checkVO.setDauditdate(sdf.format(new Date()));
        checkVO.setCauditpsn(pkUser);
        checkVO.setPk_transfer(String.valueOf(check.getId()));
        checkVO.setCwhsmanagerid(check.getCreateUserSourceId());
        return checkVO;
    }

    /**
     * 生成验收单跳转地址
     * @param id
     * @return
     */
    private String getWebSite(Long id) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = BASE_HOST + "cscec5b-wzxt-frontend/#/check/card?id=" + id;// 目标路径
        logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl,"utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String webSite = BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        logger.info("--->> 生成验收单跳转地址: " + webSite);
        return webSite;
    }

    /**
     * 构造子表VO
     * @param check
     * @param checkBList
     * @return
     */
    private List<PurchaseOrderBodyVO> changeToNcBVO(CheckEntity check, List<CheckDetailEntity> checkBList){
        List<PurchaseOrderBodyVO> checkBVOList = new ArrayList<>();
        if(checkBList != null && checkBList.size() > 0){
            for(CheckDetailEntity checkB : checkBList){
                PurchaseOrderBodyVO checkBVO = new PurchaseOrderBodyVO();
                checkBVO.setPk_contract(check.getContractId());
                checkBVO.setContract_name(check.getContractName());
                checkBVO.setPk_cinventory(checkB.getMaterialSourceId());
                checkBVO.setCinventorycode(checkB.getMaterialCode());
                checkBVO.setCinventoryname(checkB.getMaterialName());
                checkBVO.setInvspec(checkB.getDef1());// 规格
                checkBVO.setInvtype(checkB.getDef2());// 型号
                checkBVO.setPk_measddoc(checkB.getDef3());// 计量单位主键
                BigDecimal number = checkB.getCheckNumsSum() == null ? BigDecimal.ZERO : checkB.getCheckNumsSum();
                checkBVO.setNinnum(number);
                BigDecimal nprice = checkB.getNprice() == null ? BigDecimal.ZERO : checkB.getNprice();
                checkBVO.setNprice(nprice);
                BigDecimal mny = number.multiply(nprice);
                checkBVO.setNmny(mny.setScale(2, BigDecimal.ROUND_HALF_UP));
                BigDecimal taxrate = checkB.getTaxrate() == null ? BigDecimal.ZERO : checkB.getTaxrate();
                checkBVO.setNtaxrate_b(taxrate);
                BigDecimal taxmny = number.multiply(nprice).multiply(taxrate).divide(new BigDecimal(100));
                checkBVO.setTaxmny(taxmny.setScale(2, BigDecimal.ROUND_HALF_UP));
                checkBVO.setNtaxmny(mny.add(taxmny).setScale(2, BigDecimal.ROUND_HALF_UP));
                checkBVO.setDbizdate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));//入库日期
                checkBVO.setVnotebody(checkB.getMemo());
                checkBVO.setVdef20(checkB.getMaterialManufacturer());
                checkBVOList.add(checkBVO);
            }
        }
        return checkBVOList;
    }

    @Override
    public CommonResponse<Object>  poundList(String id){
        logger.info("------------  查询磅单列表  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/check/list";
        Map<String, String> params = new HashMap();
        params.put("pkCheck", String.valueOf(id));
        return doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object>  poundDetail(String pkWeighBill){
        logger.info("------------  查询磅单详情  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/detail";
        Map<String, String> params = new HashMap();
        params.put("pkWeighBill", pkWeighBill);
        return doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object>  getWeighListByPks(List<String> pkWeighBill){
        logger.info("------------  根据主键集合获取磅单信息  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/list";
        Map<String,List<String>> map = new HashMap<>();
        map.put("pkWeighs", pkWeighBill);
        JSONObject params = JSONObject.parseObject(JSON.toJSONString(map));
        String parameterStr = params.toJSONString();
        return doPostHttp(url, parameterStr);
    }

    @Override
    public CommonResponse<Object>  getWeighListByDelivery(String pkDelivery, Integer checkStatus){
        logger.info("------------  根据发货单主键获取磅单信息  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/delivery/list";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        if(checkStatus != null){
            params.put("checkStatus", String.valueOf(checkStatus));
        }
        return doGetHttp(url, params);
    }

    @Override
    public List<MaterialInRefVO> getMaterialInRef(Page<MaterialInRefVO> page, QueryWrapper wrapper, String contractId, Long tenantId) {
        List<MaterialInRefVO> list = baseMapper.getMaterialInRef(page, wrapper,contractId,tenantId);
        return list;
    }

    /**
     * 回写供方发货单是否已验收
     * @param deliveryId    发货单主键
     * @param isCheck       是否验收
     * @return
     */
    private CommonResponse<Object>  writeBackCheckToSupplier(Long deliveryId, Boolean isCheck){
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        String pkDelivery = StringUtils.isNotEmpty(delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        logger.info("------------  回写供方发货单验收状态  ------------");
        String url = SUPPLIER_HTTP + "/el/delivery/delivery/check";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        params.put("isCheck", String.valueOf(isCheck));
        return doGetHttp(url, params);
    }

    /**
     * 回写供方发货单开启/关闭
     * @param deliveryId    发货单主键
     * @param isClose       是否开启
     * @return
     */
    public CommonResponse<Object>  writeBackOpenDelivery(Long deliveryId, Boolean isClose){
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        String pkDelivery = StringUtils.isNotEmpty(delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        logger.info("------------  回写供方发货单开启  ------------");
        String url = SUPPLIER_HTTP + "/el/delivery/delivery/close";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        params.put("isClose", String.valueOf(isClose));
        return doGetHttp(url, params);
    }

    /**
     * 保存验收单主键与磅单主键关系（磅单确认状态-暂存）
     * @param id    验收单主键
     * @param pkWeighBills  磅单主键集合
     * @return
     */
    private CommonResponse<Object>  writeBackPoundTemp(Long id, List<String> pkWeighBills){
        if(CollectionUtils.isEmpty(pkWeighBills)){
            return CommonResponse.error("pkWeighBills为空！");
        }
        logger.info("------------  保存验收单主键与磅单主键关系（磅单确认状态-暂存）  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/check";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setPkWeighBills(pkWeighBills);
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr);
    }

    /**
     * 更新智能称重台账 验收单主键与磅单主键关系（确认状态-暂存）
     * @param id    验收单主键
     * @param billCode  验收单编号
     * @param pkWeighBills  磅单主键集合
     */
    private void writeBackWeighReportCheck(Long id, String billCode, List<String> pkWeighBills) {
        if(CollectionUtils.isEmpty(pkWeighBills)){
            return ;
        }
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(WeighReportEntity::getPkWeighBill, pkWeighBills);
        updateWrapper.set(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckCode, billCode);
        updateWrapper.set(WeighReportEntity::getCheckStatus, 1);
        weighReportService.update(updateWrapper);
    }

    /**
     * 更新磅单确认状态-已确认(废除)
     * @param id    验收单主键
     * @return
     */
    private CommonResponse<Object>  writeBackPound(Long id){
        logger.info("------------  更新磅单确认状态-已确认  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/updateCheckStatus";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setBillStatus(2);
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr);
    }

    /**
     * 更新智能称重台账确认状态-已确认
     * @param id    验收单主键
     */
    private void writeBackWeighReport(Long id) {
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckStatus, 2);
        weighReportService.update(updateWrapper);
    }

    /**
     * 删除回写磅单验收状态
     * @param id    验收单主键
     * @return
     */
    private CommonResponse<Object>  writeBackPoundDel(Long id){
        logger.info("------------  删除回写磅单验收状态  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/unCheck";
        Map<String, String> params = new HashMap();
        params.put("pkCheck", String.valueOf(id));
        return doGetHttp(url, params);
    }

    /**
     * 删除回写智能称重台账
     * @param id    验收单主键
     */
    private void writeBackWeighReportDel(Long id) {
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getPkCheck, null);
        updateWrapper.set(WeighReportEntity::getCheckStatus, 0);
        updateWrapper.set(WeighReportEntity::getCheckCode, null);
        weighReportService.update(updateWrapper);
    }

//    /**
//     * 获取access_token服务
//     *
//     * @param headers
//     * @throws GeneralSecurityException
//     * @throws IOException
//     */
//    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
//        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
//        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
//            //若存在，直接放到header中
//            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
//        }else{
//            String initContextUrl = SUPPLIER_HTTP + "/el/sw/auth/v1/accessToken?appId=6de82f4q&secret=@zLc1HUc";
//            String responseStr = null;
//            try {
//                responseStr = HttpTookit.get(initContextUrl, null);
//                JSONObject json = JSONObject.parseObject(responseStr);
//                if("200".equals(json.get("code").toString())){
//                    JSONObject data = json.getJSONObject("body");
//                    String access_token = data.get("token").toString();
//                    headers.put("X-Open-Token", access_token);
//                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
//                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
//                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
//                }else{
//                    //请求失败，输出错误信息
//                    return CommonResponse.error("获取供方access_token异常");
//                }
//            } catch (GeneralSecurityException e) {
//                logger.info("GeneralSecurityException 异常"+e.getMessage());
//                return CommonResponse.error("获取供方access_token异常");
//            } catch (IOException e) {
//                logger.info("IOException 异常"+e.getMessage());
//                return CommonResponse.error("获取供方access_token异常");
//            }
//        }
//        return CommonResponse.success();
//    }

    /**
     * Get公共方法
     *
     * @param url       路径地址
     * @param params    参数  Map<String, String>
     * @return
     */
    private CommonResponse<Object> doGetHttp(String url, Map<String, String> params) {
        Map<String, String> headers = new HashMap();
        // 获取token
//        this.getAccessToken(headers);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if(tokenres.isSuccess()){
            try {
                logger.info("------------  url：" + url + "  ------------");
                logger.info("------------  入参：" + params.toString() + "  ------------");
                String back = HttpTookit.get(url, params, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if("200".equals(jsonBack.getString("code"))){
                    //调用同步方法成功
                    logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success(jsonBack.get("body"));
                }else{
                    //调用同步方法失败，输出错误信息
                    logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
                    return CommonResponse.error(jsonBack.getString("message"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return CommonResponse.error("查询失败！");
            }
        }else{
            logger.error("获取token异常，请联系管理员");
            return CommonResponse.error("查询失败！");
        }
    }

    /**
     * Post公共方法
     *
     * @param url               路径地址
     * @param parameterStr      参数  JSONString
     * @return
     */
    private CommonResponse<Object>  doPostHttp(String url, String parameterStr){
        Map<String, String> headers = new HashMap();
        // 获取token
//        this.getAccessToken(headers);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if(tokenres.isSuccess()){
            try {
                logger.info("------------  url：" + url + "  ------------");
                logger.info("------------  入参：" + parameterStr + "  ------------");
                String back = HttpTookit.postByJson(url, parameterStr, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if("200".equals(jsonBack.getString("code"))){
                    //调用同步方法成功
                    logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success(jsonBack.get("body"));
                }else{
                    //调用同步方法失败，输出错误信息
                    logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
                    return CommonResponse.error(jsonBack.getString("message"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return CommonResponse.error("查询失败！");
            }
        }else{
            logger.error("获取token异常，请联系管理员");
            return CommonResponse.error("查询失败！");
        }
    }

    /**
     * 获取登录用户sourceId
     * @return
     */
    private String getUserSourceId() {
        CommonResponse<List<UserVO>> res = userApi.queryListByIds(new String[]{String.valueOf(InvocationInfoProxy.getUserid())});
        if(!res.isSuccess()){
            throw new BusinessException("查询用户失败！");
        }
        if(CollectionUtils.isNotEmpty(res.getData())){
            UserVO vo = res.getData().get(0);// 获取登录用户VO
            if(vo != null && StringUtils.isNotEmpty(vo.getSourceId())){
                return vo.getSourceId();// 来源ID
            }
        }
        return null;
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2){
        if(decimal1 == null && decimal2 == null ){
            return null;
        }else{
            decimal1 = decimal1 == null ? BigDecimal.ZERO : decimal1;
            decimal2 = decimal2 == null ? BigDecimal.ZERO : decimal2;
            return decimal1.add(decimal2);
        }
    }

}
