/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.util.MroSignUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ThirdSystemUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Value(value="${mro.appKey}")
    private String appKey;
    @Value(value="${mro.secret}")
    private String secret;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public CommonResponse<String> getMroAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"mro-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"mro-Open-Token"));
            headers.put("x_open_token", this.redisTemplate.opsForValue().get((Object)"mro-Open-Token").toString());
        } else {
            String initContextUrl = this.addr + "/iec/v1/auth/accessToken";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("grantType", (Object)"accessToken");
            jsonObject.put("clientId", (Object)"accessToken");
            jsonObject.put("clientSecret", (Object)"accessToken");
            jsonObject.put("username", (Object)"accessToken");
            jsonObject.put("password", (Object)"accessToken");
            try {
                String responseStr = HttpTookit.postByJson((String)initContextUrl, (String)jsonObject.toJSONString(), headers, (Integer)10000, (Integer)10000);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("resultCode") || !json.getBoolean("success").booleanValue()) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("result");
                String access_token = data.getString("accessToken");
                headers.put("x_open_token", access_token);
                this.redisTemplate.opsForValue().set((Object)"mro-Open-Token", (Object)access_token, (long)data.getInteger("expiresIn").intValue(), TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (Exception e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        this.getMroSign(headers);
        return CommonResponse.success();
    }

    public CommonResponse<String> getMroSign(Map<String, String> headers) {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String nonce = String.valueOf(UUID.randomUUID());
        headers.put("x-mro-open-appkey", this.appKey);
        headers.put("x-mro-open-nonce", nonce);
        headers.put("x-mro-open-timestamp", timeStamp);
        headers.put("x-mro-open-sg", MroSignUtils.encrypt(this.appKey + "&" + this.secret + "&" + nonce + "&" + timeStamp));
        return CommonResponse.success();
    }
}

