/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.ControlPlanDetailEntity;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.MroProjectEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IControlPlanDetailService;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IMroProjectService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.ControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.ControlPlanVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroDeliveryDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroDeliveryVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zjwjsync/"})
public class ZjwjSyncApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IControlPlanDetailService controlPlanDetailService;
    @Autowired
    private IMroProjectService mroProjectService;
    @Autowired
    private IProjectConfigureService projectConfigureService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    @PostMapping(value={"syncControlPlanList"})
    public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
        ArrayList<ControlPlanEntity> entityList = new ArrayList<ControlPlanEntity>();
        for (SyncControlPlanVO syncVO : controlPlanVOS) {
            UserVO userVO;
            CommonResponse userVOCommonResponse;
            CommonResponse orgVOCommonResponse;
            ControlPlanVO vo = syncVO.getValue();
            ControlPlanEntity entity = (ControlPlanEntity)((Object)BeanMapper.map((Object)vo, ControlPlanEntity.class));
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
            if (null == dbEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbEntity.getId());
            }
            if (entity.getParentOrgSourceId() != null && (orgVOCommonResponse = this.orgApi.findBySourceId(entity.getParentOrgSourceId())).isSuccess()) {
                OrgVO orgVO = (OrgVO)orgVOCommonResponse.getData();
                entity.setParentOrgId(orgVO.getId());
            }
            if (entity.getProjectSourceId() != null) {
                CommonResponse orgVOCommonResponse2;
                CommonResponse registerVOCommonResponse = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId());
                if (registerVOCommonResponse.isSuccess()) {
                    ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)registerVOCommonResponse.getData();
                    entity.setProjectId(projectRegisterVO.getId());
                    entity.setProjectName(projectRegisterVO.getName());
                }
                if ((orgVOCommonResponse2 = this.orgApi.findBySourceId(entity.getProjectSourceId())).isSuccess()) {
                    OrgVO orgVO = (OrgVO)orgVOCommonResponse2.getData();
                    entity.setOrgId(orgVO.getId());
                    entity.setOrgSourceId(orgVO.getSourceId());
                    entity.setOrgName(orgVO.getName());
                }
            }
            if (syncVO.getSourceEmployeeId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceEmployeeId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setEmployeeId(userVO.getId());
                entity.setEmployeeName(userVO.getUserName());
            }
            if (syncVO.getSourceCreatorId() != null && (userVOCommonResponse = this.userApi.findUserBySourceId(syncVO.getSourceCreatorId())).isSuccess()) {
                userVO = (UserVO)userVOCommonResponse.getData();
                entity.setCreateUserCode(userVO.getUserCode());
            }
            entityList.add(entity);
        }
        this.controlPlanService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u5934\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncControlPlanDetailList"})
    public CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
        ArrayList<ControlPlanDetailEntity> entityList = new ArrayList<ControlPlanDetailEntity>();
        for (SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
            CommonResponse materialVOCommonResponse;
            ControlPlanDetailVO vo = syncVO.getValue();
            ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)BeanMapper.map((Object)vo, ControlPlanDetailEntity.class));
            LambdaQueryWrapper queryDetailWrapper = new LambdaQueryWrapper();
            queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, (Object)vo.getSourceId());
            ControlPlanDetailEntity dbDetaliEntity = (ControlPlanDetailEntity)((Object)this.controlPlanDetailService.getOne((Wrapper)queryDetailWrapper, false));
            if (null == dbDetaliEntity) {
                entity.setId(IdWorker.getId());
            } else {
                entity.setId(dbDetaliEntity.getId());
            }
            if (syncVO.getSourceControlId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(ControlPlanEntity::getSourceId, (Object)syncVO.getSourceControlId());
                ControlPlanEntity dbEntity = (ControlPlanEntity)((Object)this.controlPlanService.getOne((Wrapper)queryWrapper, false));
                entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
            }
            if (vo.getMaterialSourceId() != null && (materialVOCommonResponse = this.materialApi.queryMaterialBySourceId(vo.getMaterialSourceId())).isSuccess()) {
                MaterialVO materialVO = (MaterialVO)materialVOCommonResponse.getData();
                entity.setMaterialId(materialVO.getId());
                entity.setMaterialCode(materialVO.getCode());
                entity.setMaterialName(materialVO.getName());
                entity.setUnit(materialVO.getUnitName());
                entity.setSpec(materialVO.getSpec());
                entity.setDef1(materialVO.getDef1());
                entity.setDef2(materialVO.getDef2());
                entity.setDef3(materialVO.getDef3());
                entity.setMaterialTypeId(materialVO.getCategoryId());
                CommonResponse materialCategoryVOCommonResponse = this.materialApi.queryCategoryById(materialVO.getCategoryId());
                if (materialCategoryVOCommonResponse.isSuccess()) {
                    MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)materialCategoryVOCommonResponse.getData();
                    entity.setMaterialTypeName(materialCategoryVO.getName());
                    entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
                }
            }
            entityList.add(entity);
        }
        this.controlPlanDetailService.saveOrUpdateBatch(entityList);
        this.logger.info("\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u603b\u63a7\u8ba1\u5212\u8868\u4f53\u6210\u529f\uff01");
    }

    @GetMapping(value={"syncMroProjectList"})
    public CommonResponse<String> syncMroProjectList() {
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<Long> messagePkList = new ArrayList<Long>();
        JSONArray jsonArray = this.getMessageList(headers, 7001);
        if (null != jsonArray && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                messagePkList.add(jsonObject.getLong("id"));
                Object result = jsonObject.get((Object)"result");
                if (null == result) continue;
                List mroProjPkList = (List)result;
                this.syncMroProjectBatch(headers, mroProjPkList);
            }
        }
        if (CollectionUtils.isNotEmpty(messagePkList)) {
            this.deleteMessageList(headers, messagePkList);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58MRO\u9879\u76ee\u6210\u529f\uff01");
    }

    private void syncMroProjectBatch(Map<String, String> headers, List<Long> mroProjPkList) {
        this.thirdSystemUtils.getMroSign(headers);
        String initContextUrl = this.addr + "/iec/v1/project/details";
        try {
            String responseStr = HttpTookit.postByJson(initContextUrl, JSONObject.toJSONString(mroProjPkList), headers);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                JSONArray jsonArray = json.getJSONArray("data");
                if (null != jsonArray && jsonArray.size() > 0) {
                    ArrayList<MroProjectEntity> entityList = new ArrayList<MroProjectEntity>();
                    ArrayList<String> sourceDeleteList = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject js = jsonArray.getJSONObject(i);
                        SyncMroProjectVO syncMroProjectVO = new SyncMroProjectVO();
                        syncMroProjectVO.setSourceId(js.getString("id"));
                        syncMroProjectVO.setSysStatus(js.getInteger("sysStatus"));
                        syncMroProjectVO.setName(js.getString("name"));
                        syncMroProjectVO.setOrganizationName(js.getString("organizationName"));
                        if (-128 == syncMroProjectVO.getSysStatus()) {
                            sourceDeleteList.add(syncMroProjectVO.getSourceId());
                            continue;
                        }
                        if (1 != syncMroProjectVO.getSysStatus()) continue;
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(MroProjectEntity::getSourceId, (Object)syncMroProjectVO.getSourceId());
                        MroProjectEntity dbMroProjectEntity = (MroProjectEntity)((Object)this.mroProjectService.getOne((Wrapper)queryWrapper, false));
                        if (null == dbMroProjectEntity) {
                            dbMroProjectEntity = new MroProjectEntity();
                            dbMroProjectEntity.setSourceId(syncMroProjectVO.getSourceId());
                            dbMroProjectEntity.setName(syncMroProjectVO.getName());
                            dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
                            dbMroProjectEntity.setId(IdWorker.getId());
                        } else {
                            dbMroProjectEntity.setName(syncMroProjectVO.getName());
                            dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
                        }
                        entityList.add(dbMroProjectEntity);
                    }
                    if (CollectionUtils.isNotEmpty(entityList)) {
                        this.mroProjectService.saveOrUpdateBatch(entityList);
                    }
                    if (CollectionUtils.isNotEmpty(sourceDeleteList)) {
                        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
                        deleteWrapper.in(MroProjectEntity::getSourceId, sourceDeleteList);
                        this.mroProjectService.remove((Wrapper)deleteWrapper);
                        LambdaQueryWrapper deleteWrapper1 = new LambdaQueryWrapper();
                        deleteWrapper1.in(ProjectConfigureEntity::getMroProjectSourceId, sourceDeleteList);
                        this.projectConfigureService.remove((Wrapper)deleteWrapper1);
                    }
                    this.logger.info("\u4fdd\u5b58MRO\u9879\u76ee\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size());
                }
            } else {
                this.logger.info(json.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
    }

    @GetMapping(value={"syncMroDeliveryList"})
    public CommonResponse<String> syncMroDeliveryList() {
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<Long> messagePkList = new ArrayList<Long>();
        JSONArray jsonArray = this.getMessageList(headers, 2055);
        if (null != jsonArray && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                messagePkList.add(jsonObject.getLong("id"));
                JSONObject result = jsonObject.getJSONObject("result");
                if (null == result) continue;
                this.syncMroDelivery(headers, result.getString("deliveryCode"));
            }
        }
        if (CollectionUtils.isNotEmpty(messagePkList)) {
            this.deleteMessageList(headers, messagePkList);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u53d1\u8d27\u5355\u6210\u529f\uff01");
    }

    private boolean syncMroDelivery(Map<String, String> headers, String deliveryCode) {
        this.thirdSystemUtils.getMroSign(headers);
        headers.put("Content-Type", "application/json;charset=UTF-8");
        String initContextUrl = this.addr + "/iec/v1/purchase_plan/delivery/detail/" + deliveryCode;
        try {
            String responseStr = HttpTookit.get(initContextUrl, new HashMap(), headers);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                DeliveryEntity deliveryEntity;
                SyncMroDeliveryVO mroDeliveryVO = (SyncMroDeliveryVO)JSON.parseObject((String)json.getString("data"), SyncMroDeliveryVO.class);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(DeliveryEntity::getMroDeliveryCode, (Object)mroDeliveryVO.getDeliveryCode());
                List deliveryEntities = this.deliveryService.list((Wrapper)queryWrapper);
                DeliveryEntity deliveryEntity2 = deliveryEntity = CollectionUtils.isNotEmpty((Collection)deliveryEntities) ? (DeliveryEntity)((Object)this.deliveryService.selectById(((DeliveryEntity)((Object)deliveryEntities.get(0))).getId())) : new DeliveryEntity();
                if (!this.changeMroToDelivery(deliveryEntity, mroDeliveryVO)) {
                    return false;
                }
                this.deliveryService.saveOrUpdate((Object)deliveryEntity, false);
                this.logger.info("\u4fdd\u5b58\u53d1\u8d27\u5355--------\u300b\u300b\u300b");
            } else {
                this.logger.info(json.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
        return true;
    }

    private boolean changeMroToDelivery(DeliveryEntity deliveryEntity, SyncMroDeliveryVO mroDeliveryVO) {
        if (null != deliveryEntity.getDeliverState() && 0 != deliveryEntity.getDeliverState()) {
            return false;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PlanEntity::getBillCode, (Object)mroDeliveryVO.getDemandCode());
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.getOne((Wrapper)wrapper, false));
        if (null == planEntity) {
            this.logger.info("\u8be5\u7f16\u53f7\u65e0\u5bf9\u5e94\u8ba1\u5212");
            return false;
        }
        if (null == deliveryEntity.getId()) {
            deliveryEntity.setPlanId(planEntity.getId());
            deliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            deliveryEntity.setDeliverState(1);
            deliveryEntity.setSmartStatus("0");
            deliveryEntity.setCloseStatus("0");
            deliveryEntity.setProjectId(planEntity.getProjectId());
            deliveryEntity.setProjectName(planEntity.getProjectName());
            deliveryEntity.setProjectSourceId(planEntity.getProjectSourceId());
            deliveryEntity.setParentOrgId(planEntity.getParentOrgId());
            deliveryEntity.setParentOrgSourceId(planEntity.getParentOrgSourceId());
            deliveryEntity.setOrgId(planEntity.getOrgId());
            deliveryEntity.setOrgName(planEntity.getOrgName());
            deliveryEntity.setOrgSourceId(planEntity.getOrgSourceId());
            deliveryEntity.setConstruction(planEntity.getConstruction());
            deliveryEntity.setSupplierId(Long.valueOf("1336866881390252033"));
            deliveryEntity.setSupplierSourceId("1129H6100000015L6YTE");
            deliveryEntity.setSupplierName("\u4e2d\u5efa\u7535\u5b50\u5546\u52a1\u6709\u9650\u8d23\u4efb\u516c\u53f8");
            deliveryEntity.setMaterialType(MaterialTypeEnum.MRO.getCode());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            deliveryEntity.setDeliveryDate(formatter.parse(mroDeliveryVO.getShipDate()));
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        deliveryEntity.setBillCode(mroDeliveryVO.getDeliveryCode());
        deliveryEntity.setOrderBillCode(mroDeliveryVO.getOrderCode());
        deliveryEntity.setMroDeliveryCode(mroDeliveryVO.getDeliveryCode());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(deliveryEntity.getDeliveryDetail())) {
            map = deliveryEntity.getDeliveryDetail().stream().collect(Collectors.toMap(DeliveryDetailEntity::getPlanDetailId, Function.identity(), (key1, key2) -> key2));
        }
        ArrayList<String> stringList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)mroDeliveryVO.getDetailList())) {
            ArrayList<DeliveryDetailEntity> detailEntityList = new ArrayList<DeliveryDetailEntity>();
            for (SyncMroDeliveryDetailVO detail : mroDeliveryVO.getDetailList()) {
                DeliveryDetailEntity detailEntity = null;
                if (map.containsKey(Long.parseLong(detail.getThirdId()))) {
                    detailEntity = (DeliveryDetailEntity)((Object)map.get(Long.parseLong(detail.getThirdId())));
                } else {
                    detailEntity = new DeliveryDetailEntity();
                    PlanDetailEntity planDetailEntity = (PlanDetailEntity)((Object)this.planDetailService.selectById((Serializable)((Object)detail.getThirdId())));
                    detailEntity.setPlanDetailId(planDetailEntity.getId());
                    detailEntity.setMaterialId(planDetailEntity.getMaterialId());
                    detailEntity.setMaterialCode(planDetailEntity.getMaterialCode());
                    detailEntity.setMaterialName(planDetailEntity.getMaterialName());
                    detailEntity.setMaterialTypeId(planDetailEntity.getMaterialTypeId());
                    detailEntity.setMaterialTypeName(planDetailEntity.getMaterialTypeName());
                    detailEntity.setMaterialSourceId(planDetailEntity.getMaterialSourceId());
                    detailEntity.setUnit(planDetailEntity.getUnit());
                    detailEntity.setSpec(planDetailEntity.getSpec());
                    detailEntity.setSmartStatus("0");
                }
                stringList.add(detailEntity.getMaterialName());
                detailEntity.setMroTaxrate(detail.getTaxRate().multiply(BigDecimal.valueOf(100L)));
                detailEntity.setMroDeliverNumsSum(detail.getShipQuantity());
                detailEntity.setMroMny(detail.getTotalExcludeAmount());
                detailEntity.setMroNprice(detail.getExcludeSalesPrice());
                detailEntity.setMroNtaxprice(detail.getSalesPrice());
                detailEntity.setMroSupplierSkuCode(detail.getSupplierSkuCode());
                detailEntity.setMroSupplierSkuId(detail.getSupplierSkuId());
                detailEntity.setMroTaxmny(detail.getTotalAmount());
                detailEntity.setMroTax(detailEntity.getMroTaxmny().subtract(detailEntity.getMroMny()));
                detailEntity.setMroUnit(detail.getUnitName());
                detailEntity.setMroUnitRatio(detail.getDemandQuantity().divide(detail.getQuantity()));
                detailEntity.setDeliverNumsSum(detailEntity.getMroDeliverNumsSum().multiply(detailEntity.getMroUnitRatio()));
                detailEntityList.add(detailEntity);
            }
            deliveryEntity.setMaterialName(StringUtils.join(stringList, (String)","));
            deliveryEntity.setDeliveryDetail(detailEntityList);
        }
        return true;
    }

    private JSONArray getMessageList(Map<String, String> headers, Integer type) {
        this.thirdSystemUtils.getMroSign(headers);
        String initContextUrl = this.addr + "/iec/v1/message/list";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        try {
            String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                return json.getJSONArray("data");
            }
            this.logger.info(json.toJSONString());
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
        return null;
    }

    private void deleteMessageList(Map<String, String> headers, List<Long> messagePkList) {
        this.thirdSystemUtils.getMroSign(headers);
        String initContextUrl = this.addr + "/iec/v1/message/delete";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ids", messagePkList);
        try {
            String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                this.logger.info("\u6d88\u606f\u5220\u9664\u6210\u529f");
            } else {
                this.logger.info(json.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
        }
    }
}

