package com.ejianc.business.wzxt.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 发货实体明细表
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_delivery_detail")
public class DeliveryDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="delivery_id")
    private java.lang.Long deliveryId; // 发货主键ID
    @TableField(value="order_id")
    private java.lang.Long orderId; // 订单主键ID
    @TableField(value="order_detail_id")
    private java.lang.Long orderDetailId; // 订单明细主键ID
    @TableField(value="material_id")
    private java.lang.Long materialId; // 物资主键
    @TableField(value="material_source_id")
    private java.lang.String materialSourceId; // 物资来源主键
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="material_type_id")
    private java.lang.Long materialTypeId; // 物资类别
    @TableField(value="material_type_name")
    private java.lang.String materialTypeName; // 物资类别名称
    @TableField(value="material_code")
    private java.lang.String materialCode; // 物料编码
    @TableField(value="unit")
    private java.lang.String unit; // 单位
    @TableField(value="spec")
    private java.lang.String spec; // 规格型号
    @TableField(value="receive_nums_sum")
    private java.math.BigDecimal receiveNumsSum; // 接收数量
    @TableField(value="order_nums_sum")
    private java.math.BigDecimal orderNumsSum; // 订单数量
    @TableField(value="deliver_nums_sum")
    private java.math.BigDecimal deliverNumsSum; // 发货数量
    @TableField(value="check_nums_sum")
    private java.math.BigDecimal checkNumsSum; // 验收数量
    @TableField(value="material_manufacturer")
    private java.lang.String materialManufacturer; // 生产厂家
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="smart_status")
    private java.lang.String smartStatus; // 智能称重标识
    @TableField(value="history_flag")
    private java.lang.Boolean historyFlag; // 是否历史数据
    @TableField(value="history_id")
    private java.lang.String historyId; // 来源主键
    @TableField(value="history_system")
    private java.lang.String historySystem; // 来源系统
    @TableField(value="def1")
    private java.lang.String def1; // 自定义字段
    @TableField(value="def2")
    private java.lang.String def2; // 自定义字段
    @TableField(value="def3")
    private java.lang.String def3; // 自定义字段
    @TableField(value="def4")
    private java.lang.String def4; // 自定义字段
    @TableField(value="def5")
    private java.lang.String def5; // 自定义字段
    @TableField(exist = false)
    private BigDecimal netWeight;
    //单位转换系数
    @TableField(exist = false)
    private BigDecimal transformRate;
    //单位转换系数
    @TableField(exist = false)
    private java.lang.String orderDetailStringId;

    /******  mro add begin     ******/
    @TableField(value="mro_mny")
    private BigDecimal mroMny; // mro无税金额
    @TableField(value="mro_taxmny")
    private BigDecimal mroTaxmny; // mro含税金额
    @TableField(value="mro_nprice")
    private BigDecimal mroNprice; // mro无税价格
    @TableField(value="mro_ntaxprice")
    private BigDecimal mroNtaxprice; // mro含税价格
    @TableField(value="mro_taxrate")
    private BigDecimal mroTaxrate; // mro税率
    @TableField(value="mro_tax")
    private BigDecimal mroTax; // mro税金
    @TableField(value="mro_deliver_nums_sum")
    private BigDecimal mroDeliverNumsSum; // mro发货数量
    @TableField(value="mro_supplier_sku_code")
    private String mroSupplierSkuCode; // 供应商skuCode 字符类型
    @TableField(value="mro_supplier_sku_id")
    private String mroSupplierSkuId; // 供应商skuId长整型
    @TableField(value="plan_detail_id")
    private Long planDetailId; //需用计划Id
    @TableField(value="mro_unit_ratio")
    private BigDecimal mroUnitRatio; // mro换算率
    @TableField(value="mro_unit")
    private String mroUnit; // mro单位

    public BigDecimal getMroMny() {
        return mroMny;
    }

    public void setMroMny(BigDecimal mroMny) {
        this.mroMny = mroMny;
    }

    public BigDecimal getMroTaxmny() {
        return mroTaxmny;
    }

    public void setMroTaxmny(BigDecimal mroTaxmny) {
        this.mroTaxmny = mroTaxmny;
    }

    public BigDecimal getMroNprice() {
        return mroNprice;
    }

    public void setMroNprice(BigDecimal mroNprice) {
        this.mroNprice = mroNprice;
    }

    public BigDecimal getMroNtaxprice() {
        return mroNtaxprice;
    }

    public void setMroNtaxprice(BigDecimal mroNtaxprice) {
        this.mroNtaxprice = mroNtaxprice;
    }

    public BigDecimal getMroTaxrate() {
        return mroTaxrate;
    }

    public void setMroTaxrate(BigDecimal mroTaxrate) {
        this.mroTaxrate = mroTaxrate;
    }

    public BigDecimal getMroTax() {
        return mroTax;
    }

    public void setMroTax(BigDecimal mroTax) {
        this.mroTax = mroTax;
    }

    public BigDecimal getMroDeliverNumsSum() {
        return mroDeliverNumsSum;
    }

    public void setMroDeliverNumsSum(BigDecimal mroDeliverNumsSum) {
        this.mroDeliverNumsSum = mroDeliverNumsSum;
    }

    public String getMroSupplierSkuCode() {
        return mroSupplierSkuCode;
    }

    public void setMroSupplierSkuCode(String mroSupplierSkuCode) {
        this.mroSupplierSkuCode = mroSupplierSkuCode;
    }

    public String getMroSupplierSkuId() {
        return mroSupplierSkuId;
    }

    public void setMroSupplierSkuId(String mroSupplierSkuId) {
        this.mroSupplierSkuId = mroSupplierSkuId;
    }

    public Long getPlanDetailId() {
        return planDetailId;
    }

    public void setPlanDetailId(Long planDetailId) {
        this.planDetailId = planDetailId;
    }

    public BigDecimal getMroUnitRatio() {
        return mroUnitRatio;
    }

    public void setMroUnitRatio(BigDecimal mroUnitRatio) {
        this.mroUnitRatio = mroUnitRatio;
    }

    public String getMroUnit() {
        return mroUnit;
    }

    public void setMroUnit(String mroUnit) {
        this.mroUnit = mroUnit;
    }

    /******  mro add end     ******/

    public String getOrderDetailStringId() {
        return orderDetailStringId;
    }

    public void setOrderDetailStringId(String orderDetailStringId) {
        this.orderDetailStringId = orderDetailStringId;
    }

    public BigDecimal getTransformRate() {
        return transformRate;
    }

    public void setTransformRate(BigDecimal transformRate) {
        this.transformRate = transformRate;
    }

    public String getMaterialSourceId() {
        return materialSourceId;
    }

    public void setMaterialSourceId(String materialSourceId) {
        this.materialSourceId = materialSourceId;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public Boolean getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Boolean historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    /**
     * 发货主键ID
     */
    public java.lang.Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键ID
     */
    public void setDeliveryId(java.lang.Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 订单主键ID
     */
    public java.lang.Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(java.lang.Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单明细主键ID
     */
    public java.lang.Long getOrderDetailId() {
        return orderDetailId;
    }

    /**
     * 订单明细主键ID
     */
    public void setOrderDetailId(java.lang.Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    /**
     * 物资主键
     */
    public java.lang.Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(java.lang.Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public java.lang.Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(java.lang.Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public java.lang.String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(java.lang.String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物料编码
     */
    public java.lang.String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(java.lang.String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 单位
     */
    public java.lang.String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(java.lang.String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public java.lang.String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(java.lang.String spec) {
        this.spec = spec;
    }
    /**
     * 接收数量
     */
    public java.math.BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    /**
     * 接收数量
     */
    public void setReceiveNumsSum(java.math.BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }
    /**
     * 订单数量
     */
    public java.math.BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    /**
     * 订单数量
     */
    public void setOrderNumsSum(java.math.BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }
    /**
     * 发货数量
     */
    public java.math.BigDecimal getDeliverNumsSum() {
        return deliverNumsSum;
    }

    /**
     * 发货数量
     */
    public void setDeliverNumsSum(java.math.BigDecimal deliverNumsSum) {
        this.deliverNumsSum = deliverNumsSum;
    }
    /**
     * 验收数量
     */
    public java.math.BigDecimal getCheckNumsSum() {
        return checkNumsSum;
    }

    /**
     * 验收数量
     */
    public void setCheckNumsSum(java.math.BigDecimal checkNumsSum) {
        this.checkNumsSum = checkNumsSum;
    }
    /**
     * 生产厂家
     */
    public java.lang.String getMaterialManufacturer() {
        return materialManufacturer;
    }

    /**
     * 生产厂家
     */
    public void setMaterialManufacturer(java.lang.String materialManufacturer) {
        this.materialManufacturer = materialManufacturer;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }

    @Override
    public String toString() {
        return "DeliveryDetailEntity{" +
                "deliveryId=" + deliveryId +
                ", orderId=" + orderId +
                ", orderDetailId=" + orderDetailId +
                ", materialId=" + materialId +
                ", materialSourceId='" + materialSourceId + '\'' +
                ", materialName='" + materialName + '\'' +
                ", materialTypeId=" + materialTypeId +
                ", materialTypeName='" + materialTypeName + '\'' +
                ", materialCode='" + materialCode + '\'' +
                ", unit='" + unit + '\'' +
                ", spec='" + spec + '\'' +
                ", receiveNumsSum=" + receiveNumsSum +
                ", orderNumsSum=" + orderNumsSum +
                ", deliverNumsSum=" + deliverNumsSum +
                ", checkNumsSum=" + checkNumsSum +
                ", materialManufacturer='" + materialManufacturer + '\'' +
                ", memo='" + memo + '\'' +
                ", smartStatus='" + smartStatus + '\'' +
                ", historyFlag=" + historyFlag +
                ", historyId='" + historyId + '\'' +
                ", historySystem='" + historySystem + '\'' +
                ", def1='" + def1 + '\'' +
                ", def2='" + def2 + '\'' +
                ", def3='" + def3 + '\'' +
                ", def4='" + def4 + '\'' +
                ", def5='" + def5 + '\'' +
                ", netWeight=" + netWeight +
                ", transformRate=" + transformRate +
                ", orderDetailStringId='" + orderDetailStringId + '\'' +
                '}';
    }
}
