package com.ejianc.business.wzxt.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_order")
public class OrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="contract_id")
    private java.lang.String contractId; // 合同主键
    @TableField(value="contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名称
    @TableField(value="supplier_tenant_id")
    private java.lang.Long supplierTenantId; // 供应商租户ID
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="commit_id")
    private java.lang.Long commitId; // 提交人
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="link_id")
    private java.lang.Long linkId; // 联系人
    @TableField(value="link_name")
    private java.lang.String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private java.lang.String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="order_create_date")
    private java.util.Date orderCreateDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="order_expiry_date")
    private java.util.Date orderExpiryDate; // 到货日期
    @TableField(value="order_note")
    private java.lang.String orderNote; // 送货要求
    @TableField(value="order_address")
    private java.lang.String orderAddress; // 送货地址
    @TableField(value="receive_state")
    private java.lang.Integer receiveState; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    @TableField(value="deliver_state")
    private java.lang.Integer deliverState; // 发货状态（0-待发货，1-已发货，2-已验收，3-已退回）
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）


    @TableField(value="org_source_id")
    private java.lang.String orgSourceId; // 组织来源id
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_source_id")
    private java.lang.String parentOrgSourceId; // 上级组织来源id
    @TableField(value="contract_code")
    private java.lang.String contractCode; // 合同编号
    @TableField(value="supplier_source_id")
    private java.lang.String supplierSourceId; // 供应商来源id
    @TableField(value="construction")
    private java.lang.String construction; // 施工部位
    @TableField("smart_status")
    private String smartStatus;//智能称重标识
    @TableField(value="platform_type")
    private java.lang.String platformType; // 磅点类型
    @TableField(value="platform_code")
    private java.lang.String platformCode; // 磅点编号
    @TableField("history_flag")
    private Integer historyFlag;//是否历史数据(1是,0否)
    @TableField(value="history_system")
    private java.lang.String historySystem; // 来源系统
    @TableField(value="history_id")
    private java.lang.String historyId; // 来源主键
    @TableField(value="def1")
    private java.lang.String def1;
    @TableField(value="def2")
    private java.lang.String def2;
    @TableField(value="def3")
    private java.lang.String def3;
    @TableField(value="def4")
    private java.lang.String def4;
    @TableField(value="def5")
    private java.lang.String def5;

    @TableField(value="order_type")
    private java.lang.Integer orderType; // 订单类型（0-材料采购1-周转材租赁）

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Integer getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Integer historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    // 采购订单明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="orderDetailService",pidName = "orderId")
    private List<OrderDetailEntity> purchaseOrderDetail = new ArrayList<>();

    public List<OrderDetailEntity> getPurchaseOrderDetail() {
        return purchaseOrderDetail;
    }

    public void setPurchaseOrderDetail(List<OrderDetailEntity> purchaseOrderDetail) {
        this.purchaseOrderDetail = purchaseOrderDetail;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商租户ID
     */
    public java.lang.Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户ID
     */
    public void setSupplierTenantId(java.lang.Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public java.util.Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(java.util.Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public java.util.Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(java.util.Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(java.lang.String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(java.lang.String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-全部接收，1-部分接受，2-已拒绝）
     */
    public java.lang.Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-全部接收，1-部分接受，2-已拒绝）
     */
    public void setReceiveState(java.lang.Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

    @Override
    public String toString() {
        return "OrderEntity{" +
                "billCode='" + billCode + '\'' +
                ", projectId=" + projectId +
                ", projectSourceId='" + projectSourceId + '\'' +
                ", projectName='" + projectName + '\'' +
                ", orgId=" + orgId +
                ", orgName='" + orgName + '\'' +
                ", contractId='" + contractId + '\'' +
                ", contractName='" + contractName + '\'' +
                ", supplierId=" + supplierId +
                ", supplierName='" + supplierName + '\'' +
                ", supplierTenantId=" + supplierTenantId +
                ", materialName='" + materialName + '\'' +
                ", commitId=" + commitId +
                ", employeeId=" + employeeId +
                ", employeeName='" + employeeName + '\'' +
                ", linkId=" + linkId +
                ", linkName='" + linkName + '\'' +
                ", linkTelephone='" + linkTelephone + '\'' +
                ", orderCreateDate=" + orderCreateDate +
                ", orderExpiryDate=" + orderExpiryDate +
                ", orderNote='" + orderNote + '\'' +
                ", orderAddress='" + orderAddress + '\'' +
                ", receiveState=" + receiveState +
                ", deliverState=" + deliverState +
                ", billState=" + billState +
                ", orgSourceId='" + orgSourceId + '\'' +
                ", parentOrgId=" + parentOrgId +
                ", parentOrgSourceId='" + parentOrgSourceId + '\'' +
                ", contractCode='" + contractCode + '\'' +
                ", supplierSourceId='" + supplierSourceId + '\'' +
                ", construction='" + construction + '\'' +
                ", smartStatus='" + smartStatus + '\'' +
                ", platformType='" + platformType + '\'' +
                ", platformCode='" + platformCode + '\'' +
                ", historyFlag=" + historyFlag +
                ", historySystem='" + historySystem + '\'' +
                ", historyId='" + historyId + '\'' +
                ", def1='" + def1 + '\'' +
                ", def2='" + def2 + '\'' +
                ", def3='" + def3 + '\'' +
                ", def4='" + def4 + '\'' +
                ", def5='" + def5 + '\'' +
                ", purchaseOrderDetail=" + purchaseOrderDetail +
                '}';
    }
}
