/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"plan"})
public class PlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return this.planService.saveOrUpdate(planVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = (PlanEntity)((Object)this.planService.selectById(id));
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryLatelyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> queryLinkDetail(Long projectId) {
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BaseEntity::getCreateUserCode, (Object)InvocationInfoProxy.getUsercode());
        lambda.eq(PlanEntity::getProjectId, (Object)projectId);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        details = this.planService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(details.get(0), PlanVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/updatePlanStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> updatePlanStatus(Long id, String planFlag) {
        if (planFlag.equals("0")) {
            LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
            queryWrapperDetail.eq(PlanDetailEntity::getPlanId, (Object)id);
            List deliveryDetailList = this.planDetailService.list((Wrapper)queryWrapperDetail);
            Boolean isZero = true;
            for (PlanDetailEntity planDetailEntity : deliveryDetailList) {
                if (planDetailEntity.getSurplusNums().compareTo(BigDecimal.ZERO) != 1) continue;
                isZero = false;
            }
            if (!isZero.booleanValue()) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(PlanEntity::getPlanFlag, (Object)planFlag);
                boolean flag = this.planService.update((Wrapper)updateWrapper);
                if (!flag) {
                    throw new BusinessException("\u66f4\u65b0\u8ba1\u5212\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
            if (isZero.booleanValue()) {
                throw new BusinessException("\u8ba1\u5212\u4f59\u91cf\u4e3a\u96f6,\u4e0d\u652f\u6301\u5173\u95ed\uff01");
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(PlanEntity::getPlanFlag, (Object)planFlag);
        boolean flag = this.planService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u66f4\u65b0\u8ba1\u5212\u72b6\u6001\u5931\u8d25\uff01");
        }
        PlanEntity entity = (PlanEntity)((Object)this.planService.selectById(id));
        this.updateMroPlanState(entity);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private void updateMroPlanState(PlanEntity planEntity) {
        if (MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (StringUtils.isBlank((CharSequence)planEntity.getHistoryId())) {
                throw new BusinessException("\u8be5\u8ba1\u5212MRO\u4e3b\u952e\u4e3a\u7a7a");
            }
            this.thirdSystemUtils.getMroSign(headers);
            String mroUrl = this.addr + "/iec/v1/purchase_plan/update/status";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)planEntity.getHistoryId());
            jsonObject.put("targetStatus", (Object)("0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON"));
            try {
                String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("code") || !json.getBoolean("success").booleanValue()) {
                    throw new BusinessException(json.getString("message"));
                }
                this.logger.info("\u66f4\u65b0MRO\u8ba1\u5212\u72b6\u6001\u6210\u529f");
            }
            catch (Exception e) {
                this.logger.info("\u5f02\u5e38" + e.getMessage());
            }
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        this.planService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("construction");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        }
        IPage page = this.planService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        }
        IPage pageData = this.planService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), PlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getPlanFlag().equals("0")) {
                    vo.setPlanFlagName("\u5df2\u5173\u95ed");
                } else {
                    vo.setPlanFlagName("\u6b63\u5e38");
                }
                if (vo.getMaterialType().equals("0")) {
                    vo.setMaterialTypeName("\u6d88\u8017\u6750\u91c7\u8d2d\u8ba1\u5212");
                } else {
                    vo.setMaterialTypeName("\u5468\u8f6c\u6750\u79df\u8d41\u8ba1\u5212");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("planExport.xlsx", beans, response);
    }

    @GetMapping(value={"/planRef"})
    @ResponseBody
    public CommonResponse<JSONObject> planRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("planFlag", new Parameter("eq", (Object)true));
        Long projectId = null;
        Integer materialType = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("materialType")) {
                materialType = Integer.valueOf(conditionMap.get("materialType").toString());
                queryParam.getParams().put("materialType", new Parameter("eq", (Object)materialType));
            }
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        PlanVO planVO = new PlanVO();
        planVO.setTenantId(InvocationInfoProxy.getTenantid());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<PlanDetailVO> list = this.planDetailService.geMaterialDetail((Page<PlanDetailVO>)page, wrapper);
        ArrayList<Long> materialListId = new ArrayList<Long>();
        for (PlanDetailVO planDetailVO : list) {
            planDetailVO.setParentId(Long.valueOf(999L));
            planDetailVO.setTid(planDetailVO.getMaterialId());
            materialListId.add(planDetailVO.getMaterialId());
        }
        QueryParam queryDetailParam = new QueryParam();
        queryDetailParam.getParams().put("materialId", new Parameter("in", materialListId));
        List<PlanDetailRefVO> planVOList = this.planService.getPlanByMaterialId(materialListId, wrapper);
        for (PlanDetailVO planDetailVO : list) {
            ArrayList<PlanDetailRefVO> planDetail = new ArrayList<PlanDetailRefVO>();
            for (PlanDetailRefVO planVOChild : planVOList) {
                if (!planDetailVO.getMaterialId().equals(planVOChild.getMaterialId())) continue;
                planVOChild.setParentId(planDetailVO.getMaterialId());
                planVOChild.setOrderNumsSum(planVOChild.getSurplusNumsSum());
                planVOChild.setRowState("add");
                planVOChild.setSmartStatus("3");
                planVOChild.setOriginSmartStatus("3");
                planVOChild.setSourceName(planVOChild.getPlanBillCode() + planVOChild.getPlanEmployeeName());
                planDetail.add(planVOChild);
            }
            planDetailVO.setPlanDetail(planDetail);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

