/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanMaterialVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="plan")
public class PlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IProjectConfigureService projectConfigureService;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(billId));
        if (MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ProjectConfigureEntity::getProjectId, (Object)planEntity.getProjectId());
            ProjectConfigureEntity configureEntity = (ProjectConfigureEntity)((Object)this.projectConfigureService.getOne((Wrapper)queryWrapper, false));
            if (null == configureEntity) {
                throw new BusinessException("\u8be5\u9879\u76ee\u672a\u5173\u8054MRO\u9879\u76ee");
            }
            SyncMroPlanVO syncMroPlanVO = this.changePlanToMro(planEntity, configureEntity);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.thirdSystemUtils.getMroSign(headers);
            String mroUrl = this.addr + "/iec/v1/purchase_plan/save";
            try {
                String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON((Object)syncMroPlanVO).toString(), headers);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 == json.getInteger("code") && json.getBoolean("success").booleanValue()) {
                    this.logger.info("\u63a8\u9001MRO\u6210\u529f" + json.toJSONString());
                    String mroId = json.getString("data");
                    planEntity.setHistoryId(mroId);
                    planEntity.setHistorySystem("MRO");
                    this.planService.saveOrUpdate((Object)planEntity);
                } else {
                    this.logger.info(json.toJSONString());
                }
            }
            catch (Exception e) {
                this.logger.info("\u5f02\u5e38" + e.getMessage());
            }
        }
        return CommonResponse.success();
    }

    private SyncMroPlanVO changePlanToMro(PlanEntity planEntity, ProjectConfigureEntity configureEntity) {
        SyncMroPlanVO syncMroPlanVO = new SyncMroPlanVO();
        syncMroPlanVO.setCode(planEntity.getBillCode());
        syncMroPlanVO.setProjectId(Long.valueOf(configureEntity.getMroProjectSourceId()));
        syncMroPlanVO.setStatus("ON");
        syncMroPlanVO.setThirdId(planEntity.getId().toString());
        syncMroPlanVO.setDescription(planEntity.getMemo());
        if (CollectionUtils.isNotEmpty(planEntity.getPlanDetail())) {
            ArrayList syncMroPlanDetailVOS = new ArrayList();
            planEntity.getPlanDetail().forEach(detail -> {
                SyncMroPlanMaterialVO syncMaterialVO = new SyncMroPlanMaterialVO();
                syncMaterialVO.setCode(detail.getMaterialCode());
                syncMaterialVO.setName(detail.getMaterialName());
                syncMaterialVO.setSpecification(detail.getSpec());
                syncMaterialVO.setUnit(detail.getUnit());
                syncMaterialVO.setThirdId(detail.getMaterialId().toString());
                SyncMroPlanDetailVO syncDetailVO = new SyncMroPlanDetailVO();
                syncDetailVO.setTotalCount(detail.getNums());
                syncDetailVO.setDescription(detail.getMemo());
                syncDetailVO.setThirdId(detail.getId().toString());
                syncDetailVO.setMaterial(syncMaterialVO);
                syncMroPlanDetailVOS.add(syncDetailVO);
            });
            syncMroPlanVO.setDetails(syncMroPlanDetailVOS);
        }
        return syncMroPlanVO;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(billId));
        if (MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.thirdSystemUtils.getMroSign(headers);
            if (StringUtils.isBlank((CharSequence)planEntity.getHistoryId())) {
                throw new BusinessException("\u8be5\u8ba1\u5212MRO\u4e3b\u952e\u4e3a\u7a7a");
            }
            String mroUrl = this.addr + "/iec/v1/purchase_plan/update/status";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)planEntity.getHistoryId());
            jsonObject.put("originStatus", (Object)("0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON"));
            jsonObject.put("targetStatus", (Object)"DELETED");
            try {
                String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("code") || !json.getBoolean("success").booleanValue()) {
                    throw new BusinessException(json.getString("message"));
                }
                this.logger.info("\u5220\u9664MRO\u8ba1\u5212\u6210\u529f");
            }
            catch (Exception e) {
                this.logger.info("\u5f02\u5e38" + e.getMessage());
            }
        }
        return CommonResponse.success();
    }
}

