package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 订单明细表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/orderDetail")
public class OrderDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrderDetailService service;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IPlanService planService;

    @Autowired
    private IPlanDetailService planDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderDetailVO> saveOrUpdate(@RequestBody OrderDetailVO saveorUpdateVO) {
    	OrderDetailEntity entity = BeanMapper.map(saveorUpdateVO, OrderDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	OrderDetailVO vo = BeanMapper.map(entity, OrderDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderDetailVO> queryDetail(Long id) {
    	OrderDetailEntity entity = service.selectById(id);
    	OrderDetailVO vo = BeanMapper.map(entity, OrderDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetailtest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetailtest() {

        LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda.eq(OrderDetailEntity::getLeafFlag,false);
        lambda.orderBy(true,true,OrderDetailEntity::getHistoryFlag);
        List<OrderDetailEntity> details  = service.list(lambda);
        List<OrderDetailEntity> inserts  = new ArrayList<>();
        Map<Long,List<OrderDetailEntity>> map = new HashMap<>();
        details.forEach(e->{
            if(map.containsKey(e.getOrderId())){
                List<OrderDetailEntity> list = map.get(e.getOrderId());
                if(!e.getLeafFlag()){
                    e.setDetailIndex(list.size()+1+"");
                }
                list.add(e);
                map.put(e.getOrderId(),list);
            }else{
                List<OrderDetailEntity> list = new ArrayList<>();
                if(!e.getLeafFlag()){
                    e.setDetailIndex("1");
                }
                list.add(e);
                map.put(e.getOrderId(),list);
            }
        });

        for(List<OrderDetailEntity> ll : map.values()){
            inserts.addAll(ll);
        }
        service.updateBatchById(inserts);
        return CommonResponse.success("查询详情数据成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetailtest2", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetailtest2() {

        LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda.eq(OrderDetailEntity::getLeafFlag,false);
        lambda.orderBy(true,true,OrderDetailEntity::getHistoryFlag);
        List<OrderDetailEntity> details  = service.list(lambda);

        Map<Long,Integer> map = new HashMap<>();
        Map<Long,Integer> map2 = new HashMap<>();

        details.forEach(e->{
            map.put(e.getOrderId()+e.getTid(),Integer.parseInt(e.getDetailIndex()));
            map2.put(e.getOrderId()+e.getTid(),1);
        });

        LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda2.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda2.eq(OrderDetailEntity::getLeafFlag,true);
        List<OrderDetailEntity> details2  = service.list(lambda2);
        List<OrderDetailEntity> inserts  = new ArrayList<>();

        details2.forEach(e->{
            if(map.containsKey(e.getOrderId()+e.getParentId())){
                int a = map.get(e.getOrderId()+e.getParentId());
                int b = map2.get(e.getOrderId()+e.getParentId());
                e.setDetailIndex(a+"."+b);
                inserts.add(e);
                map2.put(e.getOrderId()+e.getParentId(),b+1);
            }
        });
        service.updateBatchById(inserts);
        return CommonResponse.success("查询详情数据成功！");
    }


    /**
     * @Description queryDetail 根据子表明细行，  汇总到子表汇总行的施工部位
     * @param
     */
    @RequestMapping(value = "/queryDetailtest3", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetailtest3() {

        LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda.eq(OrderDetailEntity::getLeafFlag,false);
        lambda.orderBy(true,true,OrderDetailEntity::getLeafFlag);
        List<OrderDetailEntity> details  = service.list(lambda);

        Map<Long,OrderDetailEntity> map = new HashMap<>();

        details.forEach(e->{
            map.put(e.getOrderId()+e.getTid(),e);
        });

        LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda2.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda2.eq(OrderDetailEntity::getLeafFlag,true);
        lambda.orderBy(true,true,OrderDetailEntity::getLeafFlag);
        List<OrderDetailEntity> details2  = service.list(lambda2);
        List<OrderDetailEntity> inserts  = new ArrayList<>();

        details2.forEach(e->{
            if(map.containsKey(e.getOrderId()+e.getParentId())){
                OrderDetailEntity entity = map.get(e.getOrderId()+e.getParentId());
                String construction = entity.getConstruction()==null?"":entity.getConstruction();
                String construction2 = e.getConstruction()==null?"":e.getConstruction();
                if(StringUtils.isEmpty(construction)){
                    entity.setConstruction(construction2);
                }else if(StringUtils.isEmpty(construction2)){
                    entity.setConstruction(construction);
                }else{
                    entity.setConstruction(construction+","+construction2);
                }
                map.put(e.getOrderId()+e.getParentId(),entity);
            }
        });
        for(OrderDetailEntity ll : map.values()){
            inserts.add(ll);
        }
        service.updateBatchById(inserts);
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description queryDetail 根据子表汇总行，  汇总到主表的施工部位
     * @param
     */
    @RequestMapping(value = "/queryDetailtest4", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetailtest4() {

        LambdaQueryWrapper<OrderEntity> lambda = Wrappers.<OrderEntity>lambdaQuery();
        lambda.eq(OrderEntity::getHistoryFlag,1);
        List<OrderEntity> details  = orderService.list(lambda);
        Map<Long,OrderEntity> map = new HashMap<>();

        details.forEach(e->{
            map.put(e.getId(),e);
        });

        LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambda2.eq(OrderDetailEntity::getHistoryFlag,1);
        lambda2.eq(OrderDetailEntity::getLeafFlag,false);
        lambda2.orderBy(true,true,OrderDetailEntity::getLeafFlag);
        List<OrderDetailEntity> details2  = service.list(lambda2);

        details2.forEach(e->{
            if(map.containsKey(e.getOrderId())){
                OrderEntity entity = map.get(e.getOrderId());
                String construction = entity.getConstruction()==null?"":entity.getConstruction();
                String construction2 = e.getConstruction()==null?"":e.getConstruction();
                if(StringUtils.isEmpty(construction)){
                    entity.setConstruction(construction2);
                }else if(StringUtils.isEmpty(construction2)){
                    entity.setConstruction(construction);
                }else{
                    entity.setConstruction(construction+","+construction2);
                }
                map.put(e.getOrderId(),entity);
            }
        });

        List<OrderEntity> inserts  = new ArrayList<>();

        for(OrderEntity ll : map.values()){
            inserts.add(ll);
        }
        orderService.updateBatchById(inserts);
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderDetailVO> vos) {
        service.removeByIds(vos.stream().map(OrderDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOrderDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PlanVO>> queryList(Long orderDetailId) {
        List<PlanEntity> reslist = new ArrayList<>();
        OrderDetailEntity orderDetailEntity = service.getById(orderDetailId);
        //MRO改造：orderDetailId可能为订单明细主键，也可能为计划明细主键
        if(null != orderDetailEntity){
            LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
            lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
            lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
            lambda.eq(OrderDetailEntity::getLeafFlag,true);
            List<OrderDetailEntity> details  = service.list(lambda);
            if(CollectionUtils.isNotEmpty(details)){
                List<Long> pks = new ArrayList<>();
                pks.addAll(details.stream().map(OrderDetailEntity::getPlanId).collect(Collectors.toList()));
                Map<Long, BigDecimal> map = details.stream().collect(Collectors.toMap(OrderDetailEntity::getPlanId,OrderDetailEntity::getPlanNumsSum));
                reslist = (List)planService.listByIds(pks);
                reslist.forEach(e->{
                    e.setDef1(""+map.get(e.getId()));
                });
            }
        }else{
            //mro改造，为计划明细主键时，来源计划唯一
            PlanDetailEntity planDetailEntity = planDetailService.selectById(orderDetailId);
            reslist = (List)planService.listByIds(Collections.singleton(planDetailEntity.getPlanId()));
            reslist.get(0).setDef1(String.valueOf(planDetailEntity.getNums()));
        }

        return CommonResponse.success("查询列表数据成功！",BeanMapper.mapList(reslist, PlanVO.class));
    }

    /**
     * 订单明细参照，只返回一级
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "orderDetailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderDetailVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialCode");
        Page<OrderDetailEntity> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orderId")) {
                Long orderId = Long.valueOf(conditionMap.get("orderId").toString());
                queryParam.getParams().put("order_id",new Parameter("eq",orderId));
            }
        }
        queryParam.getParams().put("leaf_flag",new Parameter("eq",false));
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.apply("IFNULL(receive_nums_sum,0) > IFNULL(deliver_nums_sum,0)");
        IPage<OrderDetailEntity> pageData = service.selectPage(page,wrapper);

        IPage<OrderDetailVO> voPage = new Page<>();
        List<OrderDetailVO> listres = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            listres = BeanMapper.mapList(pageData.getRecords(),OrderDetailVO.class);
            listres.forEach(e->{
                BigDecimal deliverNumsSum = e.getDeliverNumsSum()==null?BigDecimal.ZERO:e.getDeliverNumsSum();
                BigDecimal receiveNumsSum = e.getReceiveNumsSum()==null?BigDecimal.ZERO:e.getReceiveNumsSum();
                e.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));
            });
        }
        voPage.setCurrent(pageData.getCurrent());
        voPage.setPages(pageData.getPages());
        voPage.setTotal(pageData.getTotal());
        voPage.setSize(queryParam.getPageSize());
        voPage.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！", voPage);
    }

}
