package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.SupplierEvaluationEntity;
import com.ejianc.business.wzxt.service.ISupplierEvaluationService;
import com.ejianc.business.wzxt.vo.SupplierEvaluationVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 供方评价表实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("supplierEvaluation")
public class SupplierEvaluationController implements Serializable {
    
    @Autowired
    private ISupplierEvaluationService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierEvaluationVO> saveOrUpdate(@RequestBody SupplierEvaluationVO saveorUpdateVO) {
    	SupplierEvaluationEntity entity = BeanMapper.map(saveorUpdateVO, SupplierEvaluationEntity.class);
    	service.saveOrUpdate(entity, false);
    	SupplierEvaluationVO vo = BeanMapper.map(entity, SupplierEvaluationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierEvaluationVO> queryDetail(Long id) {
    	SupplierEvaluationEntity entity = service.selectById(id);
    	SupplierEvaluationVO vo = BeanMapper.map(entity, SupplierEvaluationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierEvaluationVO> vos) {
        service.removeByIds(vos.stream().map(SupplierEvaluationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierEvaluationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("evaluatePerson");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<SupplierEvaluationEntity> page = service.queryPage(param,false);
        IPage<SupplierEvaluationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierEvaluationVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SupplierEvaluationEntity> pageData = service.queryPage(param,false);
        List<SupplierEvaluationVO> list = new ArrayList<>();
        list = BeanMapper.mapList(pageData.getRecords(), SupplierEvaluationVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("supplierEvaluation.xlsx", beans, response);
    }

}
