package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.mapper.ProjectConfigureMapper;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.vo.ProjectConfigureVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目设置表
 *
 * @author generator
 *
 */
@Service("projectConfigureService")
public class ProjectConfigureServiceImpl extends BaseServiceImpl<ProjectConfigureMapper, ProjectConfigureEntity> implements IProjectConfigureService{

    @Override
    public CommonResponse<ProjectConfigureVO> insertOrUpdate(ProjectConfigureVO projectConfigureVO) {
        ProjectConfigureEntity entity = BeanMapper.map(projectConfigureVO, ProjectConfigureEntity.class);
        LambdaQueryWrapper<ProjectConfigureEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectConfigureEntity::getProjectId, entity.getProjectId());
        List<ProjectConfigureEntity> entityList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entityList) && !entityList.get(0).getId().equals(projectConfigureVO.getId())) {
            throw new BusinessException("该项目已做过关联设置");
        }
        queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectConfigureEntity::getMroProjectId, entity.getMroProjectId());
        entityList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entityList) && !entityList.get(0).getId().equals(projectConfigureVO.getId())) {
            throw new BusinessException("该MRO项目已关联过其他项目");
        }
        super.saveOrUpdate(entity, false);
        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(entity, ProjectConfigureVO.class));
    }
}
