/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.FileRelation;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.business.wzxt.vo.Purchase;
import com.ejianc.business.wzxt.vo.PurchaseInfo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjOrderUrl}")
    private String wjOrderUrl;
    @Value(value="${openApi.wjDelOrderUrl}")
    private String wjDelOrderUrl;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WZXT_PURCHASE_BILL_CODE = "WJ_WZXT_PURCHASE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)orderVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                orderVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StringBuffer materialName = new StringBuffer();
        ArrayList listedit = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if (null != vo.getLeafFlag() && !vo.getLeafFlag().booleanValue()) {
                    materialName.append(vo.getMaterialName() + ",");
                }
                if (null == vo.getLeafFlag() || vo.getLeafFlag().booleanValue()) {
                    vo.setLeafFlag(Boolean.valueOf(true));
                    if (null != vo.getId()) {
                        if ("del".equals(vo.getRowState())) {
                            PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                            BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                            BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                            BigDecimal orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                            BigDecimal stockAmountSum = vo.getStockAmountSum() == null ? BigDecimal.ZERO : vo.getStockAmountSum();
                            entity.setOccupyNums(occupyNums.subtract(orderNums).subtract(stockAmountSum));
                            entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                            listedit.add(entity);
                        } else {
                            BigDecimal stockAmountSum;
                            OrderDetailEntity detailEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getId())));
                            BigDecimal orderNumsDb = detailEntity.getOrderNumsSum() == null ? BigDecimal.ZERO : detailEntity.getOrderNumsSum();
                            BigDecimal stockAmountSumDb = detailEntity.getStockAmountSum() == null ? BigDecimal.ZERO : detailEntity.getStockAmountSum();
                            BigDecimal orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                            BigDecimal bigDecimal = stockAmountSum = vo.getStockAmountSum() == null ? BigDecimal.ZERO : vo.getStockAmountSum();
                            if (orderNums.compareTo(orderNumsDb) != 0 || stockAmountSum.compareTo(stockAmountSumDb) != 0) {
                                BigDecimal subtractNum = orderNumsDb.subtract(orderNums);
                                BigDecimal stockAmountSumNum = stockAmountSumDb.subtract(stockAmountSum);
                                PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                                BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                                BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                                BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                                entity.setOccupyNums(occupyNums.subtract(subtractNum).subtract(stockAmountSumNum));
                                entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                                if (entity.getSurplusNums().compareTo(BigDecimal.ZERO) < 0) {
                                    throw new BusinessException("\u3010\u8ba2\u5355\u6570\u91cf+\u5e93\u5b58\u91cf\u3011\u4e0d\u80fd\u8d85\u8fc7\u8ba1\u5212\u5269\u4f59\u91cf\uff0c\u8be5\u6750\u6599\u660e\u7ec6\u5b9e\u9645\u5269\u4f59\u91cf\u4e3a\u3010" + surplusNums + "\u3011!");
                                }
                                listedit.add(entity);
                            }
                        }
                    } else {
                        BigDecimal stockAmountSum;
                        PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                        BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                        BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                        BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                        BigDecimal orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                        BigDecimal bigDecimal = stockAmountSum = vo.getStockAmountSum() == null ? BigDecimal.ZERO : vo.getStockAmountSum();
                        if (surplusNums.compareTo(orderNums.add(stockAmountSum)) < 0) {
                            throw new BusinessException("\u3010\u8ba2\u5355\u6570\u91cf+\u5e93\u5b58\u91cf\u3011\u4e0d\u80fd\u8d85\u8fc7\u8ba1\u5212\u5269\u4f59\u91cf\uff0c\u8be5\u6750\u6599\u660e\u7ec6\u5b9e\u9645\u5269\u4f59\u91cf\u4e3a\u3010" + surplusNums + "\u3011!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums).add(stockAmountSum));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        listedit.add(entity);
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(listedit)) {
                this.planDetailService.updateBatchById(listedit);
            }
        } else {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u6750\u6599\u660e\u7ec6!");
        }
        String materialNames = materialName.substring(0, materialName.length() - 1);
        orderVO.setMaterialName(materialNames);
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)orderVO, OrderEntity.class));
        entity.setHistoryFlag(0);
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(OrderVO orderVO) {
        Map<Long, BigDecimal> map;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OrderEntity::getHistoryId, (Object)orderVO.getMainId());
        OrderEntity orderEntity = (OrderEntity)((Object)super.getOne((Wrapper)lambda));
        if (null != orderEntity && null != orderEntity.getId()) {
            orderVO.setId(orderEntity.getId());
            LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(OrderDetailEntity::getOrderId, (Object)orderEntity.getId());
            List details = this.orderDetailService.list((Wrapper)lambda2);
            if (CollectionUtils.isNotEmpty((Collection)details)) {
                orderEntity.setPurchaseOrderDetail(details);
                Map<String, Long> map2 = details.stream().collect(Collectors.toMap(OrderDetailEntity::getHistoryId, BaseEntity::getId));
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    if (map2.containsKey(vo.getChildId())) {
                        vo.setId((Long)map2.get(vo.getChildId()));
                    }
                });
            }
        } else {
            orderEntity = (OrderEntity)((Object)super.selectById((Serializable)Long.valueOf(Long.parseLong(orderVO.getMainId()))));
            orderVO.setId(orderEntity.getId());
            if (CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())) {
                orderVO.getPurchaseOrderDetail().forEach(vo -> vo.setId(Long.valueOf(Long.parseLong(vo.getChildId()))));
            }
        }
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "cscec5b-wzxt-frontend/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        if (1 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(1);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 1);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if (!vo.getLeafFlag().booleanValue()) {
                        vo.setReceiveNumsSum(vo.getOrderNumsSum());
                        vo.setDeliverNumsSum(BigDecimal.ZERO);
                    }
                });
            }
        } else if (2 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(2);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 2);
                map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(BaseVO::getId, OrderDetailVO::getReceiveNumsSum));
                this.logger.debug("map------" + map);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum((BigDecimal)map.get(vo.getId()));
                    this.logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            orderEntity.setReceiveState(3);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 3);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if (!vo.getLeafFlag().booleanValue()) {
                        vo.setReceiveNumsSum(BigDecimal.ZERO);
                        vo.setDeliverNumsSum(BigDecimal.ZERO);
                    }
                });
            }
        }
        if (4 == orderVO.getReceiveState()) {
            orderEntity.setDeliverState(3);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u9000\u56de\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u9000\u56de\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.BackOrderDetail(orderVO.getPurchaseOrderDetail());
                map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(BaseVO::getId, OrderDetailVO::getBackNumsSum));
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if (!vo.getLeafFlag().booleanValue()) {
                        BigDecimal backOrderNumsSum = vo.getBackNumsSum() == null ? BigDecimal.ZERO : vo.getBackNumsSum();
                        BigDecimal backOrderNums = map.get(vo.getId()) == null ? BigDecimal.ZERO : (BigDecimal)map.get(vo.getId());
                        vo.setBackNumsSum(backOrderNumsSum.add(backOrderNums));
                    }
                });
            }
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        this.logger.debug("-----\u4e3b\u952e" + orderEntity.getId());
        super.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public CommonResponse<OrderVO> updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderVO.getId()));
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() >= 0) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        orderEntity.setReceiveState(2);
        orderEntity.setDeliverState(0);
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 2);
            orderEntity.getPurchaseOrderDetail().forEach(vo -> vo.setDeliverNumsSum(BigDecimal.ZERO));
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "cscec5b-wzxt-frontend/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        super.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public void OrderDetailBack(List<OrderDetailVO> detailList, int type) {
        ArrayList entityList = new ArrayList();
        ArrayList planDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getId())));
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                lambda.orderByAsc(BaseEntity::getId);
                List details = this.orderDetailService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum() == null ? BigDecimal.ZERO : vo.getReceiveNumsSum();
                    for (int i = 0; i < details.size(); ++i) {
                        BigDecimal nums;
                        BigDecimal occupyNums;
                        PlanDetailEntity planDetailEntity;
                        BigDecimal orderNumsSum;
                        BigDecimal bigDecimal = orderNumsSum = ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum() == null ? BigDecimal.ZERO : ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum();
                        if (receiveNumsSum.compareTo(BigDecimal.ZERO) > 0) {
                            if (receiveNumsSum.compareTo(orderNumsSum) >= 0) {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            } else {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(receiveNumsSum);
                                planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                                occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                                nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));
                            continue;
                        }
                        planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                        occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                        nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                        planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));
                        planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                        planDetailList.add(planDetailEntity);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                        this.orderDetailService.updateBatchById(entityList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)planDetailList)) {
                        this.planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }

    public void BackOrderDetail(List<OrderDetailVO> detailList) {
        ArrayList entityList = new ArrayList();
        ArrayList planDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getId())));
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                lambda.orderByAsc(BaseEntity::getId);
                List details = this.orderDetailService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    BigDecimal backNumsSum = vo.getBackNumsSum() == null ? BigDecimal.ZERO : vo.getBackNumsSum();
                    for (int i = 0; i < details.size(); ++i) {
                        BigDecimal nums;
                        BigDecimal occupyNums;
                        PlanDetailEntity planDetailEntity;
                        BigDecimal receiveNumsSum = ((OrderDetailEntity)((Object)((Object)details.get(i)))).getReceiveNumsSum() == null ? BigDecimal.ZERO : ((OrderDetailEntity)((Object)((Object)details.get(i)))).getReceiveNumsSum();
                        BigDecimal backOrderNumsSum = ((OrderDetailEntity)((Object)((Object)details.get(i)))).getBackNumsSum() == null ? BigDecimal.ZERO : ((OrderDetailEntity)((Object)((Object)details.get(i)))).getBackNumsSum();
                        BigDecimal orderNumsSum = receiveNumsSum.subtract(backOrderNumsSum);
                        if (backNumsSum.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (orderNumsSum.compareTo(backNumsSum) >= 0) {
                            ((OrderDetailEntity)((Object)((Object)details.get(i)))).setBackNumsSum(backOrderNumsSum.add(backNumsSum));
                            planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                            occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                            nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                            planDetailEntity.setOccupyNums(occupyNums.subtract(backNumsSum));
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                            planDetailList.add(planDetailEntity);
                            backNumsSum = BigDecimal.ZERO;
                        } else {
                            ((OrderDetailEntity)((Object)((Object)details.get(i)))).setBackNumsSum(backOrderNumsSum.add(orderNumsSum));
                            planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                            occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                            nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                            backNumsSum = backNumsSum.subtract(orderNumsSum);
                            planDetailList.add(planDetailEntity);
                        }
                        entityList.add(details.get(i));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                        this.orderDetailService.updateBatchById(entityList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)planDetailList)) {
                        this.planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }

    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)super.selectById((Serializable)id));
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        ArrayList listres = new ArrayList();
        List list = orderVO.getPurchaseOrderDetail();
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if (vo.getParentId().equals(999L)) {
                    listres.add(vo);
                }
            });
            listres.forEach(vo -> {
                ArrayList listd = new ArrayList();
                list.forEach(e -> {
                    if (vo.getTid().equals(e.getParentId())) {
                        listd.add(e);
                    }
                });
                vo.setChildren(listd);
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        return orderVO;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, OrderEntity orderEntity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4f9b\u65b9\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)(this.wjyPath + "cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id=" + orderEntity.getId() + "&userid={userid}"));
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> pushOrder(Map<String, String> headers, OrderEntity orderEntity) {
        String url = this.wjOrderUrl;
        Purchase purchase = new Purchase();
        purchase.setPkPurchase(String.valueOf(orderEntity.getId()));
        purchase.setPkOrg(orderEntity.getParentOrgSourceId());
        purchase.setPkProject(orderEntity.getProjectSourceId());
        purchase.setProjectName(orderEntity.getProjectName());
        purchase.setPurchaseCode(orderEntity.getBillCode());
        purchase.setPkSupplier(orderEntity.getSupplierSourceId());
        purchase.setSupplierName(orderEntity.getSupplierName());
        purchase.setPkContractPurchase(orderEntity.getContractId());
        purchase.setContractPurchaseName(orderEntity.getContractName());
        purchase.setContractPurchaseCode(orderEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setPurchaseCreateDate(formatter.format(orderEntity.getOrderCreateDate()));
        purchase.setPurchaseExpiryDate(formatter.format(orderEntity.getOrderExpiryDate()));
        purchase.setPurchaseLinkMan(orderEntity.getLinkName());
        purchase.setPurchaseLinkTelephone(orderEntity.getLinkTelephone());
        purchase.setBillStatus(Integer.valueOf(1));
        purchase.setPurchaseType(orderEntity.getOrderType());
        purchase.setIsConfirm(orderEntity.getIsConfirm());
        purchase.setPurchaseNote(orderEntity.getOrderNote());
        purchase.setPurchaseAddress(orderEntity.getOrderAddress());
        purchase.setPlanBody(orderEntity.getConstruction());
        purchase.setSmartStatus(Integer.valueOf(orderEntity.getSmartStatus() == null ? 0 : Integer.parseInt(orderEntity.getSmartStatus())));
        purchase.setPlatformType(orderEntity.getPlatformType());
        purchase.setPlatformCode(orderEntity.getPlatformCode());
        purchase.setSysmark("xpt");
        purchase.setPkCreator("xpt");
        purchase.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        purchase.setCreatorDate(DateFormater.getInstance().format("yyyy-MM-dd HH:mm:ss"));
        ArrayList<FileRelation> orderfileList = new ArrayList<FileRelation>();
        CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(orderEntity.getId(), "BT201028000000001", "gfUpload", null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
            List fileList = (List)fileResponse.getData();
            for (AttachmentVO fileVo : fileList) {
                FileRelation file = new FileRelation();
                file.setFileName(fileVo.getFileName());
                file.setFilePath(fileVo.getFilePath());
                file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                file.setFileBizPk(orderEntity.getId().toString());
                file.setDr(Integer.valueOf(0));
                file.setFileBiz("purchaseOrder");
                file.setBizType("1");
                orderfileList.add(file);
            }
        }
        purchase.setOrderfileList(orderfileList);
        if (CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())) {
            ArrayList list = new ArrayList();
            orderEntity.getPurchaseOrderDetail().forEach(e -> {
                if (!e.getLeafFlag().booleanValue()) {
                    PurchaseInfo vo = new PurchaseInfo();
                    vo.setPkPurchaseInfo(String.valueOf(e.getId()));
                    vo.setPkPurchase(String.valueOf(orderEntity.getId()));
                    vo.setPkMaterial(e.getMaterialSourceId());
                    vo.setMaterialCode(e.getMaterialCode());
                    vo.setMaterialName(e.getMaterialName());
                    vo.setMaterialSpec(e.getSpec());
                    vo.setMaterialType(e.getSpec());
                    vo.setMaterialMeasname(e.getUnit());
                    vo.setMaterialManufacturer(e.getMaterialManufacturer());
                    vo.setMaterialNote(e.getMemo());
                    vo.setPrice(e.getPrice());
                    vo.setTaxPrice(e.getTaxPrice());
                    vo.setTaxRate(e.getTaxRate());
                    vo.setWidth(e.getWidth());
                    vo.setHeight(e.getHeight());
                    vo.setLength(e.getLength());
                    vo.setSurface(e.getSurface());
                    vo.setColor(e.getColor());
                    vo.setColorNumber(e.getColorNumber());
                    vo.setTextureMaterial(e.getTextureMaterial());
                    vo.setWallThickness(e.getWallThickness());
                    vo.setBuildingNumber(e.getBuildingNumber());
                    vo.setPlanAmountSum(Double.valueOf(e.getPlanNumsSum() == null ? 0.0 : e.getPlanNumsSum().doubleValue()));
                    vo.setPlanUncheckAmountSum(Double.valueOf(e.getSurplusNumsSum() == null ? 0.0 : e.getSurplusNumsSum().doubleValue()));
                    vo.setStockAmountSum(Double.valueOf(e.getStockAmountSum() == null ? 0.0 : e.getStockAmountSum().doubleValue()));
                    vo.setPurchaseAmountSum(Double.valueOf(e.getOrderNumsSum() == null ? 0.0 : e.getOrderNumsSum().doubleValue()));
                    vo.setPurchaseCheckAmountSum(Double.valueOf(e.getReceiveNumsSum() == null ? 0.0 : e.getReceiveNumsSum().doubleValue()));
                    vo.setSmartStatus(Integer.valueOf(e.getSmartStatus() == null ? 0 : Integer.parseInt(e.getSmartStatus())));
                    list.add(vo);
                }
            });
            purchase.setPurchaseInfoList(list);
        }
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)purchase).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e2) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u8ba2\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public CommonResponse<String> pushDelOrder(Map<String, String> headers, OrderEntity orderEntity) {
        String url = this.wjDelOrderUrl;
        String pkPurchase = String.valueOf(orderEntity.getId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pkPurchase", pkPurchase);
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + pkPurchase);
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.get(url, map, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u8ba2\u5355\u5f02\u5e38!");
        }
    }
}

