package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.ComplexParam;
import com.sun.org.apache.regexp.internal.RE;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.Na;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.acl.LastOwnerException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.service.ITemplateService;

import javax.annotation.Resource;

/**
 * 物资验收模板实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("template")
public class TemplateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITemplateService service;

    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IBillCodeApi billCodeApi;

    @Autowired
    private SessionManager sessionManager;

    @Resource
    private IMaterialApi iMaterialApi;

    private static final String billCodeRule = "CSCEC5B_WZXT_WZMB";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO saveorUpdateVO) {

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<TemplateEntity> templateEntityList = service.queryList(param);
        List<String> billcodelist = new ArrayList<>();
        templateEntityList.stream().map(TemplateEntity::getBillCode).forEach(billcode -> billcodelist.add(billcode));
        boolean b = billcodelist.stream().anyMatch(s -> s.equals(saveorUpdateVO.getBillCode()));
        if (b){
            return CommonResponse.error("清单编码不能重复！",new Exception());
        }

        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
        }
        TemplateEntity entity = BeanMapper.map(saveorUpdateVO, TemplateEntity.class);

        entity.setOrgId(InvocationInfoProxy.getOrgId());

        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        //获取组织
        entity.setOrgName(data.getName());
        entity.setOrgSourceId(data.getSourceId());
        entity.setParentOrgId(data.getParentId());

        //获取组织人
        Long userId = sessionManager.getUserContext().getUserId();
        String userName = sessionManager.getUserContext().getUserName();
        entity.setEmployeeName(userName);
        entity.setEmployeeId(userId);

        //entity.setEmployeeId(InvocationInfoProxy.getEmployeeId());
        //entity.setEmployeeName();
        service.saveOrUpdate(entity, false);
        TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);


        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
    	TemplateEntity entity = service.selectById(id);
    	TemplateVO vo = BeanMapper.map(entity, TemplateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     *
     * 通过项目ID物资ID查询模板详情
     * */
    @RequestMapping("/queryTemplateDetail")
    @ResponseBody
    public CommonResponse<List<TemplateVO>>queryTemplateDetail(
           @RequestParam(value = "projectId") Long projectId,
           @RequestParam(value = "materialId")Long materialId
    ){

        List<com.ejianc.business.wzxt.vo.TemplateVO> templateVOS = service.queryTemplateDetail(projectId, materialId);

        if (CollectionUtils.isEmpty(templateVOS)){
            return CommonResponse.error("未找到对应数据");
        }
        return  CommonResponse.success("详情查询成功",templateVOS);
    }
    @RequestMapping
    @ResponseBody
    public CommonResponse<String>queryMaterialTypeById(@RequestParam(value = "materialTypeId")Long materialTypeId){

        TemplateEntity typeId = service.getById(materialTypeId);

        if (typeId==null){
            return CommonResponse.error("数据不存在");
        }
        return CommonResponse.success("查询成功");
    }


    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        service.removeByIds(vos.stream().map(TemplateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateCode");
        fuzzyFields.add("templateName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ComplexParam> complexParams = param.getComplexParams();
        if (complexParams!=null && complexParams.size()>0) {
            Map<String, Parameter> tt = complexParams.get(0).getParams();
            if (tt.containsKey("materialTypeId")) {
                //移动端获取materialTypeId参数后，进行转换为所有父级IDs
                List<Long> materialTypeIds = (List<Long>) param.getParams().get("materialTypeId");
                CommonResponse<List<MaterialCategoryVO>> listCommonResponse = iMaterialApi.queryCategoryListByChildren(materialTypeIds);
                List<MaterialCategoryVO> MaterialCategoryVOs = listCommonResponse.getData();
                List<Long> materialTypepks = MaterialCategoryVOs.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                tt.put("materialTypeId", new Parameter(QueryParam.IN, materialTypepks));
            }
        }
        IPage<TemplateEntity> page = service.queryPage(param,false);
        IPage<TemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemplateVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
