/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.service.ITemplateService;
import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"template"})
public class TemplateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITemplateService service;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IMaterialApi iMaterialApi;
    private static final String billCodeRule = "CSCEC5B_WZXT_WZMB";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List templateEntityList = this.service.queryList(param);
        ArrayList billcodelist = new ArrayList();
        templateEntityList.stream().map(TemplateEntity::getBillCode).forEach(billcode -> billcodelist.add(billcode));
        boolean b = billcodelist.stream().anyMatch(s -> s.equals(saveorUpdateVO.getBillCode()));
        if (b) {
            return CommonResponse.error((String)"\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01", (Throwable)new Exception());
        }
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode()) && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode((String)codeBatchByRuleCode.getData());
        }
        TemplateEntity entity = (TemplateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TemplateEntity.class));
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        OrgVO data = (OrgVO)this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        entity.setOrgName(data.getName());
        entity.setOrgSourceId(data.getSourceId());
        entity.setParentOrgId(data.getParentId());
        Long userId = this.sessionManager.getUserContext().getUserId();
        String userName = this.sessionManager.getUserContext().getUserName();
        entity.setEmployeeName(userName);
        entity.setEmployeeId(userId);
        this.service.saveOrUpdate((Object)entity, false);
        TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
        TemplateEntity entity = (TemplateEntity)((Object)this.service.selectById(id));
        TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTemplateDetail"})
    @ResponseBody
    public CommonResponse<List<TemplateVO>> queryTemplateDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="materialId") Long materialId) {
        List<TemplateVO> templateVOS = this.service.queryTemplateDetail(projectId, materialId);
        if (CollectionUtils.isEmpty(templateVOS)) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return CommonResponse.success((String)"\u8be6\u60c5\u67e5\u8be2\u6210\u529f", templateVOS);
    }

    @RequestMapping
    @ResponseBody
    public CommonResponse<String> queryMaterialTypeById(@RequestParam(value="materialTypeId") Long materialTypeId) {
        TemplateEntity typeId = (TemplateEntity)((Object)this.service.getById(materialTypeId));
        if (typeId == null) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        Map tt;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateCode");
        fuzzyFields.add("templateName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List complexParams = param.getComplexParams();
        if (complexParams != null && complexParams.size() > 0 && (tt = ((ComplexParam)complexParams.get(0)).getParams()).containsKey("materialTypeId")) {
            List materialTypeIds = (List)param.getParams().get("materialTypeId");
            CommonResponse listCommonResponse = this.iMaterialApi.queryCategoryListByChildren(materialTypeIds);
            List MaterialCategoryVOs = (List)listCommonResponse.getData();
            List materialTypepks = MaterialCategoryVOs.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
            tt.put("materialTypeId", new Parameter("in", materialTypepks));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

