package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.TemplateMapper;
import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.service.ITemplateService;

import javax.annotation.Resource;
import java.util.List;

/**
 * 物资验收模板实体
 *
 * @author generator
 *
 */
@Service("templateService")
public class TemplateServiceImpl extends BaseServiceImpl<TemplateMapper, TemplateEntity> implements ITemplateService{

    @Resource
    private IBillCodeApi billCodeApi;//编码API接口
    @Autowired
    private ITemplateService templateService;
    @Resource
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IMaterialApi iMaterialApi;

    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";
    @Override
    public List<TemplateVO> queryTemplateDetail(Long projectId, Long materialId) {

        List<TemplateVO> templateDetailList = baseMapper.queryTemplateDetail(projectId, materialId);

        return templateDetailList;
    }

    @Override
    public CommonResponse<TemplateVO> saveOrUpdate(TemplateVO templateVO) {

        Long tenantId= InvocationInfoProxy.getTenantid();
        TemplateEntity entity = BeanMapper.map(templateVO, TemplateEntity.class);

        List<TemplateEntity> entities=null;
        if (StringUtils.isEmpty(templateVO.getBillCode())){         //如果编码为空自动生成
            CommonResponse<String>billCode=billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE,tenantId);
            if (billCode.isSuccess()){
                entity.setBillCode(billCode.getData());
            }else {
                throw new BusinessException("网络异常，生成编码失效，请稍后重试");
            }
        }
        if (templateVO.getId()!=null && templateVO.getId()>0){//   修改  校验编号是否重复
            LambdaQueryWrapper<TemplateEntity> lambda= Wrappers.<TemplateEntity>lambdaQuery();
            lambda.eq(TemplateEntity::getBillCode,templateVO.getBillCode());
            lambda.eq(TemplateEntity::getTenantId,tenantId);
            lambda.ne(TemplateEntity::getId,templateVO.getId());
             entities= super.list(lambda);
            QueryParam queryParam=new QueryParam();
            queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code",new Parameter(QueryParam.EQ,templateVO.getBillCode()));
            queryParam.getParams().put("contract_id",new Parameter(QueryParam.NE,templateVO.getId()));

        }else {
            //校验编码是否重复
            LambdaQueryWrapper<TemplateEntity>lambda=Wrappers.<TemplateEntity>lambdaQuery();
            lambda.eq(TemplateEntity::getTenantId,tenantId);
            lambda.eq(TemplateEntity::getBillCode,templateVO.getBillCode());
            entities=super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,templateVO.getBillCode()));
        }
        if (entities!=null && entities.size()>0){
            throw new BusinessException("存在相同编码，不允许保存");
        }

        TemplateEntity entityOrg = BeanMapper.map(templateVO, TemplateEntity.class);

        entity.setOrgId(InvocationInfoProxy.getOrgId());

        OrgVO data = iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        //获取组织
        entity.setOrgName(data.getName());
        entity.setOrgSourceId(data.getSourceId());
        entity.setParentOrgId(data.getParentId());

        //获取组织人
        Long userId = sessionManager.getUserContext().getUserId();
        String userName = sessionManager.getUserContext().getUserName();
        entity.setEmployeeName(userName);
        entity.setEmployeeId(userId);
        super.saveOrUpdate(entity,false);
        

        return CommonResponse.success(BeanMapper.map(entity,TemplateVO.class));
    }

}
