/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.mapper.TemplateMapper;
import com.ejianc.business.wzxt.service.ITemplateService;
import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="templateService")
public class TemplateServiceImpl
extends BaseServiceImpl<TemplateMapper, TemplateEntity>
implements ITemplateService {
    @Resource
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITemplateService templateService;
    @Resource
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IMaterialApi iMaterialApi;
    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";

    @Override
    public List<TemplateVO> queryTemplateDetail(Long projectId, Long materialId) {
        List<TemplateVO> templateDetailList = ((TemplateMapper)this.baseMapper).queryTemplateDetail(projectId, materialId);
        return templateDetailList;
    }

    @Override
    public CommonResponse<TemplateVO> saveOrUpdate(TemplateVO templateVO) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        TemplateEntity entity = (TemplateEntity)((Object)BeanMapper.map((Object)templateVO, TemplateEntity.class));
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)templateVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u751f\u6210\u7f16\u7801\u5931\u6548\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        if (templateVO.getId() != null && templateVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(TemplateEntity::getBillCode, (Object)templateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)templateVO.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)templateVO.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)templateVO.getId()));
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(TemplateEntity::getBillCode, (Object)templateVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)templateVO.getBillCode()));
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
        }
        TemplateEntity entityOrg = (TemplateEntity)((Object)BeanMapper.map((Object)templateVO, TemplateEntity.class));
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        OrgVO data = (OrgVO)this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData();
        entity.setOrgName(data.getName());
        entity.setOrgSourceId(data.getSourceId());
        entity.setParentOrgId(data.getParentId());
        Long userId = this.sessionManager.getUserContext().getUserId();
        String userName = this.sessionManager.getUserContext().getUserName();
        entity.setEmployeeName(userName);
        entity.setEmployeeId(userId);
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), TemplateVO.class));
    }
}

