package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.MathUtil;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.business.wzxt.vo.sync.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/zjwjsync/")
public class ZjwjSyncApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${mro.addr}")
	private String addr;

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IProjectApi projectApi;

	@Autowired
	private IUserApi userApi;

	@Autowired
	private IMaterialApi materialApi;

	@Autowired
	private IControlPlanService controlPlanService;

	@Autowired
	private IControlPlanDetailService controlPlanDetailService;

	@Autowired
	private ICtPlanService ctPlanService;

	@Autowired
	private ICtPlanDetailService ctPlanDetailService;

	@Autowired
	private IMroProjectService mroProjectService;

	@Autowired
	private IProjectConfigureService projectConfigureService;

	@Autowired
	private IDeliveryService deliveryService;

	@Autowired
	private IPlanService planService;

	@Autowired
	private IPlanDetailService planDetailService;

	@Autowired
	private ThirdSystemUtils thirdSystemUtils;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	/**
	 * 同步总控计划主表
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanList")
	public CommonResponse<String> syncControlPlanList(@RequestBody List<SyncControlPlanVO> controlPlanVOS) {
		List<ControlPlanEntity> entityList = new ArrayList<>();
		for(SyncControlPlanVO syncVO : controlPlanVOS) {
			ControlPlanVO vo = syncVO.getValue();
			ControlPlanEntity entity = BeanMapper.map(vo, ControlPlanEntity.class);
			entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
			LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(ControlPlanEntity::getSourceId, vo.getSourceId());
			ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
			if(null == dbEntity){
				//新增
				entity.setId(IdWorker.getId());

			}else {
				entity.setId(dbEntity.getId());
			}

			if(entity.getParentOrgSourceId() != null){
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getParentOrgSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setParentOrgId(orgVO.getId());
				}
			}

			if(entity.getProjectSourceId() != null){
				CommonResponse<ProjectRegisterVO> registerVOCommonResponse = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
				if(registerVOCommonResponse.isSuccess()){
					ProjectRegisterVO projectRegisterVO = registerVOCommonResponse.getData();
					entity.setProjectId(projectRegisterVO.getId());
					entity.setProjectName(projectRegisterVO.getName());
				}
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getProjectSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setOrgId(orgVO.getId());
					entity.setOrgSourceId(orgVO.getSourceId());
					entity.setOrgName(orgVO.getName());
				}
			}

			if(syncVO.getSourceEmployeeId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceEmployeeId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setEmployeeId(userVO.getId());
					entity.setEmployeeName(userVO.getUserName());
				}
			}

			if(syncVO.getSourceCreatorId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceCreatorId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setCreateUserCode(userVO.getUserCode());
				}
			}
			entityList.add(entity);
		}
		//必须单条保存.......
		controlPlanService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表头开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表头成功！");
	}


	/**
	 * @describe 同步总控计划表体
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "syncControlPlanDetailList")
	public CommonResponse<String> syncControlPlanDetailList(@RequestBody  List<SyncControlPlanDetailVO> controlPlanDetailVOS) {
		List<ControlPlanDetailEntity> entityList = new ArrayList<>();
		for(SyncControlPlanDetailVO syncVO : controlPlanDetailVOS) {
			ControlPlanDetailVO vo = syncVO.getValue();
			ControlPlanDetailEntity entity = BeanMapper.map(vo, ControlPlanDetailEntity.class);
			LambdaQueryWrapper<ControlPlanDetailEntity> queryDetailWrapper = new LambdaQueryWrapper<>();
			queryDetailWrapper.eq(ControlPlanDetailEntity::getSourceId, vo.getSourceId());
			ControlPlanDetailEntity dbDetaliEntity = controlPlanDetailService.getOne(queryDetailWrapper, false);
			if(null == dbDetaliEntity){
				//新增
				entity.setId(IdWorker.getId());
			}else {
				entity.setId(dbDetaliEntity.getId());
			}


			if(syncVO.getSourceControlId() != null){
				LambdaQueryWrapper<ControlPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(ControlPlanEntity::getSourceId, syncVO.getSourceControlId());
				ControlPlanEntity dbEntity = controlPlanService.getOne(queryWrapper, false);
				entity.setControlId(dbEntity != null ? dbEntity.getId() : null);
			}

			if(vo.getMaterialSourceId() != null){
				CommonResponse<MaterialVO> materialVOCommonResponse = materialApi.queryMaterialBySourceId(vo.getMaterialSourceId());
				if(materialVOCommonResponse.isSuccess()){
					MaterialVO materialVO = materialVOCommonResponse.getData();
					entity.setMaterialId(materialVO.getId());
					entity.setMaterialCode(materialVO.getCode());
					entity.setMaterialName(materialVO.getName());
					entity.setUnit(materialVO.getUnitName());
					entity.setSpec(materialVO.getSpec());
					entity.setDef1(materialVO.getDef1());//规格
					entity.setDef2(materialVO.getDef2());//型号
					entity.setDef3(materialVO.getDef3());//来源物料主键
					entity.setMaterialTypeId(materialVO.getCategoryId());


					CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = materialApi.queryCategoryById(materialVO.getCategoryId());
					if(materialCategoryVOCommonResponse.isSuccess()){
						MaterialCategoryVO materialCategoryVO = materialCategoryVOCommonResponse.getData();
						entity.setMaterialTypeName(materialCategoryVO.getName());
						entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
					}
				}
			}

			entityList.add(entity);
		}
		controlPlanDetailService.saveOrUpdateBatch(entityList);
		logger.info("保存总控计划表体开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存总控计划表体成功！");
	}

	/**
	 * 同步MRO项目
	 * @return
	 */
	@GetMapping(value = "syncMroProjectList")
	public CommonResponse<String> syncMroProjectList() {
		Map<String, String> headers = new HashMap<>();
		List<Long> messagePkList = new ArrayList<>();
		JSONArray jsonArray = getMessageList(headers, 7001);
		if(null != jsonArray && jsonArray.size() > 0){
			for (int i = 0; i < jsonArray.size(); i++) {
				JSONObject jsonObject = jsonArray.getJSONObject(i);
				messagePkList.add(jsonObject.getLong("id"));
				Object result = jsonObject.get("result");
				if (null != result) {
					List<Long> mroProjPkList = (List<Long>) result;
					syncMroProjectBatch(headers, mroProjPkList);
				}
			}
		}

		if(CollectionUtils.isNotEmpty(messagePkList)){
			deleteMessageList(headers, messagePkList);
		}

		return CommonResponse.success("保存MRO项目成功！");
	}

	private void syncMroProjectBatch(Map<String, String> headers, List<Long> mroProjPkList){
		thirdSystemUtils.getMroSign(headers);
		String initContextUrl = addr + "/iec/v1/project/details";
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, JSONObject.toJSONString(mroProjPkList), headers);
			JSONObject json = JSONObject.parseObject(responseStr);
			logger.info("project/details " + json.toJSONString());
			if(200 == json.getInteger("code") && true == json.getBoolean("success")){
				JSONArray jsonArray =  json.getJSONArray("data");
				if(null != jsonArray && jsonArray.size() > 0){
					List<MroProjectEntity> entityList = new ArrayList<>();
					List<String> sourceDeleteList = new ArrayList<>();
					for (int i = 0; i < jsonArray.size(); i++) {
						JSONObject js = jsonArray.getJSONObject(i);
						SyncMroProjectVO syncMroProjectVO = new SyncMroProjectVO();
						syncMroProjectVO.setSourceId(js.getString("id"));
						syncMroProjectVO.setSysStatus(js.getInteger("sysStatus"));
						syncMroProjectVO.setName(js.getString("name"));
						syncMroProjectVO.setOrganizationName(js.getString("organizationName"));
						if (-128 == syncMroProjectVO.getSysStatus()) {
							sourceDeleteList.add(syncMroProjectVO.getSourceId());
						}else if(1 == syncMroProjectVO.getSysStatus()){
							LambdaQueryWrapper<MroProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
							queryWrapper.eq(MroProjectEntity::getSourceId, syncMroProjectVO.getSourceId());
							MroProjectEntity dbMroProjectEntity = mroProjectService.getOne(queryWrapper, false);
							if (null == dbMroProjectEntity) {
								dbMroProjectEntity = new MroProjectEntity();
								dbMroProjectEntity.setSourceId(syncMroProjectVO.getSourceId());
								dbMroProjectEntity.setName(syncMroProjectVO.getName());
								dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
								dbMroProjectEntity.setId(IdWorker.getId());
							}else{
								dbMroProjectEntity.setName(syncMroProjectVO.getName());
								dbMroProjectEntity.setOrganizationName(syncMroProjectVO.getOrganizationName());
							}
							entityList.add(dbMroProjectEntity);
						}
					}

					if(CollectionUtils.isNotEmpty(entityList)){
						mroProjectService.saveOrUpdateBatch(entityList);
					}

					if (CollectionUtils.isNotEmpty(sourceDeleteList)) {
						LambdaQueryWrapper<MroProjectEntity> deleteWrapper = new LambdaQueryWrapper<>();
						deleteWrapper.in(MroProjectEntity::getSourceId, sourceDeleteList);
						mroProjectService.remove(deleteWrapper, false);

						LambdaQueryWrapper<ProjectConfigureEntity> deleteWrapper1 = new LambdaQueryWrapper<>();
						deleteWrapper1.in(ProjectConfigureEntity::getMroProjectSourceId, sourceDeleteList);
						projectConfigureService.remove(deleteWrapper1, false);
					}
					logger.info("保存MRO项目开始--------》》》"+ entityList.size());
				}
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+ JSONObject.toJSONString(e));
		}
	}

	/**
	 * 同步MRO发货单
	 * @return
	 */
	@GetMapping(value = "syncMroDeliveryList")
	public CommonResponse<String> syncMroDeliveryList() {
		Map<String, String> headers = new HashMap<>();
		List<Long> messagePkList = new ArrayList<>();
		JSONArray jsonArray = getMessageList(headers, 2055);
		if(null != jsonArray && jsonArray.size() > 0){
			for (int i = 0; i < jsonArray.size(); i++) {
				JSONObject jsonObject = jsonArray.getJSONObject(i);
				JSONObject result = jsonObject.getJSONObject("result");
				if (null != result && syncMroDelivery(headers, result.getString("deliveryCode"))) {
					messagePkList.add(jsonObject.getLong("id"));
				}
			}
		}

		if(CollectionUtils.isNotEmpty(messagePkList)){
			deleteMessageList(headers, messagePkList);
		}

		return CommonResponse.success("保存发货单成功！");
	}

	private boolean syncMroDelivery(Map<String, String> headers, String deliveryCode){
		boolean flag = true;
		thirdSystemUtils.getMroSign(headers);
		String initContextUrl = addr + "/iec/v1/purchase_plan/delivery/detail/" + deliveryCode;
		try {
			String responseStr = HttpTookit.get(initContextUrl, new HashMap<>(), headers);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("code") && true == json.getBoolean("success")){
				logger.info("delivery is " + json.toJSONString());
				SyncMroDeliveryVO mroDeliveryVO = JSON.parseObject(json.getString("data"), SyncMroDeliveryVO.class);
				LambdaQueryWrapper<DeliveryEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(DeliveryEntity::getMroDeliveryCode, mroDeliveryVO.getDeliveryCode());
				List<DeliveryEntity> deliveryEntities = deliveryService.list(queryWrapper);
				DeliveryEntity deliveryEntity = CollectionUtils.isNotEmpty(deliveryEntities) ? deliveryService.selectById(deliveryEntities.get(0).getId()) : new DeliveryEntity();

				if (!changeMroToDelivery(deliveryEntity, mroDeliveryVO)) {
					return   false;
				}

				flag = deliveryService.saveOrUpdate(deliveryEntity,false);

				logger.info("保存发货单--------》》》");
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+e.getMessage());
			flag = false;
		}
		return flag;
	}

	private boolean  changeMroToDelivery(DeliveryEntity deliveryEntity, SyncMroDeliveryVO mroDeliveryVO){
		if(null != deliveryEntity.getDeliverState() && 0 != deliveryEntity.getDeliverState()){
			return false;
		}
		LambdaQueryWrapper<PlanEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(PlanEntity::getBillCode, mroDeliveryVO.getDemandCode());
		PlanEntity planEntity = planService.getOne(wrapper, false);
		if(null == planEntity){
			logger.info("该编号无对应计划");
			return  false;
		}
		if(null == deliveryEntity.getId()){
			deliveryEntity.setPlanId(planEntity.getId());
			deliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
			deliveryEntity.setDeliverState(1);
			deliveryEntity.setSmartStatus("0");
			deliveryEntity.setCloseStatus("0");
			deliveryEntity.setProjectId(planEntity.getProjectId());
			deliveryEntity.setProjectName(planEntity.getProjectName());
			deliveryEntity.setProjectSourceId(planEntity.getProjectSourceId());
			deliveryEntity.setParentOrgId(planEntity.getParentOrgId());
			deliveryEntity.setParentOrgSourceId(planEntity.getParentOrgSourceId());
			deliveryEntity.setOrgId(planEntity.getOrgId());
			deliveryEntity.setOrgName(planEntity.getOrgName());
			deliveryEntity.setOrgSourceId(planEntity.getOrgSourceId());
			deliveryEntity.setConstruction(planEntity.getConstruction());
			deliveryEntity.setSupplierId(Long.valueOf("1336866881390252033"));
			deliveryEntity.setSupplierSourceId("1129H6100000015L6YTE");
			deliveryEntity.setSupplierName("中建电子商务有限责任公司");
			deliveryEntity.setMaterialType(MaterialTypeEnum.MRO.getCode());
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
		try {
			deliveryEntity.setDeliveryDate(formatter.parse(mroDeliveryVO.getShipDate()));
		} catch (ParseException e) {
			logger.error(e.getMessage());
		}
		deliveryEntity.setBillCode(mroDeliveryVO.getDeliveryCode());
		deliveryEntity.setOrderBillCode(mroDeliveryVO.getOrderCode());
		deliveryEntity.setMroDeliveryCode(mroDeliveryVO.getDeliveryCode());

		Map<Long, DeliveryDetailEntity> map = new HashMap<>();
		if(CollectionUtils.isNotEmpty(deliveryEntity.getDeliveryDetail())){
			map = deliveryEntity.getDeliveryDetail().stream().collect(Collectors.toMap(DeliveryDetailEntity::getPlanDetailId, Function.identity(), (key1, key2) -> key2));
		}

		List<String> stringList = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(mroDeliveryVO.getDetailList())){
			List<DeliveryDetailEntity> detailEntityList = new ArrayList<>();
			for(SyncMroDeliveryDetailVO detail : mroDeliveryVO.getDetailList()){
				DeliveryDetailEntity detailEntity = null;
				if (map.containsKey(Long.parseLong(detail.getThirdId()))) {
					detailEntity = map.get(Long.parseLong(detail.getThirdId()));
				} else {
					detailEntity = new DeliveryDetailEntity();
					PlanDetailEntity planDetailEntity = planDetailService.selectById(detail.getThirdId());
					detailEntity.setPlanDetailId(planDetailEntity.getId());
					detailEntity.setMaterialId(planDetailEntity.getMaterialId());
					detailEntity.setMaterialCode(planDetailEntity.getMaterialCode());
					detailEntity.setMaterialName(planDetailEntity.getMaterialName());
					detailEntity.setMaterialTypeId(planDetailEntity.getMaterialTypeId());
					detailEntity.setMaterialTypeName(planDetailEntity.getMaterialTypeName());
					detailEntity.setMaterialSourceId(planDetailEntity.getMaterialSourceId());
					detailEntity.setUnit(planDetailEntity.getUnit());
					detailEntity.setSpec(planDetailEntity.getSpec());
					detailEntity.setSmartStatus("0");
				}
				stringList.add(detailEntity.getMaterialName());
				detailEntity.setMroTaxrate(MathUtil.safeMultiply(detail.getTaxRate(), BigDecimal.valueOf(100)));
				detailEntity.setMroDeliverNumsSum(detail.getShipQuantity());
				detailEntity.setMroMny(detail.getTotalExcludeAmount());
				detailEntity.setMroNprice(detail.getExcludeSalesPrice());
				detailEntity.setMroNtaxprice(detail.getSalesPrice());
				detailEntity.setMroSupplierSkuCode(detail.getSupplierSkuCode());
				detailEntity.setMroSupplierSkuId(detail.getSupplierSkuId());
				detailEntity.setMroTaxmny(detail.getTotalAmount());
				detailEntity.setMroTax(MathUtil.safeSub(detailEntity.getMroTaxmny(), detailEntity.getMroMny()));
				detailEntity.setMroUnit(detail.getUnitName());
				detailEntity.setMroUnitRatio(MathUtil.safeDiv(detail.getDemandQuantity(), detail.getQuantity()));

				detailEntity.setDeliverNumsSum(MathUtil.safeMultiply(detailEntity.getMroDeliverNumsSum(), detailEntity.getMroUnitRatio()));

				detailEntityList.add(detailEntity);
			}

			deliveryEntity.setMaterialName(StringUtils.join(stringList, ","));
			deliveryEntity.setDeliveryDetail(detailEntityList);
		}
		return true;
	}


	/**
	 * 消息拉取
	 * @param headers
	 * @param type int64 消息类型
	 * @return
	 */
	private JSONArray getMessageList(Map<String, String> headers, Integer type){
		thirdSystemUtils.getMroSign(headers);
		String initContextUrl = addr + "/iec/v1/message/list";
		logger.info("addr " + initContextUrl);
		logger.info("headers " + JSONObject.toJSONString(headers));
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("type", type);
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers);
			logger.info("message/list " + responseStr);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("code") && true == json.getBoolean("success")){
				return json.getJSONArray("data");
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("Exception 异常"+ e.getMessage());
		}
		return  null;
	}

	/**
	 * 消息删除
	 * @param headers
	 * @param messagePkList   int64 待删除消息id集合
	 */
	private void deleteMessageList(Map<String, String> headers, List<Long> messagePkList){
		thirdSystemUtils.getMroSign(headers);
		String initContextUrl = addr + "/iec/v1/message/delete";
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("ids", messagePkList);
		try {
			String responseStr = HttpTookit.postByJson(initContextUrl, jsonObject.toJSONString(), headers);
			JSONObject json = JSONObject.parseObject(responseStr);
			if(200 == json.getInteger("code") && true == json.getBoolean("success")){
				logger.info("消息删除成功");
			}else{
				logger.info(json.toJSONString());
			}
		} catch (Exception e) {
			logger.info("IOException 异常"+ JSONObject.toJSONString(e));
		}
	}


	/**
	 * 同步消耗材总控计划主表
	 * @param ctPlanVOS
	 * @return
	 */
	@PostMapping(value = "syncCtPlanList")
	public CommonResponse<String> syncCtPlanList(@RequestBody List<SyncCtPlanVO> ctPlanVOS) {
		List<CtPlanEntity> entityList = new ArrayList<>();
		for(SyncCtPlanVO syncVO : ctPlanVOS) {
			CtPlanVO vo = syncVO.getValue();
			CtPlanEntity entity = BeanMapper.map(vo, CtPlanEntity.class);
			entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
			LambdaQueryWrapper<CtPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(CtPlanEntity::getSourceId, vo.getSourceId());
			CtPlanEntity dbEntity = ctPlanService.getOne(queryWrapper, false);
			if(null == dbEntity){
				//新增
				entity.setId(IdWorker.getId());

			}else {
				entity.setId(dbEntity.getId());
			}

			if(entity.getParentOrgSourceId() != null){
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getParentOrgSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setParentOrgId(orgVO.getId());
				}
			}

			if(entity.getProjectSourceId() != null){
				CommonResponse<ProjectRegisterVO> registerVOCommonResponse = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
				if(registerVOCommonResponse.isSuccess()){
					ProjectRegisterVO projectRegisterVO = registerVOCommonResponse.getData();
					entity.setProjectId(projectRegisterVO.getId());
					entity.setProjectName(projectRegisterVO.getName());
				}
				CommonResponse<OrgVO> orgVOCommonResponse = orgApi.findBySourceId(entity.getProjectSourceId());
				if(orgVOCommonResponse.isSuccess()){
					OrgVO orgVO = orgVOCommonResponse.getData();
					entity.setOrgId(orgVO.getId());
					entity.setOrgSourceId(orgVO.getSourceId());
					entity.setOrgName(orgVO.getName());
				}
			}

			if(syncVO.getSourceEmployeeId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceEmployeeId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setEmployeeId(userVO.getId());
					entity.setEmployeeName(userVO.getUserName());
				}
			}

			if(syncVO.getSourceCreatorId() != null){
				CommonResponse<UserVO> userVOCommonResponse = userApi.findUserBySourceId(syncVO.getSourceCreatorId());
				if(userVOCommonResponse.isSuccess()){
					UserVO userVO = userVOCommonResponse.getData();
					entity.setCreateUserCode(userVO.getUserCode());
				}
			}
			entityList.add(entity);
		}
		//必须单条保存.......
		ctPlanService.saveOrUpdateBatch(entityList);
		logger.info("保存消耗材总控计划表头开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存消耗材总控计划表头成功！");
	}


	/**
	 * @describe 同步消耗材总控计划表体
	 * @param ctPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "syncCtPlanDetailList")
	public CommonResponse<String> syncCtPlanDetailList(@RequestBody  List<SyncCtPlanDetailVO> ctPlanDetailVOS) {
		List<CtPlanDetailEntity> entityList = new ArrayList<>();
		for(SyncCtPlanDetailVO syncVO : ctPlanDetailVOS) {
			CtPlanDetailVO vo = syncVO.getValue();
			CtPlanDetailEntity entity = BeanMapper.map(vo, CtPlanDetailEntity.class);
			LambdaQueryWrapper<CtPlanDetailEntity> queryDetailWrapper = new LambdaQueryWrapper<>();
			queryDetailWrapper.eq(CtPlanDetailEntity::getSourceId, vo.getSourceId());
			CtPlanDetailEntity dbDetaliEntity = ctPlanDetailService.getOne(queryDetailWrapper, false);
			if(null == dbDetaliEntity){
				//新增
				entity.setId(IdWorker.getId());
			}else {
				entity.setId(dbDetaliEntity.getId());
			}


			if(syncVO.getSourceControlId() != null){
				LambdaQueryWrapper<CtPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(CtPlanEntity::getSourceId, syncVO.getSourceControlId());
				CtPlanEntity dbEntity = ctPlanService.getOne(queryWrapper, false);
				entity.setCtId(dbEntity != null ? dbEntity.getId() : null);
			}

			if(vo.getMaterialSourceId() != null){
				CommonResponse<MaterialVO> materialVOCommonResponse = materialApi.queryMaterialBySourceId(vo.getMaterialSourceId());
				if(materialVOCommonResponse.isSuccess()){
					MaterialVO materialVO = materialVOCommonResponse.getData();
					entity.setMaterialId(materialVO.getId());
					entity.setMaterialCode(materialVO.getCode());
					entity.setMaterialName(materialVO.getName());
					entity.setUnit(materialVO.getUnitName());
					entity.setSpec(materialVO.getSpec());
					entity.setDef1(materialVO.getDef1());//规格
					entity.setDef2(materialVO.getDef2());//型号
					entity.setDef3(materialVO.getDef3());//来源物料主键
					entity.setMaterialTypeId(materialVO.getCategoryId());


					CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = materialApi.queryCategoryById(materialVO.getCategoryId());
					if(materialCategoryVOCommonResponse.isSuccess()){
						MaterialCategoryVO materialCategoryVO = materialCategoryVOCommonResponse.getData();
						entity.setMaterialTypeName(materialCategoryVO.getName());
						entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
					}
				}
			}

			entityList.add(entity);
		}
		ctPlanDetailService.saveOrUpdateBatch(entityList);
		logger.info("保存消耗材总控计划表体开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存消耗材总控计划表体成功！");
	}

	/**
	 * @describe 同步消耗材总控计划表体
	 * @return
	 */
	@GetMapping(value = "syncCtPlanDetailListToDb")
	public CommonResponse<String> syncCtPlanDetailListToDb(@RequestParam(required = false) String tenantId, @RequestParam(required = false) String systemId, @RequestParam(required = false) String pkCorp) {
		logger.info("消耗材总控计划表体开始--------》》》"  + new Date());
		List<String> pkList = new ArrayList<>();
		if(StringUtils.isNotBlank(pkCorp)){
			pkList.add(pkCorp);
		}else{
			CommonResponse<List<String>> orgResponse = orgApi.findMainOrgByTenantId(Long.valueOf(tenantId));
			pkList = orgResponse.getData();
		}
		List<CtPlanDetailEntity> entityList = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(pkList)) {
			for (String pk : pkList) {
				if (StringUtils.isBlank(pk)) {
					continue;
				}
				if(redisTemplate.opsForValue().get(pk + "###ctplan") != null){
					String jsonString = (String) redisTemplate.opsForValue().get(pk + "###ctplan");
					JSONArray jsonArray = JSONObject.parseArray(jsonString);
					if(null != jsonArray && !jsonArray.isEmpty()){
						logger.info(pk + "消耗材总控计划有 " + jsonArray.size());
						for (int i = 0; i < jsonArray.size() ; i++) {
							JSONObject jsonObject = (JSONObject) jsonArray.get(i);
							CtPlanDetailEntity entity = new CtPlanDetailEntity();
							entity.setSourceId(jsonObject.getString("pkMtCtplanB"));
							entity.setMaterialSourceId(jsonObject.getString("pkInvbasdoc"));
							entity.setNum(jsonObject.getBigDecimal("nnmum"));
							entity.setMemo(jsonObject.getString("vmemo"));
							entity.setTenantId(Long.valueOf(tenantId));
							LambdaQueryWrapper<CtPlanDetailEntity> queryDetailWrapper = new LambdaQueryWrapper<>();
							queryDetailWrapper.eq(CtPlanDetailEntity::getSourceId, entity.getSourceId());
							CtPlanDetailEntity dbDetaliEntity = ctPlanDetailService.getOne(queryDetailWrapper, false);
							if(null == dbDetaliEntity){
								//新增
								entity.setId(IdWorker.getId());
							}else {
								entity.setId(dbDetaliEntity.getId());
							}

							LambdaQueryWrapper<CtPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
							queryWrapper.eq(CtPlanEntity::getSourceId, jsonObject.getString("pkMtCtplan"));
							CtPlanEntity dbEntity = ctPlanService.getOne(queryWrapper, false);
							entity.setCtId(dbEntity != null ? dbEntity.getId() : null);

							if(entity.getMaterialSourceId() != null){
								CommonResponse<MaterialVO> materialVOCommonResponse = materialApi.queryMaterialBySourceId(entity.getMaterialSourceId());
								if(materialVOCommonResponse.isSuccess()){
									MaterialVO materialVO = materialVOCommonResponse.getData();
									entity.setMaterialId(materialVO.getId());
									entity.setMaterialCode(materialVO.getCode());
									entity.setMaterialName(materialVO.getName());
									entity.setUnit(materialVO.getUnitName());
									entity.setSpec(materialVO.getSpec());
									entity.setDef1(materialVO.getDef1());//规格
									entity.setDef2(materialVO.getDef2());//型号
									entity.setDef3(materialVO.getDef3());//来源物料主键
									entity.setMaterialTypeId(materialVO.getCategoryId());


									CommonResponse<MaterialCategoryVO> materialCategoryVOCommonResponse = materialApi.queryCategoryById(materialVO.getCategoryId());
									if(materialCategoryVOCommonResponse.isSuccess()){
										MaterialCategoryVO materialCategoryVO = materialCategoryVOCommonResponse.getData();
										entity.setMaterialTypeName(materialCategoryVO.getName());
										entity.setMaterialSourceTypeId(materialCategoryVO.getSourceId());
									}
								}
							}
							entityList.add(entity);
						}
					}
				}
			}
		}
		ctPlanDetailService.saveOrUpdateBatch(entityList);
		logger.info("保存消耗材总控计划表体开始--------》》》"+ entityList.size());
		return CommonResponse.success("保存消耗材总控计划表体成功！");
	}
}
