package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.WeighReportEntity;
import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.WeighReportSaveVO;
import com.ejianc.business.wzxt.vo.WeighReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 智能称重台账实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("weighReport")
public class WeighReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWeighReportService weighReportService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 推单
     *
     * @return
     */
    @PostMapping(value = "/push")
    @ResponseBody
    public CommonResponse<Boolean> push(@RequestBody WeighReportSaveVO weighReportVO) {
        return weighReportService.push(weighReportVO);
    }

    /**
     * 删除
     *
     * @return
     */
    @GetMapping(value = "/del")
    @ResponseBody
    public CommonResponse<Boolean> push(String pkWeighBill) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper<WeighReportEntity>().eq(WeighReportEntity::getPkWeighBill, pkWeighBill);
        if(weighReportService.remove(wrapper)){
            return CommonResponse.success(Boolean.TRUE);
        } else {
            return CommonResponse.error("删除失败！");
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeighReportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("consigneeUnit");// 收货单位、收货项目
        fuzzyFields.add("forwardingUnit");// 发货单位、供应商
        fuzzyFields.add("contractPurchaseName");// 合同名称
        fuzzyFields.add("contractPurchaseCode");// 合同编号
        fuzzyFields.add("plateNumber");// 车牌号
        fuzzyFields.add("materialName");// 物料名称
        fuzzyFields.add("materialCode");// 物料编号
        fuzzyFields.add("materialSpec");// 规格型号
        fuzzyFields.add("planBody");// 工程部位
        fuzzyFields.add("orderCode");// 订单编号
        fuzzyFields.add("deliveryCode");// 发货单号
        fuzzyFields.add("checkCode");// 验收单号

        Long orgId = InvocationInfoProxy.getOrgId();
        if(null != orgId && orgId > 0){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("projOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projOrgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<WeighReportEntity> page = weighReportService.queryPage(param,false);
        IPage<WeighReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<IPage<WeighReportVO>> res = this.queryList(param);
        List<WeighReportVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null){
            list = res.getData().getRecords();
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                String checkStattusName = "";
                if(vo.getCheckStatus() != null && vo.getCheckStatus() == 1) {
                    checkStattusName = "已推送NC";
                } else {
                    checkStattusName = "未推送NC";
                }
                vo.setCheckStatusName(checkStattusName);
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("weighReportExport.xlsx", beans, response);
    }

}
